/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.reload;

import crafttweaker.IAction;
import youyihj.zenutils.impl.util.SimpleCache;

public abstract class ActionReloadCallback<T extends IAction> {
    private static final SimpleCache<Class<?>, Boolean> HAS_UNDO_METHOD_CACHE = new SimpleCache<Class, Boolean>(it -> {
        try {
            it.getDeclaredMethod("undo", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    });
    protected final T action;

    public ActionReloadCallback(T action) {
        this.action = action;
    }

    public void applyReload() {
        this.action.apply();
    }

    public void undo() {
    }

    public void beforeApply(boolean reload) {
    }

    public void afterApply(boolean reload) {
    }

    public boolean hasUndoMethod() {
        return HAS_UNDO_METHOD_CACHE.get(this.getClass());
    }

    public String describeAction() {
        return this.action.describe();
    }
}

