/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.player;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityEquipmentSlot;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumActionResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;
import youyihj.zenutils.api.item.CrTItemHandler;
import youyihj.zenutils.api.player.IActionResult;
import youyihj.zenutils.api.player.PlayerStat;
import youyihj.zenutils.impl.player.PlayerInteractionSimulation;

@ZenRegister
@ZenExpansion(value="crafttweaker.player.IPlayer")
public class ZenUtilsPlayer {
    @ZenMethod
    public static boolean replaceItemInInventory(IPlayer iPlayer, int inventorySlot, IItemStack itemStack) {
        return CraftTweakerMC.getPlayer((IPlayer)iPlayer).func_174820_d(inventorySlot, CraftTweakerMC.getItemStack((IItemStack)itemStack));
    }

    @ZenMethod
    public static CrTItemHandler getPlayerInventoryItemHandler(IPlayer player) {
        return CrTItemHandler.of((IItemHandler)CraftTweakerMC.getPlayer((IPlayer)player).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
    }

    @ZenMethod
    public static int readStat(IPlayer player, PlayerStat stat) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (mcPlayer instanceof EntityPlayerMP) {
            return ((EntityPlayerMP)mcPlayer).func_147099_x().func_77444_a(stat.getInternal());
        }
        return 0;
    }

    @ZenMethod
    public static void addStat(IPlayer player, PlayerStat stat, @Optional(valueLong=1L) int amount) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        mcPlayer.func_71064_a(stat.getInternal(), amount);
    }

    @ZenMethod
    public static void takeStat(IPlayer player, PlayerStat stat) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        mcPlayer.func_175145_a(stat.getInternal());
    }

    @ZenMethod
    @ZenGetter(value="fake")
    public static boolean isFake(IPlayer player) {
        return CraftTweakerMC.getPlayer((IPlayer)player) instanceof FakePlayer;
    }

    @ZenMethod
    @ZenGetter(value="xpPoints")
    public static int getXpPoints(IPlayer player) {
        return CraftTweakerMC.getPlayer((IPlayer)player).field_71067_cb;
    }

    @ZenMethod
    @ZenSetter(value="xpPoints")
    public static void setXpPoints(IPlayer player, int xpPoints) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        mcPlayer.func_82242_a(-mcPlayer.field_71068_ca - 1);
        mcPlayer.func_71023_q(xpPoints);
    }

    @ZenMethod
    public static IActionResult<EnumActionResult> simulateRightClickItem(IPlayer player, IItemStack stack, @Optional IEntityEquipmentSlot hand) {
        return PlayerInteractionSimulation.simulateRightClickItem(player, stack, hand);
    }

    @ZenMethod
    public static IActionResult<EnumActionResult> simulateRightClickBlock(IPlayer player, IItemStack stack, @Optional IEntityEquipmentSlot hand, @Optional IBlockPos pos, @Optional IFacing facing, @Optional(valueDouble=-1.0) float hitX, @Optional(valueDouble=-1.0) float hitY, @Optional(valueDouble=-1.0) float hitZ) {
        return PlayerInteractionSimulation.simulateRightClickBlock(player, stack, hand, pos, facing, hitX, hitY, hitZ);
    }

    @ZenMethod
    public static IActionResult<EnumActionResult> simulateRightClickEntity(IPlayer player, IEntity entity, @Optional IItemStack stack, @Optional IEntityEquipmentSlot hand) {
        return PlayerInteractionSimulation.simulateRightClickEntity(player, entity, stack, hand);
    }

    @ZenMethod
    public static IActionResult<Void> simulateLeftClickBlock(IPlayer player, @Optional IItemStack stack, @Optional IBlockPos pos, @Optional IFacing side) {
        return PlayerInteractionSimulation.simulateLeftClickBlock(player, stack, pos, side);
    }

    @ZenMethod
    public static IItemStack simulateUseItemFinish(IPlayer player, IItemStack itemStack, @Optional IEntityEquipmentSlot hand) {
        return PlayerInteractionSimulation.simulateUseItemFinish(player, itemStack, hand);
    }
}

