/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.player;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlockDefinition;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.item.IItemDefinition;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatBasic;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.registry.EntityEntry;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.player.IStatFormatter;
import youyihj.zenutils.impl.zenscript.Defaults;

@ZenRegister
@ZenClass(value="mods.zenutils.PlayerStat")
public class PlayerStat {
    private final StatBase internal;

    public PlayerStat(StatBase internal) {
        this.internal = internal;
    }

    public static PlayerStat of(StatBase stat) {
        return stat != null ? new PlayerStat(stat) : null;
    }

    @ZenMethod
    public static PlayerStat getBasicStat(String id) {
        StatBase stat = StatList.func_151177_a((String)id);
        if (stat == null) {
            throw new IllegalArgumentException("Stat " + id + " does not exist!");
        }
        return PlayerStat.of(stat);
    }

    @ZenMethod
    public static PlayerStat getBlockStats(IBlockDefinition block) {
        return PlayerStat.of(StatList.func_188055_a((Block)CraftTweakerMC.getBlock((IBlockDefinition)block)));
    }

    @ZenMethod
    public static PlayerStat getCraftStats(IItemDefinition item) {
        return PlayerStat.of(StatList.func_188060_a((Item)CraftTweakerMC.getItem((IItemDefinition)item)));
    }

    @ZenMethod
    public static PlayerStat getObjectUseStats(IItemDefinition item) {
        return PlayerStat.of(StatList.func_188057_b((Item)CraftTweakerMC.getItem((IItemDefinition)item)));
    }

    @ZenMethod
    public static PlayerStat getObjectBreakStats(IItemDefinition item) {
        return PlayerStat.of(StatList.func_188059_c((Item)CraftTweakerMC.getItem((IItemDefinition)item)));
    }

    @ZenMethod
    public static PlayerStat getObjectsPickedUpStats(IItemDefinition item) {
        return PlayerStat.of(StatList.func_188056_d((Item)CraftTweakerMC.getItem((IItemDefinition)item)));
    }

    @ZenMethod
    public static PlayerStat getDroppedObjectStats(IItemDefinition item) {
        return PlayerStat.of(StatList.func_188058_e((Item)CraftTweakerMC.getItem((IItemDefinition)item)));
    }

    @ZenMethod
    public static PlayerStat getKillEntityStats(IEntityDefinition entity) {
        EntityEntry internal = (EntityEntry)entity.getInternal();
        return PlayerStat.of(internal.getEgg().field_151512_d);
    }

    @ZenMethod
    public static PlayerStat getKilledByEntityStats(IEntityDefinition entity) {
        EntityEntry internal = (EntityEntry)entity.getInternal();
        return PlayerStat.of(internal.getEgg().field_151513_e);
    }

    @ZenMethod
    public static PlayerStat create(String id, crafttweaker.api.text.ITextComponent name, @Optional(methodClass=Defaults.class, methodName="statFormatter") IStatFormatter formatter) {
        if (Loader.instance().getLoaderState().compareTo((Enum)LoaderState.AVAILABLE) > 0) {
            return java.util.Optional.ofNullable(StatList.func_151177_a((String)id)).map(PlayerStat::new).orElseThrow(() -> new IllegalStateException("Could not create a new stat after game initialization."));
        }
        return PlayerStat.of(new StatBasic(id, CraftTweakerMC.getITextComponent((crafttweaker.api.text.ITextComponent)name), formatter.toType()).func_75971_g());
    }

    @ZenMethod
    @ZenGetter(value="name")
    public crafttweaker.api.text.ITextComponent getName() {
        return CraftTweakerMC.getITextComponent((ITextComponent)this.internal.func_150951_e());
    }

    public StatBase getInternal() {
        return this.internal;
    }
}

