/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.logger;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import youyihj.zenutils.api.logger.ILogFilter;
import youyihj.zenutils.api.logger.LogLevel;
import youyihj.zenutils.api.logger.ScriptPosition;

public class RegexLogFilter
implements ILogFilter {
    private final Pattern regex;

    public RegexLogFilter(Pattern regex) {
        this.regex = regex;
    }

    @Override
    public boolean isBlock(String message, LogLevel logLevel, @Nullable ScriptPosition scriptPosition) {
        return this.regex.matcher(message).matches();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexLogFilter that = (RegexLogFilter)o;
        return Objects.equals(this.regex.pattern(), that.regex.pattern());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regex.pattern());
    }
}

