/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.item;

import com.google.common.collect.Multimap;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import com.teamacronymcoders.contenttweaker.api.ctobjects.resourcelocation.CTResourceLocation;
import com.teamacronymcoders.contenttweaker.api.ctobjects.world.IWorld;
import com.teamacronymcoders.contenttweaker.api.ctobjects.world.MCWorld;
import com.teamacronymcoders.contenttweaker.modules.vanilla.items.ItemContent;
import com.teamacronymcoders.contenttweaker.modules.vanilla.items.ItemRepresentation;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import youyihj.zenutils.api.cotx.annotation.ExpandContentTweakerEntry;
import youyihj.zenutils.api.cotx.item.ExpandItemRepresentation;

@ExpandContentTweakerEntry
public class ExpandItemContent
extends ItemContent {
    private static final int DEFAULT_MAX_ITEM_USE_DURATION = 32;
    private final ExpandItemRepresentation expandItemRepresentation;

    public ExpandItemContent(ExpandItemRepresentation itemRepresentation) {
        super((ItemRepresentation)itemRepresentation);
        this.expandItemRepresentation = itemRepresentation;
        if (this.expandItemRepresentation.noRepair) {
            this.setNoRepair();
        }
        if (!this.expandItemRepresentation.toolClass.isEmpty()) {
            this.func_77664_n();
        }
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return Objects.nonNull(this.expandItemRepresentation.onEntityItemUpdate) && this.expandItemRepresentation.onEntityItemUpdate.update(CraftTweakerMC.getIEntityItem((EntityItem)entityItem));
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        if (Objects.isNull(this.expandItemRepresentation.getEntityLifeSpan)) {
            return super.getEntityLifespan(itemStack, world);
        }
        return this.expandItemRepresentation.getEntityLifeSpan.get(CraftTweakerMC.getIItemStack((ItemStack)itemStack), (IWorld)new MCWorld(world));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ActionResult actionResult = super.func_77659_a(world, player, hand);
        if (actionResult.func_188397_a() == EnumActionResult.SUCCESS) {
            player.func_184598_c(hand);
        }
        return actionResult;
    }

    public int func_77626_a(ItemStack stack) {
        return this.expandItemRepresentation.onItemUseFinish != null && this.expandItemRepresentation.maxItemUseDuration == 0 ? 32 : this.expandItemRepresentation.maxItemUseDuration;
    }

    public int func_77619_b() {
        return this.expandItemRepresentation.enchantability;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        IIngredient repairItem = this.expandItemRepresentation.repairItem;
        if (repairItem != null) {
            return repairItem.matches(CraftTweakerMC.getIItemStackForMatching((ItemStack)repair));
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        String toolClass = this.expandItemRepresentation.toolClass;
        if (this.expandItemRepresentation.destroySpeed == 0.0f || toolClass.isEmpty() || this.expandItemRepresentation.itemDestroySpeed != null) {
            return super.func_150893_a(stack, state);
        }
        if (state.func_177230_c().isToolEffective(toolClass, state)) {
            return this.expandItemRepresentation.destroySpeed;
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        String toolClass = this.expandItemRepresentation.toolClass;
        if (toolClass.isEmpty() || this.expandItemRepresentation.itemDestroyedBlock != null) {
            return super.func_179218_a(stack, world, state, pos, entityLiving);
        }
        if (!world.field_72995_K && state.func_185887_b(world, pos) != 0.0f) {
            stack.func_77972_a(1, entityLiving);
            return true;
        }
        return false;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        String toolClass = this.expandItemRepresentation.toolClass;
        if (!toolClass.isEmpty()) {
            stack.func_77972_a(toolClass.equals("sword") ? 1 : 2, attacker);
            return true;
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.expandItemRepresentation.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.expandItemRepresentation.attackSpeed, 0));
        }
        return multimap;
    }

    public List<IGeneratedModel> getGeneratedModels() {
        if (!this.expandItemRepresentation.toolClass.isEmpty()) {
            TemplateFile templateFile = TemplateManager.getTemplateFile((ResourceLocation)new ResourceLocation("zenutils", "item_tool"));
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("texture", Optional.ofNullable(this.expandItemRepresentation.getTextureLocation()).map(CTResourceLocation::getInternal).map(ResourceLocation::toString).orElseGet(() -> "contenttweaker:items/" + this.expandItemRepresentation.getUnlocalizedName()));
            templateFile.replaceContents(replacements);
            return Collections.singletonList(new GeneratedModel(this.expandItemRepresentation.getUnlocalizedName(), ModelType.ITEM_MODEL, templateFile.getFileContents()));
        }
        return super.getGeneratedModels();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        boolean result = super.canApplyAtEnchantingTable(stack, enchantment);
        String toolClass = this.expandItemRepresentation.toolClass;
        if ("sword".equals(toolClass)) {
            result |= enchantment.field_77351_y == EnumEnchantmentType.WEAPON;
        } else if (!toolClass.isEmpty()) {
            result |= enchantment.field_77351_y == EnumEnchantmentType.DIGGER;
        }
        return result;
    }

    @ExpandContentTweakerEntry.RepresentationGetter
    public ExpandItemRepresentation getExpandItemRepresentation() {
        return this.expandItemRepresentation;
    }
}

