/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.command;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import youyihj.zenutils.api.command.IZenCommand;
import youyihj.zenutils.api.reload.Reloadable;

@Reloadable
public class ZenCommandRegisterAction
implements IAction {
    private final IZenCommand command;

    public ZenCommandRegisterAction(IZenCommand command) {
        this.command = command;
    }

    public void apply() {
        Objects.requireNonNull(ApplyLogic.INSTANCE.commandHandler).func_71560_a((ICommand)this.command);
    }

    public void undo() {
        CommandHandler commandHandler = ApplyLogic.INSTANCE.getCommandHandler();
        commandHandler.func_71555_a().remove(this.command.func_71517_b());
        commandHandler.field_71561_b.remove(this.command);
        ApplyLogic.INSTANCE.toApplyActions.remove(this);
    }

    public String describe() {
        return "Registering ZenCommand " + this.command.func_71517_b();
    }

    public static enum ApplyLogic {
        INSTANCE;

        private final List<ZenCommandRegisterAction> toApplyActions = new LinkedList<ZenCommandRegisterAction>();
        private CommandHandler commandHandler;

        public void apply(ZenCommandRegisterAction action) {
            this.toApplyActions.add(action);
            if (this.commandHandler != null) {
                CraftTweakerAPI.apply((IAction)action);
            }
        }

        public void init(CommandHandler commandHandler) {
            this.commandHandler = commandHandler;
            this.toApplyActions.forEach(CraftTweakerAPI::apply);
        }

        public void clean() {
            this.commandHandler = null;
        }

        public CommandHandler getCommandHandler() {
            return this.commandHandler;
        }
    }
}

