/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.item;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.model.CustomModelItem;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ItemArmorBase
extends ItemArmor
implements IModeledObject,
ICustomModeledObject {
    private boolean hasCustomModel;
    private String armor1;
    private String armor2;

    public ItemArmorBase(String name, ItemArmor.ArmorMaterial materialIn, EntityEquipmentSlot equipmentSlotIn, ResourceLocation armor) {
        super(materialIn, 0, equipmentSlotIn);
        this.armor1 = armor.toString() + "_1.png";
        this.armor2 = armor.toString() + "_2.png";
        this.func_77655_b(name);
        this.setRegistryName(LibRegistry.getActiveModid(), name);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (slot == EntityEquipmentSlot.LEGS) {
            return this.armor2;
        }
        return this.armor1;
    }

    public ItemArmorBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
    }

    @Override
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation texture = new ResourceLocation(this.getRegistryName().func_110624_b() + ":items/" + this.getRegistryName().func_110623_a());
            CustomModelItem item = new CustomModelItem(false, texture);
            item.addTexture("particle", texture);
            CustomModelLoader.itemmodels.put(this.getRegistryName(), item);
        }
    }
}

