/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integratedtunnels.core.FluidStorageBlockWrapper;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateFluidStackList;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateFluidStackNbt;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateFluidStackOperator;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;

public class TunnelFluidHelpers {
    public static final IngredientPredicate<FluidStack, Integer> MATCH_NONE = new IngredientPredicate<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, null, Integer.valueOf(7), false, true, 0, false){

        @Override
        public boolean test(FluidStack input) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == MATCH_NONE;
        }

        @Override
        public int hashCode() {
            return 9991029;
        }
    };

    public static IngredientPredicate<FluidStack, Integer> matchAll(int amount, boolean exactAmount) {
        return new IngredientPredicate<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, new FluidStack(FluidRegistry.WATER, amount), Integer.valueOf(exactAmount ? 4 : 0), false, false, amount, exactAmount){

            @Override
            public boolean test(FluidStack input) {
                return true;
            }
        };
    }

    public static IngredientPredicate<FluidStack, Integer> matchFluidStack(final FluidStack fluidStack, final boolean checkFluid, final boolean checkAmount, final boolean checkNbt, final boolean blacklist, boolean exactAmount) {
        int matchFlags = 0;
        if (checkFluid) {
            matchFlags |= 1;
        }
        if (checkNbt) {
            matchFlags |= 2;
        }
        if (checkAmount) {
            matchFlags |= 4;
        }
        return new IngredientPredicate<FluidStack, Integer>(IngredientComponent.FLUIDSTACK, fluidStack != null ? fluidStack.copy() : null, Integer.valueOf(matchFlags), blacklist, fluidStack == null && !blacklist, FluidHelpers.getAmount((FluidStack)fluidStack), exactAmount){

            @Override
            public boolean test(@Nullable FluidStack input) {
                boolean result = TunnelFluidHelpers.areFluidStackEqual(input, fluidStack, checkFluid, checkAmount, checkNbt);
                if (blacklist) {
                    result = !result;
                }
                return result;
            }
        };
    }

    public static IngredientPredicate<FluidStack, Integer> matchFluidStacks(IValueTypeListProxy<ValueObjectTypeFluidStack, ValueObjectTypeFluidStack.ValueFluidStack> fluidStacks, boolean checkFluid, boolean checkAmount, boolean checkNbt, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateFluidStackList(blacklist, amount, exactAmount, fluidStacks, checkFluid, checkAmount, checkNbt);
    }

    public static IngredientPredicate<FluidStack, Integer> matchPredicate(PartTarget partTarget, IOperator predicate, int amount, boolean exactAmount) {
        return new IngredientPredicateFluidStackOperator(amount, exactAmount, predicate, partTarget);
    }

    public static IngredientPredicate<FluidStack, Integer> matchNbt(NBTTagCompound tag, boolean subset, boolean superset, boolean requireNbt, boolean recursive, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateFluidStackNbt(blacklist, amount, exactAmount, requireNbt, subset, tag, recursive, superset);
    }

    public static boolean areFluidStackEqual(FluidStack stackA, FluidStack stackB, boolean checkFluid, boolean checkAmount, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkAmount && stackA.amount != stackB.amount) {
                return false;
            }
            if (checkFluid && stackA.getFluid() != stackB.getFluid()) {
                return false;
            }
            return !checkNbt || FluidStack.areFluidStackTagsEqual((FluidStack)stackA, (FluidStack)stackB);
        }
        return false;
    }

    public static FluidStack placeFluids(INetwork network, IPositionedAddonsNetworkIngredients<FluidStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, IIngredientComponentStorage<FluidStack, Integer> source, World world, BlockPos pos, IngredientPredicate<FluidStack, Integer> fluidStackMatcher, boolean blockUpdate, boolean ignoreReplacable, boolean craftIfFailed) throws EvaluationException {
        IBlockState destBlockState = world.func_180495_p(pos);
        Material destMaterial = destBlockState.func_185904_a();
        boolean isDestNonSolid = !destMaterial.func_76220_a();
        boolean isDestReplaceable = destBlockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
        if (!(world.func_175623_d(pos) || isDestNonSolid && ignoreReplacable && isDestReplaceable && !destMaterial.func_76224_d())) {
            return null;
        }
        FluidStorageBlockWrapper destination = new FluidStorageBlockWrapper((WorldServer)world, pos, null, blockUpdate);
        return TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, source, -1, destination, -1, fluidStackMatcher, PartPos.of((World)world, (BlockPos)pos, null), craftIfFailed);
    }

    public static FluidStack pickUpFluids(INetwork network, IPositionedAddonsNetworkIngredients<FluidStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, World world, BlockPos pos, EnumFacing side, IIngredientComponentStorage<FluidStack, Integer> destination, IngredientPredicate<FluidStack, Integer> fluidStackMatcher) throws EvaluationException {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            FluidStorageBlockWrapper source = new FluidStorageBlockWrapper((WorldServer)world, pos, side, false);
            return TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, source, -1, destination, -1, fluidStackMatcher, PartPos.of((World)world, (BlockPos)pos, (EnumFacing)side), false);
        }
        return null;
    }

    public static FluidStack prototypeWithCount(FluidStack prototype, int count) {
        if (prototype == null || prototype.amount != count) {
            if (prototype == null) {
                return count == 0 ? null : new FluidStack(FluidRegistry.WATER, count);
            }
            prototype = new FluidStack(prototype, count);
        }
        return prototype;
    }
}

