/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integratedtunnels.core.TunnelHelpers;

public class TunnelEnergyHelpers {
    public static int moveEnergy(INetwork network, IPositionedAddonsNetworkIngredients<Integer, Boolean> ingredientsNetwork, int channel, IIngredientComponentStorage<Integer, Boolean> source, IIngredientComponentStorage<Integer, Boolean> target, int amount, boolean exact, boolean craftIfFailed) throws EvaluationException {
        int moved;
        try {
            moved = (Integer)IngredientStorageHelpers.moveIngredients(source, target, (Object)amount, (Object)exact, (boolean)false);
        }
        catch (InconsistentIngredientInsertionException e) {
            throw new EvaluationException("Ingredient movement failed due to inconsistent insertion behaviour by destination in simulation and non-simulation mode. This can be caused by invalid network setups. Lost " + e.getIngredientComponent().getMatcher().localize(e.getRemainder()) + ".");
        }
        ingredientsNetwork.scheduleObservation();
        if (craftIfFailed && moved == 0 && (Integer)target.insert((Object)amount, true) == amount) {
            TunnelHelpers.requestCrafting(network, ingredientsNetwork, channel, amount, exact);
        }
        return moved;
    }
}

