/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.nbt;

import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class OwnerData {
    private long ownerUUIDMost;
    private long ownerUUIDLeast;
    private String ownerName;
    private UUID ownerUUID;
    private boolean isPublic;

    public OwnerData(Entity entity) {
        UUID uuid;
        this.ownerUUID = uuid = entity.func_110124_au();
        this.ownerUUIDMost = uuid != null ? uuid.getMostSignificantBits() : 0L;
        this.ownerUUIDLeast = uuid != null ? uuid.getLeastSignificantBits() : 0L;
        this.ownerName = entity.func_70005_c_();
        this.isPublic = true;
    }

    public OwnerData(String name, boolean isPublic) {
        this.ownerName = name;
        this.isPublic = isPublic;
    }

    private OwnerData() {
        this.ownerName = "";
        this.isPublic = true;
    }

    public boolean getIsPublic() {
        return this.isPublic;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return OwnerData.writeOwnerTagToNBT(nbt, this.ownerUUIDMost, this.ownerUUIDLeast, this.ownerName, this.isPublic);
    }

    public static NBTTagCompound writeOwnerTagToNBT(NBTTagCompound nbt, Entity entity) {
        return OwnerData.writeOwnerTagToNBT(nbt, entity, true);
    }

    public static void addOwnerDataToItemOptional(ItemStack stack, Entity entity) {
        OwnerData.addOwnerDataToItemOptional(stack, entity, false);
    }

    public static void addOwnerDataToItemOptional(ItemStack stack, Entity entity, boolean isPublic) {
        OwnerData data = OwnerData.getOwnerDataFromItem(stack);
        if (data == null) {
            OwnerData.writeOwnerTagToItem(stack, entity, isPublic);
        }
    }

    public static void addOwnerDataToSelectedModuleOptional(ItemStack toolStack, ItemModule.ModuleType moduleType, Entity entity) {
        OwnerData.addOwnerDataToSelectedModuleOptional(toolStack, moduleType, entity, false);
    }

    public static void addOwnerDataToSelectedModuleOptional(ItemStack toolStack, ItemModule.ModuleType moduleType, Entity entity, boolean isPublic) {
        OwnerData data = OwnerData.getOwnerDataFromSelectedModule(toolStack, moduleType);
        if (data == null) {
            OwnerData.writeOwnerTagToSelectedModule(toolStack, moduleType, entity, isPublic);
        }
    }

    public static void togglePrivacyModeOnItem(ItemStack stack, Entity entity) {
        OwnerData data = OwnerData.getOwnerDataFromItem(stack);
        if (data == null) {
            OwnerData.addOwnerDataToItemOptional(stack, entity);
        } else if (data.isOwner(entity)) {
            data.isPublic = !data.isPublic;
            data.writeToItem(stack);
        }
    }

    public static void togglePrivacyModeOnSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, Entity entity) {
        OwnerData data = OwnerData.getOwnerDataFromSelectedModule(toolStack, moduleType);
        if (data == null) {
            OwnerData.addOwnerDataToSelectedModuleOptional(toolStack, moduleType, entity);
        } else if (data.isOwner(entity)) {
            data.isPublic = !data.isPublic;
            data.writeToSelectedModule(toolStack, moduleType);
        }
    }

    public static OwnerData getOwnerDataFromNBT(NBTTagCompound nbt) {
        return new OwnerData().readFromNBT(nbt);
    }

    public static OwnerData getOwnerDataFromItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            return OwnerData.getOwnerDataFromNBT(stack.func_77978_p());
        }
        return null;
    }

    public static OwnerData getOwnerDataFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        return OwnerData.getOwnerDataFromItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType));
    }

    public boolean isOwner(Entity entity) {
        if (entity == null) {
            return false;
        }
        return this.ownerUUID != null && this.ownerUUID.equals(entity.func_110124_au());
    }

    private boolean isOwner(UUID uuid) {
        if (uuid == null) {
            return false;
        }
        return this.ownerUUID != null && this.ownerUUID.equals(uuid);
    }

    public boolean canAccess(Entity entity) {
        return this.isPublic || this.isOwner(entity);
    }

    public boolean canAccess(UUID uuid) {
        return this.isPublic || this.isOwner(uuid);
    }

    public static boolean canAccessItem(ItemStack stack, @Nullable Entity entity) {
        return OwnerData.canAccessItem(stack, entity != null ? entity.func_110124_au() : null);
    }

    public static boolean canAccessItem(ItemStack stack, @Nullable UUID uuid) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            return true;
        }
        OwnerData data = OwnerData.getOwnerDataFromItem(stack);
        return data == null || data.isPublic || data.isOwner(uuid);
    }

    public static boolean canAccessSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, @Nullable Entity entity) {
        return OwnerData.canAccessItem(UtilItemModular.getSelectedModuleStack(toolStack, moduleType), entity);
    }

    private static boolean nbtHasOwnerTag(NBTTagCompound nbt) {
        NBTTagCompound tag;
        if (nbt == null) {
            return false;
        }
        if (!nbt.func_150297_b("Owner", 10) && !nbt.func_150297_b("Player", 10)) {
            return false;
        }
        NBTTagCompound nBTTagCompound = tag = nbt.func_150297_b("Owner", 10) ? nbt.func_74775_l("Owner") : nbt.func_74775_l("Player");
        return tag != null && tag.func_150297_b("UUIDM", 4) && tag.func_150297_b("UUIDL", 4) && tag.func_150297_b("Name", 8);
    }

    private OwnerData readFromNBT(NBTTagCompound nbt) {
        if (!OwnerData.nbtHasOwnerTag(nbt)) {
            return null;
        }
        NBTTagCompound tag = nbt.func_150297_b("Owner", 10) ? nbt.func_74775_l("Owner") : nbt.func_74775_l("Player");
        this.ownerUUIDMost = tag.func_74763_f("UUIDM");
        this.ownerUUIDLeast = tag.func_74763_f("UUIDL");
        this.ownerName = tag.func_74779_i("Name");
        this.isPublic = tag.func_74767_n("Public");
        this.ownerUUID = new UUID(this.ownerUUIDMost, this.ownerUUIDLeast);
        return this;
    }

    private static NBTTagCompound writeOwnerTagToNBT(NBTTagCompound nbt, long uuidMost, long uuidLeast, String name, boolean isPublic) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("UUIDM", uuidMost);
        tag.func_74772_a("UUIDL", uuidLeast);
        tag.func_74778_a("Name", name);
        tag.func_74757_a("Public", isPublic);
        nbt.func_74782_a("Owner", (NBTBase)tag);
        return nbt;
    }

    private static NBTTagCompound writeOwnerTagToNBT(NBTTagCompound nbt, Entity entity, boolean isPublic) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (entity == null) {
            nbt.func_82580_o("Owner");
            nbt.func_82580_o("Player");
            return nbt;
        }
        return OwnerData.writeOwnerTagToNBT(nbt, entity.func_110124_au().getMostSignificantBits(), entity.func_110124_au().getLeastSignificantBits(), entity.func_70005_c_(), isPublic);
    }

    private static void writeOwnerTagToItem(ItemStack stack, Entity entity, boolean isPublic) {
        stack.func_77982_d(OwnerData.writeOwnerTagToNBT(stack.func_77978_p(), entity, isPublic));
    }

    public static boolean removeOwnerDataFromItem(ItemStack stack, Entity entity) {
        OwnerData ownerData = OwnerData.getOwnerDataFromItem(stack);
        if (ownerData != null && ownerData.isOwner(entity)) {
            stack.func_77978_p().func_82580_o("Owner");
            if (stack.func_77978_p().func_82582_d()) {
                stack.func_77982_d(null);
            }
            return true;
        }
        return false;
    }

    public static boolean removeOwnerDataFromSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, Entity entity) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (!moduleStack.func_190926_b()) {
            OwnerData.removeOwnerDataFromItem(moduleStack, entity);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    private static boolean writeOwnerTagToSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType, Entity entity, boolean isPublic) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (!moduleStack.func_190926_b()) {
            OwnerData.writeOwnerTagToItem(moduleStack, entity, isPublic);
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }

    private boolean writeToItem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            stack.func_77982_d(this.writeToNBT(stack.func_77978_p()));
            return true;
        }
        return false;
    }

    private boolean writeToSelectedModule(ItemStack toolStack, ItemModule.ModuleType moduleType) {
        ItemStack moduleStack = UtilItemModular.getSelectedModuleStack(toolStack, moduleType);
        if (!moduleStack.func_190926_b()) {
            if (!this.writeToItem(moduleStack)) {
                return false;
            }
            UtilItemModular.setSelectedModuleStack(toolStack, moduleType, moduleStack);
            return true;
        }
        return false;
    }
}

