/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class BlockPosEU {
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int dimension;
    private final EnumFacing facing;

    public BlockPosEU(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockPosEU(int x, int y, int z) {
        this(x, y, z, 0, EnumFacing.DOWN);
    }

    public BlockPosEU(int x, int y, int z, int dim) {
        this(x, y, z, dim, EnumFacing.DOWN);
    }

    public BlockPosEU(BlockPos pos, int dim, int facing) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim, EnumFacing.func_82600_a((int)facing));
    }

    public BlockPosEU(BlockPos pos, int dim, EnumFacing facing) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim, facing);
    }

    public BlockPosEU(int x, int y, int z, int dim, EnumFacing facing) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dimension = dim;
        this.facing = facing != null ? facing : EnumFacing.DOWN;
    }

    public int getX() {
        return this.posX;
    }

    public int getY() {
        return this.posY;
    }

    public int getZ() {
        return this.posZ;
    }

    public int getDimension() {
        return this.dimension;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public BlockPosEU add(BlockPosEU pos) {
        return this.add(pos.posX, pos.posY, pos.posZ);
    }

    public BlockPosEU subtract(BlockPosEU other) {
        return this.add(-other.posX, -other.posY, -other.posZ);
    }

    public BlockPosEU add(int x, int y, int z) {
        if (x == 0 && y == 0 && z == 0) {
            return this;
        }
        return new BlockPosEU(this.posX + x, this.posY + y, this.posZ + z, this.dimension, this.facing);
    }

    public BlockPosEU offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public BlockPosEU offset(EnumFacing facing, int distance) {
        return new BlockPosEU(this.posX + facing.func_82601_c() * distance, this.posY + facing.func_96559_d() * distance, this.posZ + facing.func_82599_e() * distance, this.dimension, this.facing);
    }

    public boolean isWithinDistance(Entity entity, double maxDist) {
        return this.isWithinDistance(entity.func_174791_d(), entity.func_130014_f_().field_73011_w.getDimension(), maxDist);
    }

    public boolean isWithinDistance(Vec3d pos, int dimension, double maxDist) {
        double dx = pos.field_72450_a - (double)this.posX;
        double dy = pos.field_72448_b - (double)this.posY;
        double dz = pos.field_72449_c - (double)this.posZ;
        return this.dimension == dimension && dx * dx + dy * dy + dz * dz <= maxDist * maxDist;
    }

    public BlockPosEU clampCoordsToWorldBounds() {
        int x = MathHelper.func_76125_a((int)this.posX, (int)-30000000, (int)30000000);
        int y = MathHelper.func_76125_a((int)this.posY, (int)0, (int)255);
        int z = MathHelper.func_76125_a((int)this.posZ, (int)-30000000, (int)30000000);
        return new BlockPosEU(x, y, z, this.dimension, this.facing);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.posX, this.posY, this.posZ);
    }

    public NBTTagCompound writeToTag(NBTTagCompound tag) {
        tag.func_74768_a("posX", this.posX);
        tag.func_74768_a("posY", this.posY);
        tag.func_74768_a("posZ", this.posZ);
        tag.func_74768_a("dim", this.dimension);
        tag.func_74774_a("face", (byte)this.facing.func_176745_a());
        return tag;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74782_a("BlockPos", (NBTBase)this.writeToTag(new NBTTagCompound()));
        return nbt;
    }

    public static BlockPosEU readFromTag(NBTTagCompound tag) {
        if (!(tag != null && tag.func_150297_b("posX", 3) && tag.func_150297_b("posY", 3) && tag.func_150297_b("posZ", 3) && tag.func_150297_b("dim", 3) && tag.func_150297_b("face", 1))) {
            return null;
        }
        int x = tag.func_74762_e("posX");
        int y = tag.func_74762_e("posY");
        int z = tag.func_74762_e("posZ");
        int dim = tag.func_74762_e("dim");
        byte face = tag.func_74771_c("face");
        return new BlockPosEU(x, y, z, dim, EnumFacing.func_82600_a((int)face));
    }

    public static BlockPosEU readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("BlockPos", 10)) {
            return null;
        }
        return BlockPosEU.readFromTag(nbt.func_74775_l("BlockPos"));
    }

    public static void removeFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        nbt.func_82580_o("BlockPos");
    }

    public static EnumFacing getRotation(EnumFacing facing, EnumFacing axis) {
        EnumFacing newFacing = facing.func_176732_a(axis.func_176740_k());
        if (axis.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return newFacing;
        }
        return newFacing != facing ? newFacing.func_176734_d() : facing;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dimension;
        result = 31 * result + this.facing.func_176745_a();
        result = 31 * result + this.posX;
        result = 31 * result + this.posY;
        result = 31 * result + this.posZ;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof BlockPosEU)) {
            return false;
        }
        BlockPosEU other = (BlockPosEU)obj;
        if (this.dimension != other.dimension) {
            return false;
        }
        if (this.facing != other.facing) {
            return false;
        }
        if (this.posX != other.posX) {
            return false;
        }
        if (this.posY != other.posY) {
            return false;
        }
        return this.posZ == other.posZ;
    }

    public String toString() {
        return String.format("BlockPosEU:{x: %d, y: %d, z: %d, dim: %d, face: %d}", this.posX, this.posY, this.posZ, this.dimension, this.facing);
    }
}

