/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.gui.client.GuiToolWorkstation;
import fi.dy.masa.enderutilities.inventory.IModularInventoryHolder;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.container.ContainerToolWorkstation;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemCallback;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperSelectiveModifiable;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.StringUtils;

public class TileEntityToolWorkstation
extends TileEntityEnderUtilitiesInventory
implements IModularInventoryHolder {
    private final ItemStackHandlerTileEntity itemHandlerToolSlot;
    private final ItemStackHandlerTileEntity itemHandlerRenameSlot;
    private final IItemHandler itemHandlerWrapperToolSlot;
    private final IItemHandler itemHandlerWrapperModuleStorage;
    private InventoryItemCallback itemHandlerWrapperInstalledModules;

    public TileEntityToolWorkstation() {
        super("tool_workstation");
        this.itemHandlerBase = new ItemStackHandlerTileEntity(0, 9, this);
        this.itemHandlerToolSlot = new ItemStackHandlerTileEntity(1, 1, 1, false, "ToolItems", this);
        this.itemHandlerRenameSlot = new ItemStackHandlerTileEntity(2, 1, 64, false, "RenameItems", this);
        this.itemHandlerWrapperToolSlot = new ItemHandlerWrapperToolSlot(this.itemHandlerToolSlot);
        this.itemHandlerWrapperModuleStorage = new ItemHandlerWrapperModuleStorage(this.itemHandlerBase);
        this.initStorage(false);
    }

    private void initStorage(boolean isRemote) {
        this.itemHandlerWrapperInstalledModules = new ItemHandlerWrapperInstalledModules(this.itemHandlerToolSlot, 10, isRemote, this);
        this.itemHandlerWrapperInstalledModules.setContainerItemStack(this.getContainerStack());
    }

    public void onLoad() {
        super.onLoad();
        this.initStorage(this.func_145831_w().field_72995_K);
    }

    @Override
    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return this.itemHandlerWrapperModuleStorage;
    }

    public IItemHandler getToolSlotInventory() {
        return this.itemHandlerWrapperToolSlot;
    }

    public IItemHandler getRenameSlotInventory() {
        return this.itemHandlerRenameSlot;
    }

    public IItemHandler getInstalledModulesInventory() {
        return this.itemHandlerWrapperInstalledModules;
    }

    @Override
    public ItemStack getContainerStack() {
        return this.itemHandlerToolSlot.getStackInSlot(0);
    }

    @Override
    public void inventoryChanged(int inventoryId, int slot) {
        if (inventoryId == 1) {
            this.itemHandlerWrapperInstalledModules.setContainerItemStack(this.getContainerStack());
        }
    }

    @Override
    protected void readItemsFromNBT(NBTTagCompound nbt) {
        super.readItemsFromNBT(nbt);
        this.itemHandlerToolSlot.deserializeNBT(nbt);
        this.itemHandlerRenameSlot.deserializeNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("DataVersion", 6600);
        return nbt;
    }

    @Override
    public void writeItemsToNBT(NBTTagCompound nbt) {
        super.writeItemsToNBT(nbt);
        nbt.func_179237_a(this.itemHandlerToolSlot.serializeNBT());
        nbt.func_179237_a(this.itemHandlerRenameSlot.serializeNBT());
    }

    public void renameItem(String name) {
        ItemStack stack = this.itemHandlerRenameSlot.getStackInSlot(0);
        if (!stack.func_190926_b()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                stack.func_135074_t();
            } else {
                stack.func_151001_c(name);
            }
            this.itemHandlerRenameSlot.setStackInSlot(0, stack);
        }
    }

    public String getItemName() {
        ItemStack stack = this.itemHandlerRenameSlot.getStackInSlot(0);
        return !stack.func_190926_b() ? stack.func_82833_r() : "";
    }

    @Override
    public ContainerToolWorkstation getContainer(EntityPlayer player) {
        return new ContainerToolWorkstation(player, this);
    }

    @Override
    public Object getGui(EntityPlayer player) {
        return new GuiToolWorkstation(this.getContainer(player), this);
    }

    private class ItemHandlerWrapperModuleStorage
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapperModuleStorage(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof IModule && !UtilItemModular.moduleTypeEquals(stack, ItemModule.ModuleType.TYPE_INVALID);
        }
    }

    private class ItemHandlerWrapperInstalledModules
    extends InventoryItemCallback {
        private final TileEntityToolWorkstation te;

        public ItemHandlerWrapperInstalledModules(IItemHandlerModifiable baseHandler, int invSize, boolean isRemote, TileEntityToolWorkstation te) {
            super(null, invSize, 1, false, isRemote, te, "Items");
            this.te = te;
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            if (stack.func_190926_b() || !super.isItemValidForSlot(slot, stack)) {
                return false;
            }
            if (stack.func_77973_b() instanceof IModule) {
                ItemModule.ModuleType type = ((IModule)stack.func_77973_b()).getModuleType(stack);
                return type != ItemModule.ModuleType.TYPE_INVALID && type == this.getModuleTypeForSlot(slot, this.te.getContainerStack());
            }
            return false;
        }

        private ItemModule.ModuleType getModuleTypeForSlot(int slot, ItemStack toolStack) {
            if (!toolStack.func_190926_b() && toolStack.func_77973_b() instanceof IModular) {
                IModular iModular = (IModular)toolStack.func_77973_b();
                int modules = 0;
                for (ItemModule.ModuleType moduleType : ItemModule.ModuleType.values()) {
                    if (moduleType.equals(ItemModule.ModuleType.TYPE_INVALID)) continue;
                    int maxOfType = iModular.getMaxModules(toolStack, moduleType);
                    if (slot < modules + maxOfType) {
                        return moduleType;
                    }
                    modules += maxOfType;
                }
            }
            return ItemModule.ModuleType.TYPE_INVALID;
        }
    }

    private class ItemHandlerWrapperToolSlot
    extends ItemHandlerWrapperSelectiveModifiable {
        public ItemHandlerWrapperToolSlot(IItemHandlerModifiable baseHandler) {
            super(baseHandler);
        }

        @Override
        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() instanceof IModular;
        }
    }
}

