/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.block.BlockEnergyBridge;
import fi.dy.masa.enderutilities.block.base.BlockEnderUtilities;
import fi.dy.masa.enderutilities.registry.BlackLists;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesBlocks;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.WorldUtils;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityEnergyBridge
extends TileEntityEnderUtilities
implements ITickable {
    private static final BlockInfo[] STRUCTURE_TRANSMITTER = new BlockInfo[5];
    private static final BlockInfo[] STRUCTURE_RECEIVER = new BlockInfo[5];
    protected boolean isActive;
    protected boolean isPowered;
    protected int timer = 0;
    protected Type type = Type.RESONATOR;
    public int beamYMin;
    public int beamYMax;
    AxisAlignedBB renderBB;

    public TileEntityEnergyBridge() {
        super("energy_bridge");
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        byte f = nbt.func_74771_c("Flags");
        this.isActive = (f & 0x80) != 0;
        this.isPowered = (f & 0x40) != 0;
        this.type = Type.fromMeta(f & 3);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Flags", (byte)((this.isActive ? 128 : 0) | (this.isPowered ? 64 : 0) | this.type.getMeta()));
        return nbt;
    }

    @Override
    public NBTTagCompound getUpdatePacketTag(NBTTagCompound nbt) {
        nbt = super.getUpdatePacketTag(nbt);
        nbt.func_74774_a("f", (byte)((this.isActive ? 128 : 0) | (this.isPowered ? 64 : 0) | this.type.getMeta()));
        return nbt;
    }

    @Override
    public void handleUpdateTag(NBTTagCompound tag) {
        byte f = tag.func_74771_c("f");
        this.isActive = (f & 0x80) != 0;
        this.isPowered = (f & 0x40) != 0;
        this.type = Type.fromMeta(f & 3);
        this.getBeamEndPoints();
        super.handleUpdateTag(tag);
    }

    @Override
    public EnumFacing getFacing() {
        if (this.getType() == Type.RESONATOR) {
            return super.getFacing();
        }
        return EnumFacing.NORTH;
    }

    private void setActiveState(boolean isActive) {
        this.isActive = isActive;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    private void setPoweredState(boolean value) {
        if (this.isPowered != value) {
            this.isPowered = value;
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public boolean getIsPowered() {
        return this.isPowered;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(int meta) {
        this.type = Type.fromMeta(meta);
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.getType() != Type.RESONATOR && ++this.timer >= 100) {
            this.tryAssembleMultiBlock();
            this.timer = 0;
        }
    }

    public void tryAssembleMultiBlock() {
        World world = this.func_145831_w();
        Type masterType = this.getMasterType();
        BlockPos center = this.getCenterPos();
        boolean isValid = this.isStructureValid(world, center, masterType);
        if (isValid) {
            if (!this.isActive) {
                this.activateMultiBlock(world, center, masterType);
                EnergyBridgeTracker.addBridgeLocation(world, this.getMasterPos(center));
            }
            this.updatePoweredState(world, center, masterType);
        } else if (this.isActive) {
            this.disableMultiBlock(world, center, masterType);
        }
    }

    private BlockPos getCenterPos() {
        switch (this.getType()) {
            case TRANSMITTER: {
                return this.func_174877_v().func_177979_c(3);
            }
            case RECEIVER: {
                return this.func_174877_v();
            }
            case RESONATOR: {
                return this.func_174877_v().func_177967_a(this.getFacing(), 3);
            }
        }
        return this.func_174877_v();
    }

    private Type getMasterType() {
        return WorldUtils.isEndDimension(this.func_145831_w()) ? Type.TRANSMITTER : Type.RECEIVER;
    }

    private BlockPos getMasterPos(BlockPos center) {
        return WorldUtils.isEndDimension(this.func_145831_w()) ? center.func_177981_b(3) : center;
    }

    private BlockInfo[] getStructure(Type masterType) {
        return masterType == Type.TRANSMITTER ? STRUCTURE_TRANSMITTER : STRUCTURE_RECEIVER;
    }

    private boolean isStructureValid(World world, BlockPos center, Type masterType) {
        BlockInfo[] structure = this.getStructure(masterType);
        boolean isValid = false;
        for (BlockInfo info : structure) {
            BlockPos posTmp = center.func_177971_a((Vec3i)info.getPos());
            IBlockState state = world.func_180495_p(posTmp);
            if (state.func_177230_c() == EnderUtilitiesBlocks.ENERGY_BRIDGE && state.func_185899_b((IBlockAccess)world, posTmp).func_177226_a((IProperty)BlockEnergyBridge.ACTIVE, (Comparable)Boolean.valueOf(false)) == info.getBlockState()) continue;
            return false;
        }
        if (masterType == Type.TRANSMITTER) {
            double zd;
            double yd;
            double d;
            double xd = center.func_177958_n();
            List list = world.func_72872_a(EntityEnderCrystal.class, new AxisAlignedBB(xd - (d = 1.0), (yd = (double)center.func_177956_o()) - d, (zd = (double)center.func_177952_p()) - d, xd + d, yd + d, zd + d));
            if (list.size() >= 1) {
                isValid = true;
            }
        } else {
            isValid = true;
        }
        if (isValid) {
            return !this.isObstructed(world, center, masterType);
        }
        return false;
    }

    private boolean isObstructedQuadrant(World world, BlockPos basePos, EnumFacing facing, BlockPos ... positions) {
        EnumFacing dirNext = facing.func_176746_e();
        for (BlockPos pos : positions) {
            int z;
            int y;
            int x = pos.func_177958_n() * facing.func_82601_c() + pos.func_177952_p() * facing.func_82599_e();
            if (world.func_175623_d(basePos.func_177982_a(x, y = pos.func_177956_o(), z = pos.func_177958_n() * dirNext.func_82601_c() + pos.func_177952_p() * dirNext.func_82599_e()))) continue;
            return true;
        }
        return false;
    }

    private boolean isObstructed(World world, BlockPos center, Type masterType) {
        BlockPos posMaster = this.getMasterPos(center);
        BlockPos[] positionsToCheck = new BlockPos[]{new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(1, 0, 3), new BlockPos(1, 0, 2), new BlockPos(2, 0, 2), new BlockPos(2, 0, 1), new BlockPos(3, 0, 1)};
        if (this.isObstructedQuadrant(world, center, EnumFacing.EAST, positionsToCheck) || this.isObstructedQuadrant(world, center, EnumFacing.SOUTH, positionsToCheck) || this.isObstructedQuadrant(world, center, EnumFacing.WEST, positionsToCheck) || this.isObstructedQuadrant(world, center, EnumFacing.NORTH, positionsToCheck)) {
            return true;
        }
        if (masterType == Type.TRANSMITTER ? this.isObstructedQuadrant(world, posMaster, EnumFacing.EAST, new BlockPos(0, -1, 0), new BlockPos(0, -2, 0)) : this.isVerticalBeamObstructed(world, posMaster.func_177958_n(), posMaster.func_177952_p(), posMaster.func_177956_o() - 1, 0)) {
            return true;
        }
        int top = world.func_72964_e(posMaster.func_177958_n() >> 4, posMaster.func_177952_p() >> 4).func_76625_h() + 15;
        return this.isVerticalBeamObstructed(world, posMaster.func_177958_n(), posMaster.func_177952_p(), posMaster.func_177956_o() + 1, top);
    }

    private boolean isVerticalBeamObstructed(World world, int x, int z, int yStart, int yEnd) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, yStart, z);
        int increment = yStart < yEnd ? 1 : -1;
        yEnd += increment;
        while (pos.func_177956_o() != yEnd) {
            IBlockState state;
            if (!world.func_175623_d((BlockPos)pos) && (state = world.func_180495_p((BlockPos)pos)).getLightOpacity((IBlockAccess)world, (BlockPos)pos) > 3) {
                return !BlackLists.isBlockValidBedrockForEnergyBridge(state);
            }
            pos.func_185336_p(pos.func_177956_o() + increment);
        }
        return false;
    }

    public void disassembleMultiblock() {
        this.disableMultiBlock(this.func_145831_w(), this.getCenterPos(), this.getMasterType());
    }

    private void activateMultiBlock(World world, BlockPos center, Type masterType) {
        this.setActiveStateForStructure(world, center, masterType, true);
    }

    private void disableMultiBlock(World world, BlockPos center, Type masterType) {
        this.setActiveStateForStructure(world, center, masterType, false);
        EnergyBridgeTracker.removeBridgeLocation(world, this.getMasterPos(center));
    }

    private void setActiveStateForStructure(World world, BlockPos center, Type masterType, boolean active) {
        BlockInfo[] structure;
        for (BlockInfo info : structure = this.getStructure(masterType)) {
            this.setActiveState(world, center.func_177971_a((Vec3i)info.getPos()), active);
        }
    }

    private void setActiveState(World worldIn, BlockPos pos, boolean state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setActiveState(state);
        }
    }

    private void updatePoweredState(World world, BlockPos center, Type masterType) {
        BlockInfo[] structure = this.getStructure(masterType);
        int dim = world.field_73011_w.getDimension();
        boolean powered = EnergyBridgeTracker.dimensionHasEnergyBridge(dim) && (WorldUtils.isEndDimension(world) || EnergyBridgeTracker.endHasEnergyBridges());
        for (BlockInfo info : structure) {
            this.updatePoweredState(world, center.func_177971_a((Vec3i)info.getPos()), powered);
        }
    }

    private void updatePoweredState(World world, BlockPos pos, boolean value) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityEnergyBridge) {
            ((TileEntityEnergyBridge)te).setPoweredState(value);
        }
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    private void getBeamEndPoints() {
        BlockPos.MutableBlockPos pos;
        int posX = this.func_174877_v().func_177958_n();
        int posY = this.func_174877_v().func_177956_o();
        int posZ = this.func_174877_v().func_177952_p();
        int top = this.func_145831_w().func_72964_e(posX >> 4, posZ >> 4).func_76625_h() + 15;
        if (Type.fromMeta(this.func_145832_p()) == Type.TRANSMITTER) {
            this.beamYMin = posY - 2;
        } else if (Type.fromMeta(this.func_145832_p()) == Type.RECEIVER) {
            IBlockState state;
            pos = new BlockPos.MutableBlockPos(posX, posY, posZ);
            while (pos.func_177956_o() >= 0 && !BlackLists.isBlockValidBedrockForEnergyBridge(state = this.func_145831_w().func_180495_p((BlockPos)pos))) {
                pos.func_185336_p(pos.func_177956_o() - 1);
            }
            this.beamYMin = pos.func_177956_o() + 1;
        }
        pos = new BlockPos.MutableBlockPos(posX, posY, posZ);
        int y = 512;
        while (pos.func_177956_o() <= top) {
            IBlockState state = this.func_145831_w().func_180495_p((BlockPos)pos);
            if (BlackLists.isBlockValidBedrockForEnergyBridge(state)) {
                y = pos.func_177956_o();
                break;
            }
            pos.func_185336_p(pos.func_177956_o() + 1);
        }
        this.beamYMax = y;
        this.renderBB = new AxisAlignedBB((double)posX - 4.0, -256.0, (double)posZ - 4.0, (double)posX + 4.0, 512.0, (double)posZ + 4.0);
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBB != null ? this.renderBB : INFINITE_EXTENT_AABB;
    }

    static {
        IBlockState defaultState = EnderUtilitiesBlocks.ENERGY_BRIDGE.func_176223_P();
        PropertyEnum<BlockEnergyBridge.BridgeType> type = BlockEnergyBridge.TYPE;
        BlockEnergyBridge.BridgeType transmitter = BlockEnergyBridge.BridgeType.TRANSMITTER;
        BlockEnergyBridge.BridgeType receiver = BlockEnergyBridge.BridgeType.RECEIVER;
        BlockEnergyBridge.BridgeType resonator = BlockEnergyBridge.BridgeType.RESONATOR;
        TileEntityEnergyBridge.STRUCTURE_TRANSMITTER[0] = new BlockInfo(BlockPos.field_177992_a.func_177981_b(3), defaultState.func_177226_a(type, (Comparable)((Object)transmitter)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.NORTH));
        TileEntityEnergyBridge.STRUCTURE_TRANSMITTER[1] = new BlockInfo(BlockPos.field_177992_a.func_177964_d(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.SOUTH));
        TileEntityEnergyBridge.STRUCTURE_TRANSMITTER[2] = new BlockInfo(BlockPos.field_177992_a.func_177970_e(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.NORTH));
        TileEntityEnergyBridge.STRUCTURE_TRANSMITTER[3] = new BlockInfo(BlockPos.field_177992_a.func_177965_g(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.WEST));
        TileEntityEnergyBridge.STRUCTURE_TRANSMITTER[4] = new BlockInfo(BlockPos.field_177992_a.func_177985_f(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.EAST));
        TileEntityEnergyBridge.STRUCTURE_RECEIVER[0] = new BlockInfo(BlockPos.field_177992_a, defaultState.func_177226_a(type, (Comparable)((Object)receiver)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.NORTH));
        TileEntityEnergyBridge.STRUCTURE_RECEIVER[1] = new BlockInfo(BlockPos.field_177992_a.func_177964_d(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.SOUTH));
        TileEntityEnergyBridge.STRUCTURE_RECEIVER[2] = new BlockInfo(BlockPos.field_177992_a.func_177970_e(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.NORTH));
        TileEntityEnergyBridge.STRUCTURE_RECEIVER[3] = new BlockInfo(BlockPos.field_177992_a.func_177965_g(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.WEST));
        TileEntityEnergyBridge.STRUCTURE_RECEIVER[4] = new BlockInfo(BlockPos.field_177992_a.func_177985_f(3), defaultState.func_177226_a(type, (Comparable)((Object)resonator)).func_177226_a((IProperty)BlockEnderUtilities.FACING_H, (Comparable)EnumFacing.EAST));
    }

    public static enum Type {
        RESONATOR(0),
        RECEIVER(1),
        TRANSMITTER(2);

        private final int meta;

        private Type(int meta) {
            this.meta = meta;
        }

        public static Type fromMeta(int meta) {
            return meta < Type.values().length ? Type.values()[meta] : RESONATOR;
        }

        public int getMeta() {
            return this.meta;
        }
    }

    private static class BlockInfo {
        private final BlockPos pos;
        private final IBlockState state;

        public BlockInfo(BlockPos posRelative, IBlockState state) {
            this.pos = posRelative;
            this.state = state;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public IBlockState getBlockState() {
            return this.state;
        }
    }
}

