/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerTileEntity;
import fi.dy.masa.enderutilities.inventory.wrapper.ItemHandlerWrapperContainer;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilities;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityEnderUtilitiesInventory
extends TileEntityEnderUtilities {
    protected ItemStackHandlerTileEntity itemHandlerBase;
    protected IItemHandler itemHandlerExternal;
    protected String customInventoryName;
    protected boolean useWrapperHandlerForContainerExtract;
    private boolean creative;

    public TileEntityEnderUtilitiesInventory(String name) {
        super(name);
    }

    public TileEntityEnderUtilitiesInventory(String name, boolean useWrapperHandlerForContainerExtract) {
        super(name);
        this.useWrapperHandlerForContainerExtract = useWrapperHandlerForContainerExtract;
    }

    public boolean isCreative() {
        return this.creative;
    }

    public void setCreative(boolean isCreative) {
        this.creative = isCreative;
    }

    public void setInventoryName(String name) {
        this.customInventoryName = name;
    }

    public boolean hasCustomName() {
        return this.customInventoryName != null && this.customInventoryName.length() > 0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customInventoryName : "enderutilities.container." + this.tileEntityName;
    }

    public ItemStackHandlerBasic getBaseItemHandler() {
        return this.itemHandlerBase;
    }

    public IItemHandler getWrappedInventoryForContainer(EntityPlayer player) {
        return new ItemHandlerWrapperContainer(this.getBaseItemHandler(), this.itemHandlerExternal, this.useWrapperHandlerForContainerExtract);
    }

    protected void readItemsFromNBT(NBTTagCompound nbt) {
        this.getBaseItemHandler().deserializeNBT(nbt);
    }

    public void writeItemsToNBT(NBTTagCompound nbt) {
        nbt.func_179237_a(this.getBaseItemHandler().serializeNBT());
    }

    @Override
    public void readFromNBTCustom(NBTTagCompound nbt) {
        super.readFromNBTCustom(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.customInventoryName = nbt.func_74779_i("CustomName");
        }
        this.readItemsFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.writeItemsToNBT(nbt);
        if (this.hasCustomName()) {
            nbt.func_74778_a("CustomName", this.customInventoryName);
        }
        return nbt;
    }

    public NBTTagCompound getCachedInventory(NBTTagCompound nbt, int maxEntries) {
        ItemStackHandlerBasic inv = this.getBaseItemHandler();
        if (inv != null) {
            nbt = NBTUtils.storeCachedInventory(nbt, inv, maxEntries);
        }
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerExternal != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerExternal);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void inventoryChanged(int inventoryId, int slot) {
    }

    @Override
    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.func_145831_w().func_175625_s(this.func_174877_v()) != this || player.func_174818_b(this.func_174877_v()) >= 64.0) {
            return false;
        }
        return super.isUseableByPlayer(player);
    }
}

