/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.network.message;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.network.message.ByteBufUtilsEU;
import fi.dy.masa.enderutilities.network.message.ISyncableTile;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class MessageSyncTileEntity
implements IMessage {
    private int header;
    private BlockPos pos;
    private int[] intValues;
    private ItemStack[] stacks;

    public MessageSyncTileEntity() {
    }

    public MessageSyncTileEntity(BlockPos pos, int ... intValues) {
        this.pos = pos;
        this.intValues = intValues;
        this.stacks = new ItemStack[0];
    }

    public MessageSyncTileEntity(BlockPos pos, ItemStack ... stacks) {
        this.pos = pos;
        this.intValues = new int[0];
        this.stacks = stacks;
    }

    public MessageSyncTileEntity(BlockPos pos, int intValue, ItemStack stack) {
        this.pos = pos;
        this.intValues = new int[]{intValue};
        this.stacks = new ItemStack[]{stack};
    }

    public MessageSyncTileEntity(BlockPos pos, int[] intValues, ItemStack[] stacks) {
        this.pos = pos;
        this.intValues = intValues;
        this.stacks = stacks;
    }

    public void toBytes(ByteBuf buf) {
        int i;
        buf.writeByte((this.stacks.length & 0xF) << 4 | this.intValues.length & 0xF);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeByte((int)((byte)(this.pos.func_177956_o() & 0xFF)));
        buf.writeInt(this.pos.func_177952_p());
        for (i = 0; i < (this.intValues.length & 0xF); ++i) {
            buf.writeInt(this.intValues[i]);
        }
        for (i = 0; i < (this.stacks.length & 0xF); ++i) {
            ByteBufUtilsEU.writeItemStackToBuffer(buf, this.stacks[i]);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.header = buf.readByte();
        this.pos = new BlockPos(buf.readInt(), buf.readByte() & 0xFF, buf.readInt());
        try {
            int i;
            int len = this.header & 0xF;
            this.intValues = new int[len];
            for (i = 0; i < len; ++i) {
                this.intValues[i] = buf.readInt();
            }
            len = (this.header & 0xF0) >>> 4;
            this.stacks = new ItemStack[len];
            for (i = 0; i < len; ++i) {
                this.stacks[i] = ByteBufUtilsEU.readItemStackFromBuffer(buf);
            }
        }
        catch (IOException e) {
            EnderUtilities.logger.warn("MessageSyncTileEntity: Exception while reading data from buffer", (Throwable)e);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSyncTileEntity, IMessage> {
        public IMessage onMessage(final MessageSyncTileEntity message, MessageContext ctx) {
            if (ctx.side != Side.CLIENT) {
                EnderUtilities.logger.error("Wrong side in MessageSyncTileEntity: " + ctx.side);
                return null;
            }
            Minecraft mc = FMLClientHandler.instance().getClient();
            final EntityPlayer player = EnderUtilities.proxy.getPlayerFromMessageContext(ctx);
            if (mc == null || player == null) {
                EnderUtilities.logger.error("Minecraft or player was null in MessageSyncTileEntity");
                return null;
            }
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    this.processMessage(message, player);
                }
            });
            return null;
        }

        protected void processMessage(MessageSyncTileEntity message, EntityPlayer player) {
            World world = player.func_130014_f_();
            TileEntity te = world.func_175625_s(message.pos);
            if (te instanceof ISyncableTile) {
                ISyncableTile syncable = (ISyncableTile)te;
                syncable.syncTile(message.intValues, message.stacks);
            }
        }
    }
}

