/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemRuler
extends ItemModular {
    public static final boolean DISTANCE_MODE_DIMENSIONS = false;
    public static final boolean DISTANCE_MODE_DIFFERENCE = true;
    public static final boolean POS_START = true;
    public static final boolean POS_END = false;
    public static final String TAG_WRAPPER = "Ruler";
    public static final String TAG_DISTANCE_MODE = "DistanceMode";
    public static final String TAG_RENDER_WHEN_UNSELECTED = "RenderUnselected";
    public static final String TAG_RENDER_ALL = "RenderAll";
    public static final String TAG_RENDER_WITH_ALL = "RenderWithAll";
    public static final String TAG_LOCATIONS = "Locations";
    public static final String TAG_SELECTED_LOCATION = "SelLocation";
    protected Map<UUID, Long> lastLeftClick = new HashMap<UUID, Long>();

    public ItemRuler(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 6L) {
            this.setOrRemovePosition(player.func_184586_b(hand), new BlockPosEU(pos, player.func_130014_f_().field_73011_w.getDimension(), side), false, !player.func_70093_af());
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
        return EnumActionResult.SUCCESS;
    }

    public void onLeftClickBlock(EntityPlayer player, World world, ItemStack stack, BlockPos pos, int dimension, EnumFacing side) {
        if (world.field_72995_K) {
            return;
        }
        Long last = this.lastLeftClick.get(player.func_110124_au());
        if (last == null || world.func_82737_E() - last >= 4L) {
            this.setOrRemovePosition(stack, new BlockPosEU(pos, player.func_130014_f_().field_73011_w.getDimension(), side), true, !player.func_70093_af());
        }
        this.lastLeftClick.put(player.func_110124_au(), world.func_82737_E());
    }

    public String func_77653_i(ItemStack rulerStack) {
        int count;
        StringBuilder displayName = new StringBuilder(64);
        displayName.append(super.func_77653_i(rulerStack));
        if (rulerStack.func_77978_p() == null) {
            return displayName.toString();
        }
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        if (displayName.toString().length() >= 14) {
            displayName = new StringBuilder(64).append(EUStringUtils.getInitialsWithDots(displayName.toString()));
        }
        if ((count = this.getLocationCount(rulerStack)) > 0) {
            int sel = this.getLocationSelection(rulerStack);
            displayName.append(" - sel: ").append(preGreen + (sel + 1)).append("/").append(count).append(rst);
            displayName.append(" - R: ");
            if (this.getAlwaysRenderLocation(rulerStack, sel)) {
                displayName.append(preGreen + "yes" + rst);
            } else {
                displayName.append(preRed + "no" + rst);
            }
        }
        return displayName.toString();
    }

    @Override
    public void addTooltipLines(ItemStack rulerStack, EntityPlayer player, List<String> list, boolean verbose) {
        String str;
        if (rulerStack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        String preDGreen = TextFormatting.DARK_GREEN.toString();
        String preGreen = TextFormatting.GREEN.toString();
        String preRed = TextFormatting.RED.toString();
        String preBlue = TextFormatting.BLUE.toString();
        String preWhite = TextFormatting.WHITE.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String strYes = preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) + rst;
        String strNo = preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]) + rst;
        int selected = this.getLocationSelection(rulerStack);
        BlockPosEU posStart = this.getPosition(rulerStack, selected, true);
        BlockPosEU posEnd = this.getPosition(rulerStack, selected, false);
        if (!verbose) {
            if (posStart != null && posEnd != null) {
                list.add(String.format("x: %s%d%s y: %s%d%s z: %s%d%s ... x: %s%d%s y: %s%d%s z: %s%d%s", preBlue, posStart.getX(), rst, preBlue, posStart.getY(), rst, preBlue, posStart.getZ(), rst, preBlue, posEnd.getX(), rst, preBlue, posEnd.getY(), rst, preBlue, posEnd.getZ(), rst));
            }
            return;
        }
        if (posStart != null) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.start", (Object[])new Object[0]);
            list.add(str + String.format(": x: %s%d%s, y: %s%d%s, z: %s%d%s", preBlue, posStart.getX(), rst, preBlue, posStart.getY(), rst, preBlue, posStart.getZ(), rst));
        }
        if (posEnd != null) {
            str = I18n.func_135052_a((String)"enderutilities.tooltip.item.end", (Object[])new Object[0]);
            list.add(str + String.format(": x: %s%d%s, y: %s%d%s, z: %s%d%s", preBlue, posEnd.getX(), rst, preBlue, posEnd.getY(), rst, preBlue, posEnd.getZ(), rst));
        }
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": ";
        if (!this.getDistanceMode(rulerStack)) {
            list.add(str + preDGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.ruler.dimensions", (Object[])new Object[0]) + rst);
        } else {
            list.add(str + preDGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.ruler.difference", (Object[])new Object[0]) + rst);
        }
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.rendercurrentwithall", (Object[])new Object[0]);
        list.add(str + ": " + (this.getAlwaysRenderLocation(rulerStack, selected) ? strYes : strNo));
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.renderall", (Object[])new Object[0]);
        list.add(str + ": " + (this.getRenderAllLocations(rulerStack) ? strYes : strNo));
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.renderwhenunselected", (Object[])new Object[0]);
        list.add(str + ": " + (this.getRenderWhenUnselected(rulerStack) ? strYes : strNo));
        int count = this.getLocationCount(rulerStack);
        str = I18n.func_135052_a((String)"enderutilities.tooltip.item.selected", (Object[])new Object[0]) + ": ";
        list.add(str + preBlue + (selected + 1) + rst + " / " + preBlue + count + rst);
        int installed = this.getInstalledModuleCount(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (installed > 0) {
            int slotNum = UtilItemModular.getClampedModuleSelection(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
            int max = this.getMaxModules(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
            String preWhiteIta = preWhite + TextFormatting.ITALIC.toString();
            String strShort = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.short", (Object[])new Object[0]);
            ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
            if (!moduleStack.func_190926_b() && moduleStack.func_77973_b() == EnderUtilitiesItems.ENDER_PART) {
                String dName = moduleStack.func_82837_s() ? preWhiteIta + moduleStack.func_82833_r() + rst + " " : "";
                list.add(String.format("%s %s(%s%d%s / %s%d%s)", strShort, dName, preBlue, slotNum + 1, rst, preBlue, max, rst));
            } else {
                String strNot = I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.notinstalled", (Object[])new Object[0]);
                list.add(String.format("%s %s (%s%d%s / %s%d%s)", strShort, strNot, preBlue, slotNum + 1, rst, preBlue, max, rst));
            }
        }
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 4;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC)) {
            return this.getMaxModules(containerStack);
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_190926_b() || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        return this.getMaxModules(containerStack, ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack));
    }

    public boolean getDistanceMode(ItemStack rulerStack) {
        return NBTUtils.getBoolean(rulerStack, TAG_WRAPPER, TAG_DISTANCE_MODE);
    }

    public boolean getRenderWhenUnselected(ItemStack rulerStack) {
        return NBTUtils.getBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_WHEN_UNSELECTED);
    }

    public boolean getRenderAllLocations(ItemStack rulerStack) {
        return NBTUtils.getBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_ALL);
    }

    public void toggleDistanceMode(ItemStack rulerStack) {
        NBTUtils.toggleBoolean(rulerStack, TAG_WRAPPER, TAG_DISTANCE_MODE);
    }

    public void toggleRenderWhenUnselected(ItemStack rulerStack) {
        NBTUtils.toggleBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_WHEN_UNSELECTED);
    }

    public void toggleRenderAllLocations(ItemStack rulerStack) {
        NBTUtils.toggleBoolean(rulerStack, TAG_WRAPPER, TAG_RENDER_ALL);
    }

    public int getLocationSelection(ItemStack rulerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            return NBTUtils.getByte(moduleStack, TAG_WRAPPER, TAG_SELECTED_LOCATION);
        }
        return 0;
    }

    public int getLocationCount(ItemStack rulerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, false);
            return tagList != null ? tagList.func_74745_c() : 0;
        }
        return 0;
    }

    public void cycleLocationSelection(ItemStack rulerStack, boolean reverse) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            int max = Math.min(this.getLocationCount(rulerStack), 7);
            NBTUtils.cycleByteValue(moduleStack, TAG_WRAPPER, TAG_SELECTED_LOCATION, max, reverse);
        }
    }

    public boolean getAlwaysRenderLocation(ItemStack rulerStack, int index) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            NBTTagList tagList;
            if (index < 0) {
                index = this.getLocationSelection(rulerStack);
            }
            if ((tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, false)) != null) {
                NBTTagCompound tag = tagList.func_150305_b(index);
                return tag.func_74767_n(TAG_RENDER_WITH_ALL);
            }
        }
        return false;
    }

    public BlockPosEU getPosition(ItemStack rulerStack, int index, boolean isPos1) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, false);
            if (tagList == null) {
                return null;
            }
            if (index < 0) {
                index = this.getLocationSelection(rulerStack);
            }
            String tagName = isPos1 ? "Pos1" : "Pos2";
            NBTTagCompound tag = tagList.func_150305_b(index);
            return BlockPosEU.readFromTag(tag.func_74775_l(tagName));
        }
        return null;
    }

    public void setOrRemovePosition(ItemStack rulerStack, BlockPosEU pos, boolean isPos1, boolean adjustPosition) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            NBTTagList tagList;
            int selected;
            if (adjustPosition) {
                pos = pos.offset(pos.getFacing());
            }
            if ((selected = this.getLocationSelection(rulerStack)) >= (tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, true)).func_74745_c()) {
                tagList.func_74742_a((NBTBase)new NBTTagCompound());
            }
            NBTTagCompound tag = tagList.func_150305_b(selected);
            String tagName = isPos1 ? "Pos1" : "Pos2";
            BlockPosEU oldPos = BlockPosEU.readFromTag(tag.func_74775_l(tagName));
            if (pos == null || pos.equals(oldPos)) {
                tag.func_82580_o(tagName);
            } else {
                tag.func_74782_a(tagName, (NBTBase)pos.writeToTag(new NBTTagCompound()));
            }
            if (selected >= tagList.func_74745_c()) {
                tagList = NBTUtils.insertToTagList(tagList, (NBTBase)tag, selected);
            } else {
                tagList.func_150304_a(selected, (NBTBase)tag);
            }
            NBTUtils.setTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, tagList);
            this.setSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        }
    }

    public void toggleAlwaysRenderSelectedLocation(ItemStack rulerStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            int selected = this.getLocationSelection(rulerStack);
            NBTTagList tagList = NBTUtils.getTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, 10, true);
            NBTTagCompound tag = tagList.func_150305_b(selected);
            NBTUtils.toggleBoolean(tag, TAG_RENDER_WITH_ALL);
            if (selected >= tagList.func_74745_c()) {
                tagList = NBTUtils.insertToTagList(tagList, (NBTBase)tag, selected);
            } else {
                tagList.func_150304_a(selected, (NBTBase)tag);
            }
            NBTUtils.setTagList(moduleStack, TAG_WRAPPER, TAG_LOCATIONS, tagList);
            this.setSelectedModuleStack(rulerStack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
        }
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 65536)) {
            this.cycleLocationSelection(stack, HotKeys.EnumKey.keypressActionIsReversed(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 262144)) {
            this.toggleRenderWhenUnselected(stack);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 393216)) {
            this.toggleDistanceMode(stack);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
            this.toggleRenderAllLocations(stack);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0)) {
            this.toggleAlwaysRenderSelectedLocation(stack);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        return false;
    }
}

