/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.container.ContainerQuickStacker;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IKeyBoundUnselected;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.tileentity.TileEntityQuickStackerAdvanced;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemQuickStacker
extends ItemEnderUtilities
implements IKeyBound,
IKeyBoundUnselected {
    public static final String TAG_NAME_CONTAINER = "QuickStacker";
    public static final String TAG_NAME_PRESET_SELECTION = "SelectedPreset";
    public static final String TAG_NAME_PRESET = "Preset_";
    public static final String TAG_NAME_LOCKED = "Locked";
    public static final int NUM_PRESETS = 4;
    public static final int GUI_ACTION_CHANGE_PRESET = 0;
    public static final int GUI_ACTION_TOGGLE_ROWS = 1;
    public static final int GUI_ACTION_TOGGLE_COLUMNS = 2;
    public static final int MAX_RANGE_HORIZONTAL = 4;
    public static final int MAX_RANGE_VERTICAL = 3;

    public ItemQuickStacker(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K) {
            player.openGui((Object)EnderUtilities.instance, 1005, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (player.func_70093_af() && (te = world.func_175625_s(pos)) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            IItemHandler inv = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (!world.field_72995_K && inv != null) {
                ItemQuickStacker.quickStackItems(player, player.func_184586_b(hand), inv);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public String func_77653_i(ItemStack stack) {
        String itemName = super.func_77653_i(stack);
        String preGreen = TextFormatting.GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
        byte selected = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        itemName = itemName + " P: " + preGreen + (selected + 1) + rst;
        return itemName;
    }

    @Override
    public void addTooltipLines(ItemStack containerStack, EntityPlayer player, List<String> list, boolean verbose) {
        if (containerStack.func_77978_p() == null) {
            return;
        }
        String preGreen = TextFormatting.GREEN.toString();
        String preBlue = TextFormatting.BLUE.toString();
        String preRed = TextFormatting.RED.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        String str = ItemQuickStacker.isEnabled(containerStack) ? I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preGreen + I18n.func_135052_a((String)"enderutilities.tooltip.item.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"enderutilities.tooltip.item.enabled", (Object[])new Object[0]) + ": " + preRed + I18n.func_135052_a((String)"enderutilities.tooltip.item.no", (Object[])new Object[0]);
        list.add(str);
        byte selected = NBTUtils.getByte(containerStack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.preset", (Object[])new Object[0]) + ": " + preBlue + (selected + 1) + rst);
    }

    public static boolean isEnabled(ItemStack stack) {
        return !NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
    }

    public static ItemStack getEnabledItem(EntityPlayer player) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingItems(playerInv, EnderUtilitiesItems.QUICK_STACKER);
        for (int slot : slots) {
            ItemStack stack = playerInv.getStackInSlot(slot);
            if (!ItemQuickStacker.isEnabled(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static long getEnabledSlotsMask(ItemStack stack) {
        byte selected = NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION);
        return NBTUtils.getLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + selected);
    }

    public static Result quickStackItems(EntityPlayer player, ItemStack stackerStack, IItemHandler inventory) {
        IItemHandler playerInv = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        Result ret = TileEntityQuickStackerAdvanced.quickStackItems(playerInv, inventory, ItemQuickStacker.getEnabledSlotsMask(stackerStack), !player.func_70093_af(), null);
        if (ret != Result.MOVED_NONE) {
            player.func_130014_f_().func_184133_a(null, player.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.MASTER, 0.2f, 1.8f);
        }
        return ret;
    }

    public static void quickStackItems(EntityPlayer player) {
        ItemStack stack = ItemQuickStacker.getEnabledItem(player);
        if (!stack.func_190926_b()) {
            TileEntityQuickStackerAdvanced.quickStackToInventories(player.func_130014_f_(), player, ItemQuickStacker.getEnabledSlotsMask(stack), PositionUtils.getTileEntityPositions(player.func_130014_f_(), player.func_180425_c(), 4, 3, 3));
        }
    }

    @Override
    public boolean doUnselectedKeyAction(EntityPlayer player, ItemStack stack, int key) {
        stack = ItemQuickStacker.getEnabledItem(player);
        if (!stack.func_190926_b()) {
            return ((ItemQuickStacker)stack.func_77973_b()).doKeyBindingAction(player, stack, key);
        }
        return false;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 0, 65536)) {
            ItemQuickStacker.quickStackItems(player);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 327680)) {
            NBTUtils.toggleBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            NBTUtils.cycleByteValue(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, 3, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        return false;
    }

    public static void performGuiAction(EntityPlayer player, int action, int element) {
        ItemStack stack;
        if (player.field_71070_bA instanceof ContainerQuickStacker && !(stack = ((ContainerQuickStacker)player.field_71070_bA).getContainerItem()).func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.QUICK_STACKER) {
            if (action == 0 && element >= 0 && element < 4) {
                NBTUtils.setByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION, (byte)element);
            } else if (action == 1 && element >= 0 && element < 4) {
                long mask = ItemQuickStacker.getEnabledSlotsMask(stack);
                NBTUtils.setLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION), mask ^= 511L << element * 9);
            } else if (action == 2) {
                long mask = ItemQuickStacker.getEnabledSlotsMask(stack);
                if (element >= 0 && element < 9) {
                    mask ^= 134480385L << element;
                }
                NBTUtils.setLong(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET + NBTUtils.getByte(stack, TAG_NAME_CONTAINER, TAG_NAME_PRESET_SELECTION), mask);
            }
        }
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        String rl = "enderutilities:item_" + this.name;
        return new ResourceLocation[]{new ModelResourceLocation(rl, "locked=false"), new ModelResourceLocation(rl, "locked=true")};
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        String rl = "enderutilities:item_" + this.name;
        return new ModelResourceLocation(rl, "locked=" + NBTUtils.getBoolean(stack, TAG_NAME_CONTAINER, TAG_NAME_LOCKED));
    }

    public static enum Result {
        MOVED_NONE,
        MOVED_SOME,
        MOVED_ALL;

    }
}

