/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderCapacitor;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.EnergyBridgeTracker;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.PositionUtils;
import fi.dy.masa.enderutilities.util.WorldUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntityNetherPortal;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class ItemPortalScaler
extends ItemModular
implements IKeyBound {
    public static final int ENDER_CHARGE_COST_PORTAL_ACTIVATION = 500;
    public static final float TELEPORTATION_EC_COST = 0.013f;

    public ItemPortalScaler(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (EntityUtils.isEntityCollidingWithBlockSpace(world, (Entity)player, (Block)Blocks.field_150427_aO)) {
            return EnumActionResult.PASS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == Blocks.field_150427_aO) {
            if (!world.field_72995_K && world.func_175660_a(player, pos)) {
                world.func_175655_b(pos, false);
            }
            return EnumActionResult.SUCCESS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (block == Blocks.field_150343_Z && world.func_175623_d(pos.func_177972_a(side)) && world.func_175660_a(player, pos.func_177972_a(side)) && UtilItemModular.useEnderCharge(stack, 500, true) && Blocks.field_150427_aO.func_176548_d(world, pos.func_177972_a(side))) {
            UtilItemModular.useEnderCharge(stack, 500, false);
            world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187606_E, SoundCategory.MASTER, 0.8f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!EntityUtils.isEntityCollidingWithBlockSpace(world, (Entity)player, (Block)Blocks.field_150427_aO)) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            this.usePortalWithPortalScaler(stack, world, player);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrent) {
        int dim = world.field_73011_w.getDimension();
        if (!world.field_72995_K && EnergyBridgeTracker.dimensionHasEnergyBridge(dim) && (WorldUtils.isEndDimension(world) || EnergyBridgeTracker.endHasEnergyBridges())) {
            UtilItemModular.addEnderCharge(stack, 100, true);
        }
    }

    public boolean usePortalWithPortalScaler(ItemStack stack, World world, EntityPlayer player) {
        int dimSrc = player.func_130014_f_().field_73011_w.getDimension();
        if (dimSrc != 0 && dimSrc != -1 || !this.itemHasScaleFactor(stack)) {
            return false;
        }
        int dimDst = dimSrc == 0 ? -1 : 0;
        Vec3d normalDest = this.getNormalDestinationPosition(player, dimDst);
        Vec3d posDest = this.getDestinationPosition(stack, player, dimDst);
        int cost = this.getTeleportCostEstimate(player, posDest, dimDst);
        if (UtilItemModular.useEnderCharge(stack, cost, true)) {
            TeleportEntityNetherPortal tp = new TeleportEntityNetherPortal();
            Entity entity = tp.travelToDimension((Entity)player, dimDst, new BlockPos(posDest), 32, false);
            if (entity != null) {
                cost = this.getTeleportCost(normalDest, entity.func_174791_d());
                UtilItemModular.useEnderCharge(stack, cost, false);
                return true;
            }
        } else {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("enderutilities.chat.message.notenoughendercharge", new Object[0]), true);
        }
        return false;
    }

    public Vec3d getDestinationPosition(ItemStack stack, EntityPlayer player, int destDimension) {
        ItemStack cardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        NBTTagCompound moduleNbt = cardStack.func_77978_p();
        NBTTagCompound tag = moduleNbt.func_74775_l("PortalScaler");
        int scaleX = tag.func_74771_c("scaleX");
        byte scaleY = tag.func_74771_c("scaleY");
        int scaleZ = tag.func_74771_c("scaleZ");
        if (scaleX == 0) {
            scaleX = 8;
        }
        if (scaleY == 0) {
            scaleY = 1;
        }
        if (scaleZ == 0) {
            scaleZ = 8;
        }
        double dScaleX = scaleX;
        double dScaleY = scaleY;
        double dScaleZ = scaleZ;
        if (scaleX < 0) {
            dScaleX = -1.0 / (double)scaleX;
        }
        if (scaleY < 0) {
            dScaleY = -1.0 / (double)scaleY;
        }
        if (scaleZ < 0) {
            dScaleZ = -1.0 / (double)scaleZ;
        }
        if (destDimension == DimensionType.NETHER.func_186068_a()) {
            dScaleX = 1.0 / dScaleX;
            dScaleY = 1.0 / dScaleY;
            dScaleZ = 1.0 / dScaleZ;
        }
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(destDimension);
        return PositionUtils.getScaledClampedPosition(player.func_174791_d(), (World)world, dScaleX, dScaleY, dScaleZ, 32);
    }

    public Vec3d getNormalDestinationPosition(EntityPlayer player, int destDimension) {
        double scale = destDimension == DimensionType.OVERWORLD.func_186068_a() ? 8.0 : 0.125;
        return PositionUtils.getScaledClampedPosition(player.func_174791_d(), null, scale, 1.0, scale, 32);
    }

    public int getTeleportCost(Vec3d pos1, Vec3d pos2) {
        double xDiff = pos1.field_72450_a - pos2.field_72450_a;
        double yDiff = pos1.field_72448_b - pos2.field_72448_b;
        double zDiff = pos1.field_72449_c - pos2.field_72449_c;
        return (int)((double)0.013f * Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff));
    }

    public int getTeleportCostEstimate(EntityPlayer player, Vec3d dest, int destDim) {
        Vec3d normalDest = this.getNormalDestinationPosition(player, destDim);
        return this.getTeleportCost(normalDest, dest);
    }

    public String func_77653_i(ItemStack stack) {
        String str = "";
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (!moduleStack.func_190926_b()) {
            String preGreen = TextFormatting.GREEN.toString();
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            if (moduleStack.func_82837_s()) {
                str = " " + preGreen + TextFormatting.ITALIC.toString() + moduleStack.func_82833_r() + rst;
            }
            if (this.memoryCardHasScaleFactor(moduleStack)) {
                NBTTagCompound tag = moduleStack.func_77978_p().func_74775_l("PortalScaler");
                byte x = tag.func_74771_c("scaleX");
                byte y = tag.func_74771_c("scaleY");
                byte z = tag.func_74771_c("scaleZ");
                String sx = preGreen + (x < 0 ? "1/" + -x : String.valueOf(x)) + rst;
                String sy = preGreen + (y < 0 ? "1/" + -y : String.valueOf(y)) + rst;
                String sz = preGreen + (z < 0 ? "1/" + -z : String.valueOf(z)) + rst;
                str = str + String.format(" x: %s y: %s z: %s", sx, sy, sz);
                return super.func_77653_i(stack) + str + rst;
            }
        }
        return super.func_77653_i(stack) + str;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        ItemStack capacitorStack;
        if (stack.func_77978_p() == null) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.usetoolworkstation", (Object[])new Object[0]));
            return;
        }
        ItemStack memoryCardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        String preBlue = TextFormatting.BLUE.toString();
        String preWhiteIta = TextFormatting.WHITE.toString() + TextFormatting.ITALIC.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        if (!memoryCardStack.func_190926_b()) {
            if (this.memoryCardHasScaleFactor(memoryCardStack)) {
                NBTTagCompound tag = memoryCardStack.func_77978_p().func_74775_l("PortalScaler");
                byte x = tag.func_74771_c("scaleX");
                byte y = tag.func_74771_c("scaleY");
                byte z = tag.func_74771_c("scaleZ");
                String sx = x < 0 ? "1/" + -x : String.valueOf(x);
                String sy = y < 0 ? "1/" + -y : String.valueOf(y);
                String sz = z < 0 ? "1/" + -z : String.valueOf(z);
                list.add(String.format("x: %s%s%s y: %s%s%s z: %s%s%s", preBlue, sx, rst, preBlue, sy, rst, preBlue, sz, rst));
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nodata", (Object[])new Object[0]));
            }
            if (verbose) {
                int num = UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
                int sel = UtilItemModular.getClampedModuleSelection(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC) + 1;
                String dName = memoryCardStack.func_82837_s() ? preWhiteIta + memoryCardStack.func_82833_r() + rst + " " : "";
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.selectedmemorycard.short", (Object[])new Object[0]) + String.format(" %s(%s%d%s / %s%d%s)", dName, preBlue, sel, rst, preBlue, num, rst));
            }
        } else {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.nomemorycards", (Object[])new Object[0]));
        }
        if (verbose && !(capacitorStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_ENDERCAPACITOR)).func_190926_b() && capacitorStack.func_77973_b() instanceof ItemEnderCapacitor) {
            ((ItemEnderCapacitor)capacitorStack.func_77973_b()).addTooltipLines(capacitorStack, player, list, verbose);
        }
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) {
            this.changeSelectedModule(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, HotKeys.EnumKey.keypressActionIsReversed(key) || HotKeys.EnumKey.keypressContainsShift(key));
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 327680, 131072)) {
            int amount = HotKeys.EnumKey.keypressContainsControl(key) ? 1 : -1;
            this.changeCoordinateScaleFactor(stack, player, amount);
            return true;
        }
        if (HotKeys.EnumKey.SCROLL.matches(key, 327680)) {
            int amount = HotKeys.EnumKey.keypressActionIsReversed(key) ? 1 : -1;
            this.changeCoordinateScaleFactor(stack, player, amount);
            return true;
        }
        return false;
    }

    public boolean memoryCardHasScaleFactor(ItemStack cardStack) {
        NBTTagCompound tag = NBTUtils.getCompoundTag(cardStack, "PortalScaler", false);
        return tag != null && tag.func_150297_b("scaleX", 1) && tag.func_150297_b("scaleY", 1) && tag.func_150297_b("scaleZ", 1);
    }

    public boolean itemHasScaleFactor(ItemStack stack) {
        ItemStack cardStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        return !cardStack.func_190926_b() && this.memoryCardHasScaleFactor(cardStack);
    }

    public void changeCoordinateScaleFactor(ItemStack stack, EntityPlayer player, int amount) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC);
        if (moduleStack.func_190926_b()) {
            return;
        }
        NBTTagCompound tag = NBTUtils.getCompoundTag(moduleStack, "PortalScaler", true);
        int x = tag.func_150297_b("scaleX", 1) ? (int)tag.func_74771_c("scaleX") : 8;
        int y = tag.func_150297_b("scaleY", 1) ? tag.func_74771_c("scaleY") : 1;
        int z = tag.func_150297_b("scaleZ", 1) ? (int)tag.func_74771_c("scaleZ") : 8;
        EnumFacing facing = EntityUtils.getLookingDirection((Entity)player);
        y += Math.abs(facing.func_96559_d()) * amount;
        z += Math.abs(facing.func_82599_e()) * amount;
        if ((x += Math.abs(facing.func_82601_c()) * amount) == -1) {
            x += Math.abs(facing.func_82601_c()) * amount * 2;
        }
        if (y == -1) {
            y += Math.abs(facing.func_96559_d()) * amount * 2;
        }
        if (z == -1) {
            z += Math.abs(facing.func_82599_e()) * amount * 2;
        }
        if (x == 0) {
            x += Math.abs(facing.func_82601_c()) * amount * 2;
        }
        if (y == 0) {
            y += Math.abs(facing.func_96559_d()) * amount * 2;
        }
        if (z == 0) {
            z += Math.abs(facing.func_82599_e()) * amount * 2;
        }
        x = MathHelper.func_76125_a((int)x, (int)-64, (int)64);
        y = MathHelper.func_76125_a((int)y, (int)-64, (int)64);
        z = MathHelper.func_76125_a((int)z, (int)-64, (int)64);
        tag.func_74774_a("scaleX", (byte)x);
        tag.func_74774_a("scaleY", (byte)y);
        tag.func_74774_a("scaleZ", (byte)z);
        this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC, moduleStack);
    }

    @Override
    public int getMaxModules(ItemStack containerStack) {
        return 5;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemModule.ModuleType moduleType) {
        if (moduleType.equals(ItemModule.ModuleType.TYPE_ENDERCAPACITOR)) {
            return 1;
        }
        if (moduleType.equals(ItemModule.ModuleType.TYPE_MEMORY_CARD_MISC)) {
            return 4;
        }
        return 0;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_190926_b() || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        return this.getMaxModules(containerStack, ((IModule)moduleStack.func_77973_b()).getModuleType(moduleStack));
    }
}

