/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.item.base.IKeyBound;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemLocationBoundModular;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.reference.HotKeys;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.EUStringUtils;
import fi.dy.masa.enderutilities.util.fluid.FluidHandlerEnderBucket;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.TargetData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemEnderBucket
extends ItemLocationBoundModular
implements IKeyBound {
    public static final double ENDER_CHARGE_COST = 0.2;

    public ItemEnderBucket(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerEnderBucket(this, stack);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return EnumActionResult.FAIL;
        }
        if (!world.field_72995_K) {
            if (this.useBucketOnFluidBlock(world, player, stack) == EnumActionResult.SUCCESS) {
                return EnumActionResult.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
                if (BucketMode.fromStack(stack) == BucketMode.BIND) {
                    return super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
                }
                return this.useBucketOnTank(world, pos, side, player, stack);
            }
        }
        return EnumActionResult.PASS;
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack stack = player.func_184586_b(hand);
            if (LinkMode.fromStack(stack) == LinkMode.ENABLED && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return EnumActionResult.FAIL;
            }
            if (this.useBucketOnFluidBlock(world, player, stack) == EnumActionResult.SUCCESS) {
                return EnumActionResult.SUCCESS;
            }
            return this.useBucketOnBlock(world, pos, side, player, stack);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K || LinkMode.fromStack(stack) == LinkMode.ENABLED && !OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        EnumActionResult result = this.useBucketOnFluidBlock(world, player, stack);
        return new ActionResult(result, (Object)stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String baseName;
        FluidStack fluidStack = this.getFluidCached(stack);
        String string = baseName = LinkMode.fromStack(stack) == LinkMode.ENABLED ? super.func_77653_i(stack) : this.getBaseItemDisplayName(stack);
        if (fluidStack != null && fluidStack.amount > 0 && fluidStack.getFluid() != null) {
            String rst = TextFormatting.RESET.toString() + TextFormatting.WHITE.toString();
            String fluidName = fluidStack.getFluid().getLocalizedName(fluidStack);
            return baseName + " - " + TextFormatting.GREEN.toString() + fluidName + rst;
        }
        return baseName;
    }

    @Override
    public void addTooltipLines(ItemStack stack, EntityPlayer player, List<String> list, boolean verbose) {
        String fluidName;
        if (stack.func_77978_p() == null) {
            super.addTooltipLines(stack, player, list, verbose);
            return;
        }
        FluidStack fluidStack = this.getFluidCached(stack);
        String preNr = TextFormatting.BLUE.toString();
        String preTxt = TextFormatting.DARK_GREEN.toString();
        String rst = TextFormatting.RESET.toString() + TextFormatting.GRAY.toString();
        int amount = 0;
        int capacity = this.getCapacityCached(stack, player);
        if (fluidStack != null && fluidStack.getFluid() != null) {
            amount = fluidStack.amount;
            fluidName = preTxt + fluidStack.getFluid().getLocalizedName(fluidStack) + rst;
        } else {
            fluidName = I18n.func_135052_a((String)"enderutilities.tooltip.item.empty", (Object[])new Object[0]);
        }
        BucketMode mode = BucketMode.fromStack(stack);
        LinkMode link = LinkMode.fromStack(stack);
        String amountStr = String.format("%s%s%s mB / %s%s%s mB", preNr, EUStringUtils.formatNumberWithKSeparators(amount), rst, preNr, EUStringUtils.formatNumberWithKSeparators(capacity), rst);
        if (verbose) {
            if (link == LinkMode.ENABLED) {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cached.fluid", (Object[])new Object[0]) + ": " + fluidName);
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cached.amount", (Object[])new Object[0]) + ": " + amountStr);
            } else {
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.fluid", (Object[])new Object[0]) + ": " + fluidName);
                list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.amount", (Object[])new Object[0]) + ": " + amountStr);
            }
        } else if (link == LinkMode.ENABLED) {
            list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.cached.fluid.compact", (Object[])new Object[0]) + ": " + fluidName + " - " + amountStr);
        } else {
            list.add(fluidName + " - " + amountStr);
        }
        list.add(I18n.func_135052_a((String)"enderutilities.tooltip.item.mode", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)mode.getUnlocalizedName(), (Object[])new Object[0]));
        if (link == LinkMode.ENABLED) {
            super.addTooltipLines(stack, player, list, verbose);
        }
    }

    public boolean isTargetUsable(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return world.func_175660_a(player, pos) && player.func_175151_a(pos, side, stack);
    }

    public EnumActionResult useBucketOnTank(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        FluidStack fluidStack;
        TileEntity te = world.func_175625_s(pos);
        if (!this.isTargetUsable(world, pos, side, player, stack) || te == null || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return EnumActionResult.PASS;
        }
        IFluidHandler iFluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        String blockName = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)world.func_180495_p(pos).func_177230_c()).toString();
        if (blockName.equals("ThermalExpansion:Tank")) {
            side = EnumFacing.UP;
        }
        FluidStack storedFluidStack = this.getFluid(stack, player);
        BucketMode mode = BucketMode.fromStack(stack);
        int storedFluidAmount = 0;
        if (storedFluidStack != null) {
            storedFluidAmount = storedFluidStack.amount;
        }
        if (mode == BucketMode.FILL || mode == BucketMode.NORMAL && !player.func_70093_af()) {
            int amount;
            FluidStack fluidStack2 = iFluidHandler.drain(1000, false);
            if (fluidStack2 != null && (amount = Math.min(this.getCapacityAvailable(stack, fluidStack2, player), 1000)) > 0 && (storedFluidAmount == 0 || fluidStack2.isFluidEqual(storedFluidStack)) && (fluidStack2 = iFluidHandler.drain(amount, false)) != null && this.fill(stack, fluidStack2, false, player) == fluidStack2.amount) {
                fluidStack2 = iFluidHandler.drain(amount, true);
                this.fill(stack, fluidStack2, true, player);
                return EnumActionResult.SUCCESS;
            }
        } else if (storedFluidAmount > 0 && (fluidStack = this.drain(stack, 1000, false, player)) != null && iFluidHandler.fill(fluidStack, false) > 0) {
            int amount = iFluidHandler.fill(fluidStack, true);
            this.drain(stack, amount, true, player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult useBucketOnBlock(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        int storedFluidAmount;
        if (!this.isTargetUsable(world, pos = pos.func_177972_a(side), side, player, stack)) {
            return EnumActionResult.PASS;
        }
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            return this.useBucketOnFluidBlock(world, pos, side, player, stack);
        }
        FluidStack fluidStack = this.getFluid(stack, player);
        int n = storedFluidAmount = fluidStack != null ? fluidStack.amount : 0;
        if (storedFluidAmount >= 1000 && BucketMode.fromStack(stack) != BucketMode.FILL && (fluidStack = this.drain(stack, 1000, false, player)) != null && fluidStack.amount == 1000 && this.tryPlaceFluidBlock(world, pos, fluidStack)) {
            this.drain(stack, 1000, true, player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult useBucketOnFluidBlock(World world, EntityPlayer player, ItemStack stack) {
        RayTraceResult rayTrace = this.func_77621_a(world, player, true);
        if (rayTrace == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return EnumActionResult.PASS;
        }
        return this.useBucketOnFluidBlock(world, rayTrace.func_178782_a(), rayTrace.field_178784_b, player, stack);
    }

    public EnumActionResult useBucketOnFluidBlock(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        int storedFluidAmount;
        IBlockState state = world.func_180495_p(pos);
        Block targetBlock = state.func_177230_c();
        if (!this.isTargetUsable(world, pos, side, player, stack) || !state.func_185904_a().func_76224_d()) {
            return EnumActionResult.PASS;
        }
        FluidStack storedFluidStack = this.getFluid(stack, player);
        FluidStack targetFluidStack = null;
        IFluidBlock iFluidBlock = null;
        int n = storedFluidAmount = storedFluidStack != null ? storedFluidStack.amount : 0;
        if (targetBlock instanceof IFluidBlock) {
            iFluidBlock = (IFluidBlock)targetBlock;
            targetFluidStack = iFluidBlock.drain(world, pos, false);
        } else {
            Fluid fluid;
            if (targetBlock == Blocks.field_150358_i) {
                targetBlock = Blocks.field_150355_j;
                fluid = FluidRegistry.WATER;
            } else if (targetBlock == Blocks.field_150356_k) {
                targetBlock = Blocks.field_150353_l;
                fluid = FluidRegistry.LAVA;
            } else {
                fluid = FluidRegistry.lookupFluidForBlock((Block)targetBlock);
            }
            if (fluid != null) {
                targetFluidStack = new FluidStack(fluid, 1000);
            }
        }
        BucketMode mode = BucketMode.fromStack(stack);
        if (mode != BucketMode.DRAIN && (storedFluidAmount == 0 || this.getCapacityAvailable(stack, targetFluidStack, player) >= 1000 && storedFluidStack.isFluidEqual(targetFluidStack) && (!player.func_70093_af() || mode == BucketMode.FILL))) {
            if (iFluidBlock != null) {
                if (iFluidBlock.canDrain(world, pos) && (targetFluidStack = iFluidBlock.drain(world, pos, false)) != null && this.fill(stack, targetFluidStack, false, player) == targetFluidStack.amount) {
                    targetFluidStack = iFluidBlock.drain(world, pos, true);
                    this.fill(stack, targetFluidStack, true, player);
                    SoundEvent sound = targetBlock == Blocks.field_150353_l ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            if (targetFluidStack != null && state.func_177230_c().func_176201_c(state) == 0 && this.fill(stack, targetFluidStack, false, player) == targetFluidStack.amount && world.func_175698_g(pos)) {
                this.fill(stack, targetFluidStack, true, player);
                SoundEvent sound = targetBlock == Blocks.field_150353_l ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                world.func_184133_a(null, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return EnumActionResult.SUCCESS;
            }
        }
        if (storedFluidStack != null && storedFluidAmount >= 1000 && mode != BucketMode.FILL) {
            FluidStack fluidStack;
            if ((player.func_70093_af() || !storedFluidStack.isFluidEqual(targetFluidStack) || state.func_177230_c().func_176201_c(state) != 0) && (fluidStack = this.drain(stack, 1000, false, player)) != null && fluidStack.amount == 1000 && this.tryPlaceFluidBlock(world, pos, storedFluidStack)) {
                this.drain(stack, 1000, true, player);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    public boolean tryPlaceFluidBlock(World world, BlockPos pos, FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null || !fluidStack.getFluid().canBePlacedInWorld()) {
            return false;
        }
        Block block = fluidStack.getFluid().getBlock();
        if (block == Blocks.field_150355_j) {
            block = Blocks.field_150358_i;
        } else if (block == Blocks.field_150353_l) {
            block = Blocks.field_150356_k;
        }
        IBlockState state = world.func_180495_p(pos);
        Material material = state.func_185904_a();
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        if (world.field_73011_w.func_177500_n() && block == Blocks.field_150358_i) {
            float x = pos.func_177958_n();
            float y = pos.func_177956_o();
            float z = pos.func_177952_p();
            world.func_184148_a(null, (double)(x + 0.5f), (double)(y + 0.5f), (double)(z + 0.5f), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
                world.func_175655_b(pos, true);
            }
            world.func_180501_a(pos, block.func_176223_P(), 3);
            SoundEvent soundevent = block == Blocks.field_150356_k ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
            world.func_184133_a(null, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        return true;
    }

    public int getCapacityCached(ItemStack stack, EntityPlayer player) {
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED) {
            NBTTagCompound moduleNbt;
            ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            if (!moduleStack.func_190926_b() && (moduleNbt = moduleStack.func_77978_p()) != null && moduleNbt.func_150297_b("CapacityCached", 3)) {
                return moduleNbt.func_74762_e("CapacityCached");
            }
            return 0;
        }
        return this.getCapacity(stack, player);
    }

    public int getCapacityAvailable(ItemStack stack, FluidStack fluidStackIn, EntityPlayer player) {
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED) {
            IFluidHandler handler = this.getLinkedTank(stack);
            if (handler != null) {
                IFluidTankProperties[] tank = handler.getTankProperties();
                if (tank == null || tank.length < 1 || tank[0] == null) {
                    return 0;
                }
                FluidStack existingFluidStack = tank[0].getContents();
                if (fluidStackIn == null) {
                    return tank[0].getCapacity() - (existingFluidStack != null ? existingFluidStack.amount : 0);
                }
                fluidStackIn = fluidStackIn.copy();
                fluidStackIn.amount = Integer.MAX_VALUE;
                return handler.fill(fluidStackIn, false);
            }
            return 0;
        }
        FluidStack existingFluidStack = this.getFluid(stack, player);
        if (existingFluidStack != null) {
            return this.getCapacity(stack, player) - existingFluidStack.amount;
        }
        return this.getCapacity(stack, player);
    }

    public void cacheFluid(ItemStack stack, FluidStack fluidStack) {
        ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (!moduleStack.func_190926_b()) {
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            if (moduleNbt == null) {
                moduleNbt = new NBTTagCompound();
            }
            if (fluidStack != null) {
                moduleNbt.func_74782_a("FluidCached", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
            } else {
                moduleNbt.func_82580_o("FluidCached");
            }
            moduleStack.func_77982_d(moduleNbt);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, moduleStack);
        }
        this.cacheCapacity(stack);
    }

    public void cacheCapacity(ItemStack stack) {
        ItemStack moduleStack;
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED && !(moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL)).func_190926_b() && moduleStack.func_77978_p() != null) {
            NBTTagCompound moduleNbt = moduleStack.func_77978_p();
            IFluidHandler handler = this.getLinkedTank(stack);
            if (handler != null) {
                IFluidTankProperties[] tank = handler.getTankProperties();
                if (tank != null && tank.length > 0 && tank[0] != null) {
                    moduleNbt.func_74768_a("CapacityCached", tank[0].getCapacity());
                } else {
                    moduleNbt.func_74768_a("CapacityCached", 0);
                }
            } else {
                moduleNbt.func_82580_o("CapacityCached");
            }
            moduleStack.func_77982_d(moduleNbt);
            this.setSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, moduleStack);
        }
    }

    public TargetData getLinkedTankTargetData(ItemStack stack) {
        TargetData targetData = TargetData.getTargetFromSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        if (targetData != null) {
            if ("ThermalExpansion:Tank".equals(targetData.blockName)) {
                targetData.facing = EnumFacing.UP;
            }
            return targetData;
        }
        return null;
    }

    public IFluidHandler getLinkedTank(ItemStack stack) {
        TileEntity te;
        WorldServer world;
        TargetData targetData = this.getLinkedTankTargetData(stack);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (targetData != null && server != null && (world = server.func_71218_a(targetData.dimension)) != null && ChunkLoading.getInstance().loadChunkForcedWithModTicket(targetData.dimension, targetData.pos.func_177958_n() >> 4, targetData.pos.func_177952_p() >> 4, 30) && (te = world.func_175625_s(targetData.pos)) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, targetData.facing)) {
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, targetData.facing);
        }
        return null;
    }

    public FluidStack getFluidCached(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            if (LinkMode.fromStack(stack) == LinkMode.ENABLED) {
                ItemStack moduleStack = this.getSelectedModuleStack(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
                if (!moduleStack.func_190926_b() && moduleStack.func_77978_p() != null && moduleStack.func_77978_p().func_150297_b("FluidCached", 10)) {
                    return FluidStack.loadFluidStackFromNBT((NBTTagCompound)moduleStack.func_77978_p().func_74775_l("FluidCached"));
                }
            } else if (nbt.func_150297_b("Fluid", 10)) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
            }
        }
        return null;
    }

    public int getCapacity(ItemStack stack, @Nullable EntityPlayer player) {
        if (LinkMode.fromStack(stack) == LinkMode.DISABLED) {
            return Configs.enderBucketCapacity;
        }
        if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
            return 0;
        }
        TargetData targetData = this.getLinkedTankTargetData(stack);
        IFluidHandler handler = this.getLinkedTank(stack);
        if (targetData != null && handler != null) {
            IFluidTankProperties[] tank = handler.getTankProperties();
            if (tank != null && tank.length > 0 && tank[0] != null) {
                return tank[0].getCapacity();
            }
            FluidStack fluidStack = handler.drain(Integer.MAX_VALUE, false);
            if (fluidStack != null) {
                FluidStack fs = fluidStack.copy();
                fs.amount = Integer.MAX_VALUE;
                return handler.fill(fs, false) + fluidStack.amount;
            }
            return handler.fill(new FluidStack(FluidRegistry.WATER, Integer.MAX_VALUE), false);
        }
        return 0;
    }

    public FluidStack getFluid(ItemStack stack, @Nullable EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED) {
            if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return null;
            }
            IFluidHandler handler = this.getLinkedTank(stack);
            if (handler != null) {
                FluidStack fluidStack = handler.drain(Integer.MAX_VALUE, false);
                this.cacheFluid(stack, fluidStack);
                return fluidStack;
            }
            return null;
        }
        if (nbt.func_150297_b("Fluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public FluidStack drain(ItemStack stack, int maxDrain, boolean doDrain, @Nullable EntityPlayer player) {
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED) {
            if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return null;
            }
            IFluidHandler handler = this.getLinkedTank(stack);
            if (handler != null) {
                if (!UtilItemModular.useEnderCharge(stack, (int)(0.2 * (double)maxDrain), !doDrain)) {
                    return null;
                }
                FluidStack fluidStack = handler.drain(maxDrain, doDrain);
                this.cacheFluid(stack, handler.drain(Integer.MAX_VALUE, false));
                return fluidStack;
            }
            return null;
        }
        int drained = 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
            return null;
        }
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        if (fluidStack == null) {
            return null;
        }
        drained = Math.min(fluidStack.amount, maxDrain);
        if (doDrain) {
            if (drained >= fluidStack.amount) {
                nbt.func_82580_o("Fluid");
                if (nbt.func_82582_d()) {
                    stack.func_77982_d(null);
                }
            } else {
                NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
                fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            }
        }
        fluidStack.amount = drained;
        return fluidStack;
    }

    public int fill(ItemStack stack, FluidStack fluidStackIn, boolean doFill, @Nullable EntityPlayer player) {
        if (fluidStackIn == null) {
            return 0;
        }
        if (LinkMode.fromStack(stack) == LinkMode.ENABLED) {
            if (!OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player)) {
                return 0;
            }
            IFluidHandler handler = this.getLinkedTank(stack);
            if (handler != null) {
                if (!UtilItemModular.useEnderCharge(stack, (int)(0.2 * (double)fluidStackIn.amount), !doFill)) {
                    return 0;
                }
                int amount = handler.fill(fluidStackIn, doFill);
                this.cacheFluid(stack, handler.drain(Integer.MAX_VALUE, false));
                return amount;
            }
            return 0;
        }
        int capacityAvailable = this.getCapacityAvailable(stack, fluidStackIn, player);
        NBTTagCompound nbt = stack.func_77978_p();
        if (!doFill) {
            if (nbt == null || !nbt.func_150297_b("Fluid", 10)) {
                return Math.min(capacityAvailable, fluidStackIn.amount);
            }
            FluidStack storedFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
            if (storedFluidStack == null) {
                return Math.min(capacityAvailable, fluidStackIn.amount);
            }
            if (!storedFluidStack.isFluidEqual(fluidStackIn)) {
                return 0;
            }
            return Math.min(capacityAvailable, fluidStackIn.amount);
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        if (!nbt.func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = fluidStackIn.writeToNBT(new NBTTagCompound());
            if (capacityAvailable < fluidStackIn.amount) {
                fluidTag.func_74768_a("Amount", capacityAvailable);
                nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacityAvailable;
            }
            nbt.func_74782_a("Fluid", (NBTBase)fluidTag);
            return fluidStackIn.amount;
        }
        NBTTagCompound fluidTag = nbt.func_74775_l("Fluid");
        FluidStack storedFluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        int filled = 0;
        if (!storedFluidStack.isFluidEqual(fluidStackIn)) {
            return 0;
        }
        if (fluidStackIn.amount < capacityAvailable) {
            storedFluidStack.amount += fluidStackIn.amount;
            filled = fluidStackIn.amount;
        } else {
            storedFluidStack.amount += capacityAvailable;
        }
        nbt.func_74782_a("Fluid", (NBTBase)storedFluidStack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public int getMaxModules(ItemStack containerStack, ItemStack moduleStack) {
        if (moduleStack.func_190926_b() || !(moduleStack.func_77973_b() instanceof IModule)) {
            return 0;
        }
        IModule imodule = (IModule)moduleStack.func_77973_b();
        ItemModule.ModuleType moduleType = imodule.getModuleType(moduleStack);
        if (!moduleType.equals(ItemModule.ModuleType.TYPE_LINKCRYSTAL) || imodule.getModuleTier(moduleStack) == 1) {
            return this.getMaxModules(containerStack, moduleType);
        }
        return 0;
    }

    @Override
    public boolean doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 1) {
            BucketMode.cycleMode(stack);
            return true;
        }
        if (HotKeys.EnumKey.TOGGLE.matches(key, 65536)) {
            LinkMode.cycleMode(stack);
            return true;
        }
        if ((HotKeys.EnumKey.TOGGLE.matches(key, 131072, 65536) || HotKeys.EnumKey.SCROLL.matches(key, 131072)) && LinkMode.fromStack(stack) == LinkMode.ENABLED) {
            return super.doKeyBindingAction(player, stack, key);
        }
        return super.doKeyBindingAction(player, stack, key);
    }

    @Override
    public ResourceLocation[] getItemVariants() {
        return new ResourceLocation[]{new ModelResourceLocation("enderutilities:item_enderbucket", "inventory")};
    }

    @Override
    public ModelResourceLocation getModelLocation(ItemStack stack) {
        return new ModelResourceLocation("enderutilities:item_enderbucket", "inventory");
    }

    public static enum BucketMode {
        NORMAL("enderutilities.tooltip.item.bucket.mode.normal"),
        FILL("enderutilities.tooltip.item.bucket.mode.fill"),
        DRAIN("enderutilities.tooltip.item.bucket.mode.drain"),
        BIND("enderutilities.tooltip.item.bucket.mode.bind");

        private final String unlocName;

        private BucketMode(String unlocName) {
            this.unlocName = unlocName;
        }

        public String getUnlocalizedName() {
            return this.unlocName;
        }

        public static BucketMode fromStack(ItemStack stack) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag == null ? NORMAL : BucketMode.values()[MathHelper.func_76125_a((int)tag.func_74771_c("Mode"), (int)0, (int)(BucketMode.values().length - 1))];
        }

        public static void cycleMode(ItemStack stack) {
            int mode = BucketMode.fromStack(stack).ordinal() + 1;
            if (mode >= BucketMode.values().length || mode == BIND.ordinal() && LinkMode.fromStack(stack) == LinkMode.DISABLED) {
                mode = 0;
            }
            NBTUtils.getCompoundTag(stack, null, true).func_74774_a("Mode", (byte)mode);
        }
    }

    public static enum LinkMode {
        DISABLED,
        ENABLED;


        public static LinkMode fromStack(ItemStack stack) {
            NBTTagCompound tag = stack.func_77978_p();
            return tag != null && tag.func_74767_n("Linked") ? ENABLED : DISABLED;
        }

        public static void cycleMode(ItemStack stack) {
            int mode = LinkMode.fromStack(stack).ordinal() & 1 ^ 1;
            NBTUtils.getCompoundTag(stack, null, true).func_74774_a("Linked", (byte)mode);
        }
    }
}

