/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.item;

import fi.dy.masa.enderutilities.inventory.ItemStackHandlerBasic;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;

public class InventoryItem
extends ItemStackHandlerBasic {
    protected ItemStack containerStack = ItemStack.field_190927_a;
    protected boolean isRemote;
    protected UUID containerUUID;
    protected IItemHandler hostInventory;

    public InventoryItem(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote) {
        this(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, "Items");
    }

    public InventoryItem(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, String tagName) {
        this(containerStack, invSize, stackLimit, allowCustomStackSizes, isRemote, tagName, null, null);
    }

    public InventoryItem(ItemStack containerStack, int invSize, int stackLimit, boolean allowCustomStackSizes, boolean isRemote, String tagName, UUID containerUUID, IItemHandler hostInv) {
        super(invSize, stackLimit, allowCustomStackSizes, tagName);
        this.containerStack = containerStack;
        this.isRemote = isRemote;
        this.containerUUID = containerUUID;
        this.hostInventory = hostInv;
    }

    public void setIsRemote(boolean isRemote) {
        this.isRemote = isRemote;
    }

    protected void clearInventory() {
        this.items.clear();
    }

    public UUID getContainerUUID() {
        return this.containerUUID;
    }

    public void setHostInventory(IItemHandler inv) {
        this.hostInventory = inv;
    }

    public void setHostInventory(IItemHandler inv, UUID uuid) {
        this.hostInventory = inv;
        this.containerUUID = uuid;
    }

    public ItemStack getContainerItemStack() {
        if (this.containerUUID != null && this.hostInventory != null) {
            return InventoryUtils.getItemStackByUUID(this.hostInventory, this.containerUUID, "UUID");
        }
        return this.containerStack;
    }

    public void setContainerItemStack(ItemStack stack) {
        this.containerStack = stack;
        this.readFromContainerItemStack();
    }

    public void readFromContainerItemStack() {
        if (!this.isRemote) {
            this.clearInventory();
            ItemStack stack = this.getContainerItemStack();
            if (!stack.func_190926_b() && stack.func_77942_o() && this.isCurrentlyAccessible()) {
                this.deserializeNBT(stack.func_77978_p());
            }
        }
    }

    protected void writeToContainerItemStack() {
        ItemStack stack;
        if (!this.isRemote && !(stack = this.getContainerItemStack()).func_190926_b() && this.isCurrentlyAccessible()) {
            NBTUtils.writeItemsToContainerItem(stack, (NonNullList<ItemStack>)this.items, this.getItemStorageTagName(), true);
        }
    }

    public boolean isCurrentlyAccessible() {
        return !this.getContainerItemStack().func_190926_b();
    }

    public boolean isAccessibleBy(Entity entity) {
        return !this.getContainerItemStack().func_190926_b();
    }

    public boolean isAccessibleBy(UUID uuid) {
        return !this.getContainerItemStack().func_190926_b();
    }

    public boolean isPrivate() {
        OwnerData owner = OwnerData.getOwnerDataFromItem(this.getContainerItemStack());
        return owner != null && !owner.getIsPublic();
    }

    @Override
    public int getInventoryStackLimit() {
        return this.getInventoryStackLimitFromContainerStack(this.getContainerItemStack());
    }

    public int getInventoryStackLimitFromContainerStack(ItemStack stack) {
        int tier;
        if (!stack.func_190926_b() && stack.func_77973_b() == EnderUtilitiesItems.ENDER_PART && (tier = ((IModule)stack.func_77973_b()).getModuleTier(stack)) >= 6 && tier <= 12) {
            return (int)Math.pow(2.0, tier);
        }
        return super.getInventoryStackLimit();
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return !this.getContainerItemStack().func_190926_b() && this.isCurrentlyAccessible();
    }

    @Override
    public void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (!this.isRemote) {
            this.writeToContainerItemStack();
        }
    }
}

