/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container.base;

import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.inventory.ItemStackHandlerLockable;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.container.base.SlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerCraftResult;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerFurnaceOutput;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.inventory.wrapper.PlayerInvWrapperNoSync;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageSyncCustomSlot;
import fi.dy.masa.enderutilities.network.message.MessageSyncSlot;
import fi.dy.masa.enderutilities.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerEnderUtilities
extends Container {
    public static final int GUI_ACTION_SCROLL_MOVE = 0;
    public static final int GUI_ACTION_SCROLL_SET = 1;
    public final EntityPlayer player;
    protected final boolean isClient;
    protected final InventoryPlayer inventoryPlayer;
    protected final IItemHandlerModifiable playerInv;
    public final IItemHandler inventory;
    protected MergeSlotRange customInventorySlots;
    protected MergeSlotRange playerMainSlots;
    protected MergeSlotRange playerHotbarSlots;
    protected MergeSlotRange playerMainSlotsIncHotbar;
    protected MergeSlotRange playerOffhandSlots;
    protected MergeSlotRange playerArmorSlots;
    protected List<MergeSlotRange> mergeSlotRangesExtToPlayer;
    protected List<MergeSlotRange> mergeSlotRangesPlayerToExt;

    public ContainerEnderUtilities(EntityPlayer player, IItemHandler inventory) {
        this.player = player;
        this.isClient = player.func_130014_f_().field_72995_K;
        this.inventoryPlayer = player.field_71071_by;
        this.playerInv = new PlayerInvWrapperNoSync(player.field_71071_by);
        this.inventory = inventory;
        this.mergeSlotRangesExtToPlayer = new ArrayList<MergeSlotRange>();
        this.mergeSlotRangesPlayerToExt = new ArrayList<MergeSlotRange>();
        this.customInventorySlots = new MergeSlotRange(0, 0);
        this.playerMainSlotsIncHotbar = new MergeSlotRange(0, 0);
        this.playerMainSlots = new MergeSlotRange(0, 0);
        this.playerHotbarSlots = new MergeSlotRange(0, 0);
        this.playerOffhandSlots = new MergeSlotRange(0, 0);
        this.playerArmorSlots = new MergeSlotRange(0, 0);
    }

    protected void addCustomInventorySlots() {
    }

    protected void addPlayerInventorySlots(int posX, int posY) {
        int playerInvStart = this.field_75151_b.size();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)this.playerInv, i * 9 + j + 9, posX + j * 18, posY + i * 18));
            }
        }
        this.playerMainSlots = new MergeSlotRange(playerInvStart, 27);
        int playerHotbarStart = this.field_75151_b.size();
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)this.playerInv, i, posX + i * 18, posY + 58));
        }
        this.playerMainSlotsIncHotbar = new MergeSlotRange(playerInvStart, 36);
        this.playerHotbarSlots = new MergeSlotRange(playerHotbarStart, 9);
    }

    protected void addOffhandSlot(int posX, int posY) {
        this.playerOffhandSlots = new MergeSlotRange(this.field_75151_b.size(), 1);
        this.func_75146_a((Slot)new SlotItemHandlerGeneric((IItemHandler)this.playerInv, 40, posX, posY){

            public String func_178171_c() {
                return "minecraft:items/empty_armor_slot_shield";
            }
        });
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public SlotRange getPlayerMainInventorySlotRange() {
        return this.playerMainSlotsIncHotbar;
    }

    public SlotRange getPlayerArmorSlots() {
        return this.playerArmorSlots;
    }

    public SlotRange getCustomInventorySlotRange() {
        return this.customInventorySlots;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot instanceof SlotItemHandler && !(slot instanceof SlotItemHandlerCraftResult) && !(slot instanceof SlotItemHandlerFurnaceOutput) && !this.inventoryPlayer.func_70445_o().func_190926_b();
    }

    public Slot func_75139_a(int slotId) {
        return slotId >= 0 && slotId < this.field_75151_b.size() ? super.func_75139_a(slotId) : null;
    }

    public SlotItemHandlerGeneric getSlotItemHandler(int slotId) {
        Slot slot = this.func_75139_a(slotId);
        return slot instanceof SlotItemHandlerGeneric ? (SlotItemHandlerGeneric)slot : null;
    }

    protected void syncCursorStackToClient() {
        this.syncStackToClient(-1, this.player.field_71071_by.func_70445_o());
    }

    protected void syncSlotToClient(int slotNum) {
        if (slotNum >= 0 && slotNum < this.field_75151_b.size()) {
            this.syncStackToClient(slotNum, this.func_75139_a(slotNum).func_75211_c());
        }
    }

    protected void syncStackToClient(int slotNum, ItemStack stack) {
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
            if (!(listener instanceof EntityPlayerMP)) continue;
            PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncSlot(this.field_75152_c, slotNum, stack), (EntityPlayerMP)listener);
        }
    }

    public void syncStackInSlot(int slotId, ItemStack stack) {
        if (slotId == -1) {
            this.player.field_71071_by.func_70437_b(stack);
        } else {
            Slot slot = this.func_75139_a(slotId);
            if (slot instanceof SlotItemHandlerGeneric) {
                ((SlotItemHandlerGeneric)slot).syncStack(stack);
            } else {
                this.func_75141_a(slotId, stack);
            }
        }
    }

    public void func_75142_b() {
        if (!this.isClient) {
            for (int slot = 0; slot < this.field_75151_b.size(); ++slot) {
                ItemStack currentStack = ((Slot)this.field_75151_b.get(slot)).func_75211_c();
                ItemStack prevStack = (ItemStack)this.field_75153_a.get(slot);
                if (ItemStack.func_77989_b((ItemStack)prevStack, (ItemStack)currentStack)) continue;
                prevStack = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                this.field_75153_a.set(slot, (Object)prevStack);
                for (int i = 0; i < this.field_75149_d.size(); ++i) {
                    IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
                    if (!(listener instanceof EntityPlayerMP)) continue;
                    PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncSlot(this.field_75152_c, slot, prevStack), (EntityPlayerMP)listener);
                }
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotNum) {
        this.transferStackFromSlot(player, slotNum);
        return ItemStack.field_190927_a;
    }

    protected boolean transferStackFromSlot(EntityPlayer player, int slotNum) {
        Slot slot = this.func_75139_a(slotNum);
        if (slot == null || !slot.func_75216_d() || !slot.func_82869_a(player)) {
            return false;
        }
        if (this.playerArmorSlots.contains(slotNum) || this.playerOffhandSlots.contains(slotNum)) {
            return this.transferStackToSlotRange(player, slotNum, this.playerMainSlotsIncHotbar, false);
        }
        if (this.playerMainSlotsIncHotbar.contains(slotNum)) {
            return this.transferStackFromPlayerMainInventory(player, slotNum);
        }
        return this.transferStackToSlotRange(player, slotNum, this.playerMainSlotsIncHotbar, true);
    }

    protected boolean transferStackFromPlayerMainInventory(EntityPlayer player, int slotNum) {
        if (this.transferStackToSlotRange(player, slotNum, this.playerArmorSlots, false)) {
            return true;
        }
        if (this.transferStackToPrioritySlots(player, slotNum, false)) {
            return true;
        }
        return this.transferStackToSlotRange(player, slotNum, this.customInventorySlots, false);
    }

    protected boolean transferStackToPrioritySlots(EntityPlayer player, int slotNum, boolean reverse) {
        boolean ret = false;
        for (MergeSlotRange slotRange : this.mergeSlotRangesPlayerToExt) {
            ret |= this.transferStackToSlotRange(player, slotNum, slotRange, reverse);
        }
        return ret;
    }

    protected boolean transferStackToSlotRange(EntityPlayer player, int slotNum, MergeSlotRange slotRange, boolean reverse) {
        SlotItemHandlerGeneric slot = this.getSlotItemHandler(slotNum);
        if (slot == null || !slot.func_75216_d() || !slot.func_82869_a(player)) {
            return false;
        }
        ItemStack stack = slot.func_75211_c().func_77946_l();
        int amount = Math.min(stack.func_190916_E(), stack.func_77976_d());
        stack.func_190920_e(amount);
        stack = this.mergeItemStack(stack, slotRange, reverse, true);
        if (!stack.func_190926_b()) {
            if (!slot.func_75214_a(stack) || stack.func_190916_E() == amount) {
                return false;
            }
            amount -= stack.func_190916_E();
        }
        stack = slot.func_75209_a(amount);
        slot.func_190901_a(player, stack);
        stack = this.mergeItemStack(stack, slotRange, reverse, false);
        if (!stack.func_190926_b()) {
            slot.insertItem(stack, false);
            EnderUtilities.logger.warn("Failed to merge all items in '{}'. This shouldn't happen and should be reported.", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        return true;
    }

    protected int getMaxStackSizeFromSlotAndStack(Slot slot, ItemStack stack) {
        return !stack.func_190926_b() ? Math.min(slot.func_178170_b(stack), stack.func_77976_d()) : slot.func_75219_a();
    }

    protected boolean func_75135_a(ItemStack stack, int slotStart, int slotEndExclusive, boolean reverse) {
        return false;
    }

    protected ItemStack mergeItemStack(ItemStack stack, MergeSlotRange slotRange, boolean reverse, boolean simulate) {
        SlotItemHandlerGeneric slot;
        int slotIndex;
        int slotStart = slotRange.first;
        int slotEndExclusive = slotRange.lastExc;
        int n = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
        while (!stack.func_190926_b() && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
            slot = this.getSlotItemHandler(slotIndex);
            if (slot != null && slot.func_75216_d() && slot.func_75214_a(stack)) {
                stack = slot.insertItem(stack, simulate);
            }
            slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
        }
        if (!stack.func_190926_b() && !slotRange.existingOnly) {
            int n2 = slotIndex = reverse ? slotEndExclusive - 1 : slotStart;
            while (!stack.func_190926_b() && slotIndex >= slotStart && slotIndex < slotEndExclusive) {
                slot = this.getSlotItemHandler(slotIndex);
                if (slot != null && !slot.func_75216_d() && slot.func_75214_a(stack)) {
                    stack = slot.insertItem(stack, simulate);
                }
                slotIndex = reverse ? slotIndex - 1 : slotIndex + 1;
            }
        }
        return stack;
    }

    protected void addMergeSlotRangeExtToPlayer(int start, int numSlots) {
        this.addMergeSlotRangeExtToPlayer(start, numSlots, false);
    }

    protected void addMergeSlotRangeExtToPlayer(int start, int numSlots, boolean existingOnly) {
        this.mergeSlotRangesExtToPlayer.add(new MergeSlotRange(start, numSlots, existingOnly));
    }

    protected void addMergeSlotRangePlayerToExt(int start, int numSlots) {
        this.addMergeSlotRangePlayerToExt(start, numSlots, false);
    }

    protected void addMergeSlotRangePlayerToExt(int start, int numSlots, boolean existingOnly) {
        this.mergeSlotRangesPlayerToExt.add(new MergeSlotRange(start, numSlots, existingOnly));
    }

    public void performGuiAction(EntityPlayer player, int action, int element) {
    }

    protected void syncLockableSlots(ItemStackHandlerLockable inv, int typeId, int progressBarId, boolean[] lockedLast, NonNullList<ItemStack> templateStacksLast) {
        int numSlots = inv.getSlots();
        for (int slot = 0; slot < numSlots; ++slot) {
            boolean locked = inv.isSlotLocked(slot);
            if (lockedLast[slot] != locked) {
                for (int i = 0; i < this.field_75149_d.size(); ++i) {
                    ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, progressBarId, (locked ? 32768 : 0) | slot);
                }
                lockedLast[slot] = locked;
            }
            ItemStack templateStack = inv.getTemplateStackInSlot(slot);
            if (InventoryUtils.areItemStacksEqual((ItemStack)templateStacksLast.get(slot), templateStack)) continue;
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                IContainerListener listener = (IContainerListener)this.field_75149_d.get(i);
                if (!(listener instanceof EntityPlayerMP)) continue;
                PacketHandler.INSTANCE.sendTo((IMessage)new MessageSyncCustomSlot(this.field_75152_c, typeId, slot, templateStack), (EntityPlayerMP)listener);
            }
            templateStacksLast.set(slot, (Object)templateStack.func_77946_l());
        }
    }
}

