/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.inventory.container;

import fi.dy.masa.enderutilities.inventory.ICustomSlotSync;
import fi.dy.masa.enderutilities.inventory.container.base.ContainerTileLargeStacks;
import fi.dy.masa.enderutilities.inventory.container.base.MergeSlotRange;
import fi.dy.masa.enderutilities.inventory.slot.SlotItemHandlerGeneric;
import fi.dy.masa.enderutilities.tileentity.TileEntityMSU;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;

public class ContainerMSU
extends ContainerTileLargeStacks
implements ICustomSlotSync {
    protected final TileEntityMSU temsu;
    private final boolean[] lockedLast;
    private final NonNullList<ItemStack> templateStacksLast;

    public ContainerMSU(EntityPlayer player, TileEntityMSU te) {
        super(player, te.getWrappedInventoryForContainer(player), te);
        this.temsu = te;
        this.inventoryNonWrapped = te.getInventoryMSU();
        int numSlots = this.inventoryNonWrapped.getSlots();
        this.lockedLast = new boolean[numSlots];
        this.templateStacksLast = NonNullList.func_191197_a((int)numSlots, (Object)ItemStack.field_190927_a);
        this.addCustomInventorySlots();
        this.addPlayerInventorySlots(8, 57);
    }

    @Override
    protected void addCustomInventorySlots() {
        int customInvStart = this.field_75151_b.size();
        int tier = MathHelper.func_76125_a((int)this.temsu.getStorageTier(), (int)0, (int)1);
        int posX = tier == 1 ? 8 : 80;
        int posY = 23;
        int slots = tier == 1 ? 9 : 1;
        for (int slot = 0; slot < slots; ++slot) {
            this.func_75146_a((Slot)new SlotItemHandlerGeneric(this.inventory, slot, posX + slot * 18, posY));
        }
        this.customInventorySlots = new MergeSlotRange(customInvStart, slots);
    }

    @Override
    public void func_75142_b() {
        this.syncLockableSlots(this.temsu.getInventoryMSU(), 0, 0, this.lockedLast, this.templateStacksLast);
        super.func_75142_b();
    }

    @Override
    public void func_75137_b(int id, int data) {
        super.func_75137_b(id, data);
        if (id == 0) {
            this.temsu.getInventoryMSU().setSlotLocked(data & 0xF, (data & 0x8000) != 0);
        }
    }

    @Override
    public void putCustomStack(int typeId, int slotNum, ItemStack stack) {
        this.temsu.getInventoryMSU().setTemplateStackInSlot(slotNum, stack);
    }
}

