/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.gui.client;

import fi.dy.masa.enderutilities.gui.client.base.GuiContainerLargeStacks;
import fi.dy.masa.enderutilities.gui.client.base.GuiEnderUtilities;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonIcon;
import fi.dy.masa.enderutilities.gui.client.button.GuiButtonStateCallback;
import fi.dy.masa.enderutilities.gui.client.button.IButtonStateCallback;
import fi.dy.masa.enderutilities.inventory.container.ContainerPickupManager;
import fi.dy.masa.enderutilities.inventory.item.InventoryItem;
import fi.dy.masa.enderutilities.inventory.item.InventoryItemModules;
import fi.dy.masa.enderutilities.item.ItemPickupManager;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageGuiAction;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiPickupManager
extends GuiContainerLargeStacks
implements IButtonStateCallback {
    public static final int NUM_LINK_CRYSTAL_SLOTS = 3;
    private final ContainerPickupManager containerPickupManager;
    private final InventoryItem inventoryItemTransmit;
    private final InventoryItemModules inventoryItemModules;
    private final InventoryItem inventoryItemFilters;
    private final int firstLinkCrystalSlot;

    public GuiPickupManager(ContainerPickupManager container) {
        super(container, 176, 256, "gui.container.pickupmanager");
        this.infoArea = new GuiEnderUtilities.InfoArea(153, 87, 18, 18, "enderutilities.gui.infoarea.pickupmanager", new Object[0]);
        this.containerPickupManager = container;
        this.inventoryItemTransmit = container.inventoryItemTransmit;
        this.inventoryItemModules = container.inventoryItemModules;
        this.inventoryItemFilters = container.inventoryItemFilters;
        this.firstLinkCrystalSlot = UtilItemModular.getFirstIndexOfModuleType(this.inventoryItemModules.getContainerItemStack(), ItemModule.ModuleType.TYPE_LINKCRYSTAL);
        this.scaledStackSizeTextInventories.add(this.inventoryItemTransmit);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.createButtons();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.container.pickupmanager", (Object[])new Object[0]), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.transportfilters", (Object[])new Object[0]), 8, 19, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.inventoryfilters", (Object[])new Object[0]), 81, 112, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"enderutilities.gui.label.filterpresets", (Object[])new Object[0]) + ":", 8, 163, 0x404040);
    }

    @Override
    protected void func_146976_a(float gameTicks, int mouseX, int mouseY) {
        ItemStack containerStack;
        int i;
        super.func_146976_a(gameTicks, mouseX, mouseY);
        this.bindTexture(this.guiTextureWidgets);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        if (!this.inventoryItemTransmit.isAccessibleBy((Entity)this.player)) {
            this.func_73729_b(x + 88, y + 28, 102, 0, 18, 18);
        }
        if (!this.inventoryItemModules.isAccessibleBy((Entity)this.player)) {
            for (i = 0; i < 3; ++i) {
                this.func_73729_b(x + 116 - 1 + i * 18, y + 29 - 1, 102, 0, 18, 18);
            }
        }
        if (!this.inventoryItemFilters.isAccessibleBy((Entity)this.player)) {
            int j;
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.func_73729_b(x + 8 - 1 + j * 18, y + 47 - 1 + i * 18, 102, 0, 18, 18);
                }
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < 9; ++j) {
                    this.func_73729_b(x + 8 - 1 + j * 18, y + 123 - 1 + i * 18, 102, 0, 18, 18);
                }
            }
        }
        if (!(containerStack = this.containerPickupManager.getContainerItem()).func_190926_b()) {
            int index = UtilItemModular.getStoredModuleSelection(containerStack, ItemModule.ModuleType.TYPE_LINKCRYSTAL);
            this.func_73729_b(x + 116 - 1 + index * 18, y + 29 - 1, 102, 18, 18, 18);
            this.func_73729_b(x + 119 + index * 18, y + 17, 120, 0, 10, 10);
            byte sel = NBTUtils.getByte(containerStack, "PickupManager", "SelPreset");
            this.func_73729_b(x + 101 + sel * 18, y + 162, 120, 0, 10, 10);
        }
        int slot = this.firstLinkCrystalSlot;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (this.inventoryItemModules.getStackInSlot(slot).func_190926_b()) {
                this.func_73729_b(x + 116 + i2 * 18, y + 29, 240, 32, 16, 16);
            }
            ++slot;
        }
    }

    @Override
    protected void drawTooltips(int mouseX, int mouseY) {
        Slot slot = this.getSlotUnderMouse();
        if (slot != null && slot == this.field_147002_h.func_75139_a(0) && !slot.func_75216_d()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(I18n.func_135052_a((String)"enderutilities.gui.label.transportitemsslot", (Object[])new Object[0]));
            this.drawHoveringText(list, mouseX, mouseY, this.field_146289_q);
        } else {
            super.drawTooltips(mouseX, mouseY);
        }
    }

    protected void createButtons() {
        int i;
        this.field_146292_n.clear();
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        for (i = 0; i < 3; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(i, x + 120 + i * 18, y + 18, 8, 8, 0, 0, this.guiTextureWidgets, 8, 0));
        }
        for (i = 0; i < 4; ++i) {
            this.field_146292_n.add(new GuiButtonIcon(i + 3, x + 102 + i * 18, y + 163, 8, 8, 0, 128 + i * 8, this.guiTextureWidgets, 8, 0));
        }
        this.field_146292_n.add(new GuiButtonStateCallback(7, x + 9, y + 29, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 98, "enderutilities.gui.label.pickup_manager.functionality.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(60, 28, "enderutilities.gui.label.pickup_manager.functionality.enabled")));
        this.field_146292_n.add(new GuiButtonStateCallback(8, x + 27, y + 29, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 70, "enderutilities.gui.label.blacklist"), GuiButtonStateCallback.ButtonState.createTranslate(60, 84, "enderutilities.gui.label.whitelist")));
        this.field_146292_n.add(new GuiButtonStateCallback(9, x + 45, y + 29, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 112, "enderutilities.gui.label.meta.match"), GuiButtonStateCallback.ButtonState.createTranslate(60, 126, "enderutilities.gui.label.meta.ignore")));
        this.field_146292_n.add(new GuiButtonStateCallback(10, x + 63, y + 29, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 154, "enderutilities.gui.label.nbt.ignore"), GuiButtonStateCallback.ButtonState.createTranslate(60, 140, "enderutilities.gui.label.nbt.match")));
        this.field_146292_n.add(new GuiButtonStateCallback(11, x + 9, y + 105, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 98, "enderutilities.gui.label.pickup_manager.functionality.disabled"), GuiButtonStateCallback.ButtonState.createTranslate(60, 28, "enderutilities.gui.label.pickup_manager.functionality.enabled")));
        this.field_146292_n.add(new GuiButtonStateCallback(12, x + 27, y + 105, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 70, "enderutilities.gui.label.blacklist"), GuiButtonStateCallback.ButtonState.createTranslate(60, 84, "enderutilities.gui.label.whitelist")));
        this.field_146292_n.add(new GuiButtonStateCallback(13, x + 45, y + 105, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 112, "enderutilities.gui.label.meta.match"), GuiButtonStateCallback.ButtonState.createTranslate(60, 126, "enderutilities.gui.label.meta.ignore")));
        this.field_146292_n.add(new GuiButtonStateCallback(14, x + 63, y + 105, 14, 14, 14, 0, this.guiTextureWidgets, this, GuiButtonStateCallback.ButtonState.createTranslate(60, 154, "enderutilities.gui.label.nbt.ignore"), GuiButtonStateCallback.ButtonState.createTranslate(60, 140, "enderutilities.gui.label.nbt.match")));
    }

    @Override
    public int getButtonStateIndex(int callbackId) {
        ItemStack stack = this.containerPickupManager.getContainerItem();
        if (!stack.func_190926_b()) {
            switch (callbackId) {
                case 7: {
                    return ItemPickupManager.getSettingValue(stack, "TxFiltEnabled") == 0 ? 0 : 1;
                }
                case 8: {
                    return ItemPickupManager.getSettingValue(stack, "TxFiltMode") == 0 ? 0 : 1;
                }
                case 9: {
                    return ItemPickupManager.getSettingValue(stack, "TxFiltMeta") == 0 ? 0 : 1;
                }
                case 10: {
                    return ItemPickupManager.getSettingValue(stack, "TxFiltNBT") == 0 ? 0 : 1;
                }
                case 11: {
                    return ItemPickupManager.getSettingValue(stack, "InvFiltEnabled") == 0 ? 0 : 1;
                }
                case 12: {
                    return ItemPickupManager.getSettingValue(stack, "InvFiltMode") == 0 ? 0 : 1;
                }
                case 13: {
                    return ItemPickupManager.getSettingValue(stack, "InvFiltMeta") == 0 ? 0 : 1;
                }
                case 14: {
                    return ItemPickupManager.getSettingValue(stack, "InvFiltNBT") == 0 ? 0 : 1;
                }
            }
        }
        return 0;
    }

    @Override
    public boolean isButtonEnabled(int callbackId) {
        return true;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k >= 0 && button.field_146127_k <= 2) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 0, button.field_146127_k));
        } else if (button.field_146127_k >= 3 && button.field_146127_k <= 6) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 1, button.field_146127_k - 3));
        } else if (button.field_146127_k >= 7 && button.field_146127_k <= 10) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 3, button.field_146127_k - 7));
        } else if (button.field_146127_k >= 11 && button.field_146127_k <= 14) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new MessageGuiAction(0, new BlockPos(0, 0, 0), 1004, 2, button.field_146127_k - 11));
        }
    }
}

