/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockInfo;
import fi.dy.masa.enderutilities.util.BlockPosBox;
import fi.dy.masa.enderutilities.util.BlockPosEU;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskReplaceBlocks3D
implements IPlayerTask {
    protected final int dimension;
    protected final UUID wandUUID;
    protected final BlockPosEU pos1;
    protected final BlockPosEU pos2;
    protected final BlockPosBox box;
    protected final IBlockState stateTarget;
    protected final BlockInfo blockInfoReplacement;
    protected final int blocksPerTick;
    protected int listIndex = 0;
    protected int placedCount = 0;
    protected int failCount = 0;

    public TaskReplaceBlocks3D(World world, UUID wandUUID, BlockPosEU pos1, BlockPosEU pos2, IBlockState stateTarget, BlockInfo blockInfoReplacement, int blocksPerTick) {
        this.dimension = world.field_73011_w.getDimension();
        this.wandUUID = wandUUID;
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.box = new BlockPosBox(pos1, pos2);
        this.stateTarget = stateTarget;
        this.blockInfoReplacement = blockInfoReplacement;
        this.blocksPerTick = blocksPerTick;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.BUILDERS_WAND);
        if (!stack.func_190926_b() && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            int bpt = 0;
            for (int i = 0; i < 20000 && bpt < this.blocksPerTick && this.listIndex < this.box.count; ++i) {
                BlockPosStateDist posState;
                BlockPos pos = this.box.getPosAtIndex(this.listIndex);
                ++this.listIndex;
                if (world.func_180495_p(pos) != this.stateTarget || !wand.replaceBlock(world, player, stack, posState = new BlockPosStateDist(new BlockPosEU(pos), this.blockInfoReplacement))) continue;
                ++this.placedCount;
                this.failCount = 0;
                ++bpt;
            }
            if (this.listIndex >= this.box.count) {
                return true;
            }
        } else {
            ++this.failCount;
        }
        if (this.failCount > 200) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
    }
}

