/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event.tasks;

import fi.dy.masa.enderutilities.event.tasks.IPlayerTask;
import fi.dy.masa.enderutilities.item.ItemBuildersWand;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.BlockPosStateDist;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.nbt.NBTUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class TaskReplaceBlocks
implements IPlayerTask {
    protected final int dimension;
    protected final UUID wandUUID;
    protected final List<BlockPosStateDist> positions;
    protected final int blocksPerTick;
    protected int listIndex = 0;
    protected int placedCount = 0;
    protected int failCount = 0;

    public TaskReplaceBlocks(World world, UUID wandUUID, List<BlockPosStateDist> positions, int blocksPerTick) {
        this.dimension = world.field_73011_w.getDimension();
        this.wandUUID = wandUUID;
        this.positions = positions;
        this.blocksPerTick = blocksPerTick;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canExecute(World world, EntityPlayer player) {
        return world.field_73011_w.getDimension() == this.dimension;
    }

    @Override
    public boolean execute(World world, EntityPlayer player) {
        ItemStack stack = EntityUtils.getHeldItemOfType((EntityLivingBase)player, EnderUtilitiesItems.BUILDERS_WAND);
        if (!stack.func_190926_b() && this.wandUUID.equals(NBTUtils.getUUIDFromItemStack(stack, "BuildersWand", false))) {
            ItemBuildersWand wand = (ItemBuildersWand)stack.func_77973_b();
            int i = 0;
            while (i < this.blocksPerTick && this.listIndex < this.positions.size()) {
                if (wand.replaceBlock(world, player, stack, this.positions.get(this.listIndex))) {
                    ++this.placedCount;
                    this.failCount = 0;
                    ++i;
                }
                ++this.listIndex;
            }
            if (this.listIndex >= this.positions.size()) {
                return true;
            }
        } else {
            ++this.failCount;
        }
        if (this.failCount > 200) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 0.6f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.positions.clear();
    }
}

