/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.enderutilities.EnderUtilities;
import fi.dy.masa.enderutilities.util.datafixer.TileEntityID;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="enderutilities")
public class MissingMappingEventHandler {
    @SubscribeEvent
    public static void onMissingMappingEventBlocks(RegistryEvent.MissingMappings<Block> event) {
        ImmutableList list = event.getMappings();
        Map<String, String> renameMap = TileEntityID.getMap();
        for (RegistryEvent.MissingMappings.Mapping mapping : list) {
            Block block;
            ResourceLocation oldLoc = mapping.key;
            String newName = renameMap.get(oldLoc.toString());
            if (newName == null || (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(newName))) == null || block == Blocks.field_150350_a) continue;
            mapping.remap((IForgeRegistryEntry)block);
            EnderUtilities.logger.info("Re-mapped block '{}' => '{}'", (Object)oldLoc, (Object)newName);
        }
    }

    @SubscribeEvent
    public static void onMissingMappingEventItems(RegistryEvent.MissingMappings<Item> event) {
        ImmutableList list = event.getMappings();
        Map<String, String> renameMap = TileEntityID.getMap();
        for (RegistryEvent.MissingMappings.Mapping mapping : list) {
            Item item;
            ResourceLocation oldLoc = mapping.key;
            String newName = renameMap.get(oldLoc.toString());
            if (newName == null || (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(newName))) == null || item == Items.field_190931_a) continue;
            mapping.remap((IForgeRegistryEntry)item);
            EnderUtilities.logger.info("Re-mapped item '{}' => '{}'", (Object)oldLoc, (Object)newName);
        }
    }
}

