/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.capabilities.EnderUtilitiesCapabilities;
import fi.dy.masa.enderutilities.config.Configs;
import fi.dy.masa.enderutilities.item.ItemLivingManipulator;
import fi.dy.masa.enderutilities.item.ItemMobHarness;
import fi.dy.masa.enderutilities.item.ItemPetContract;
import fi.dy.masa.enderutilities.item.ItemPortalScaler;
import fi.dy.masa.enderutilities.item.ItemSyringe;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.IModule;
import fi.dy.masa.enderutilities.item.base.ItemModule;
import fi.dy.masa.enderutilities.item.part.ItemEnderPart;
import fi.dy.masa.enderutilities.registry.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.WorldUtils;
import fi.dy.masa.enderutilities.util.nbt.OwnerData;
import fi.dy.masa.enderutilities.util.nbt.UtilItemModular;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityEventHandler {
    private static boolean preventAllEntitySpawningInWorld;

    public static void setPreventEntitySpawning(boolean preventSpawning) {
        preventAllEntitySpawningInWorld = preventSpawning;
    }

    @SubscribeEvent
    public void onAttachCapabilitiesEntity(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(EnderUtilitiesCapabilities.PORTAL_COOLDOWN_CAP_NAME, (ICapabilityProvider)new EnderUtilitiesCapabilities.PortalCooldownCapabilityProvider());
    }

    @SubscribeEvent
    public void onEntityInteractEvent(PlayerInteractEvent.EntityInteract event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184586_b(event.getHand());
        if (stack.func_190926_b()) {
            return;
        }
        Item item = stack.func_77973_b();
        boolean isRemote = player.func_130014_f_().field_72995_K;
        if (item == EnderUtilitiesItems.LIVING_MANIPULATOR) {
            if (event.getTarget() instanceof EntityLivingBase) {
                if (!isRemote) {
                    ((ItemLivingManipulator)item).handleInteraction(stack, player, (EntityLivingBase)event.getTarget());
                }
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        } else if (item == EnderUtilitiesItems.MOB_HARNESS && event.getTarget() instanceof EntityLivingBase) {
            ((ItemMobHarness)item).handleInteraction(stack, player, event.getTarget());
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.SUCCESS);
        } else if (item == EnderUtilitiesItems.ENDER_LASSO && event.getTarget() instanceof EntityLivingBase) {
            if ((Configs.enderLassoAllowPlayers || !EntityUtils.doesEntityStackHavePlayers(event.getTarget())) && OwnerData.canAccessSelectedModule(stack, ItemModule.ModuleType.TYPE_LINKCRYSTAL, (Entity)player) && UtilItemModular.useEnderCharge(stack, 1000, false)) {
                if (event.getTarget() instanceof EntityLiving && UtilItemModular.getInstalledModuleCount(stack, ItemModule.ModuleType.TYPE_MOBPERSISTENCE) > 0) {
                    EntityUtils.applyMobPersistence((EntityLiving)event.getTarget());
                }
                if (isRemote || TeleportEntity.teleportEntityUsingModularItem(event.getTarget(), stack, true, true) != null) {
                    event.setCanceled(true);
                    event.setCancellationResult(EnumActionResult.SUCCESS);
                }
            }
        } else if (item == EnderUtilitiesItems.PET_CONTRACT && event.getTarget() instanceof EntityLivingBase) {
            if (((ItemPetContract)stack.func_77973_b()).func_111207_a(stack, player, (EntityLivingBase)event.getTarget(), event.getHand())) {
                event.setCanceled(true);
                event.setCancellationResult(EnumActionResult.SUCCESS);
            }
        } else if (WorldUtils.isEndDimension(player.func_130014_f_()) && event.getTarget() instanceof EntityEnderCrystal && !isRemote) {
            ItemEnderPart part;
            int tier;
            if (item instanceof IChargeable) {
                IChargeable chargeable = (IChargeable)item;
                chargeable.addCharge(stack, chargeable.getCapacity(stack) >> 2, true);
            } else if (item == EnderUtilitiesItems.ENDER_PART && ((IModule)item).getModuleType(stack).equals(ItemModule.ModuleType.TYPE_ENDERCORE) && (tier = (part = (ItemEnderPart)item).getModuleTier(stack)) >= 10 && tier <= 12) {
                part.activateEnderCore(stack);
            }
        }
    }

    @SubscribeEvent
    public void onTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        ItemStack stack;
        if (TeleportEntity.isTeleportInProgress()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !(stack = EntityUtils.getHeldItemOfType((EntityLivingBase)((EntityPlayer)entity), EnderUtilitiesItems.PORTAL_SCALER)).func_190926_b() && EntityUtils.isEntityCollidingWithBlockSpace(entity.func_130014_f_(), entity, (Block)Blocks.field_150427_aO)) {
            boolean validDestination;
            World worldSource = entity.func_130014_f_();
            WorldServer worldDestination = entity.func_184102_h().func_71218_a(event.getDimension());
            boolean validSource = WorldUtils.isNetherDimension(worldSource) || WorldUtils.isOverworldDimension(worldSource);
            boolean bl = validDestination = worldDestination != null && (WorldUtils.isNetherDimension((World)worldDestination) || WorldUtils.isOverworldDimension((World)worldDestination));
            if (validSource && validDestination && ((ItemPortalScaler)stack.func_77973_b()).usePortalWithPortalScaler(stack, entity.func_130014_f_(), (EntityPlayer)entity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onAttackEntity(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityLiving && !event.getEntity().func_130014_f_().field_72995_K && event.getSource() instanceof EntityDamageSource && event.getEntity().func_184216_O().contains("enderutilities:passified")) {
            ItemSyringe.removePassifiedState((EntityLiving)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (event.getEntity() instanceof EntityLiving && event.getEntity().func_184216_O().contains("enderutilities:passified")) {
                ItemSyringe.passifyEntity((EntityLiving)event.getEntity());
            } else if (preventAllEntitySpawningInWorld) {
                event.setCanceled(true);
            }
        }
    }
}

