/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.event;

import fi.dy.masa.enderutilities.item.base.IAnvilRepairable;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.StringUtils;

public class AnvilUpdateEventHandler {
    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (left.func_77973_b() instanceof IAnvilRepairable) {
            IAnvilRepairable repairable = (IAnvilRepairable)left.func_77973_b();
            if (repairable.isRepairItem(left, right)) {
                this.fullyRepairItem(event, repairable, 1, 15);
            } else if (right.func_77973_b() == Items.field_151134_bR) {
                this.enchantItem(event, repairable, (ItemEnchantedBook)right.func_77973_b());
            } else {
                event.setCanceled(true);
            }
        }
    }

    private void fullyRepairItem(AnvilUpdateEvent event, IAnvilRepairable repairable, int materialCost, int xpCost) {
        ItemStack repaired = event.getLeft().func_77946_l();
        if (repairable.repairItem(repaired, -1)) {
            event.setMaterialCost(materialCost);
            event.setCost(xpCost);
            event.setOutput(repaired);
            this.updateItemName(event, repaired);
        } else {
            event.setCanceled(true);
        }
    }

    private void enchantItem(AnvilUpdateEvent event, IAnvilRepairable repairable, ItemEnchantedBook book) {
        ItemStack toolStack = event.getLeft().func_77946_l();
        ItemStack bookStack = event.getRight().func_77946_l();
        NBTTagList bookEnchantmentList = ItemEnchantedBook.func_92110_g((ItemStack)bookStack);
        if (bookEnchantmentList.func_74745_c() <= 0 || !toolStack.func_77973_b().isBookEnchantable(toolStack, bookStack)) {
            return;
        }
        Map oldEnchantments = EnchantmentHelper.func_82781_a((ItemStack)toolStack);
        Map bookEnchantments = EnchantmentHelper.func_82781_a((ItemStack)bookStack);
        Iterator iterBookEnchantments = bookEnchantments.entrySet().iterator();
        int cost = oldEnchantments.size() * 2;
        boolean levelIncreased = false;
        while (iterBookEnchantments.hasNext()) {
            Map.Entry enchantmentEntry = iterBookEnchantments.next();
            Enchantment enchBook = (Enchantment)enchantmentEntry.getKey();
            if (enchBook == null) continue;
            int oldEnchLvl = oldEnchantments.containsKey(enchBook) ? (Integer)oldEnchantments.get(enchBook) : 0;
            int bookEnchLvl = (Integer)enchantmentEntry.getValue();
            int newLvl = bookEnchLvl == oldEnchLvl ? oldEnchLvl + 1 : Math.max(oldEnchLvl, bookEnchLvl);
            newLvl = Math.min(newLvl, enchBook.func_77325_b());
            if (!repairable.canApplyEnchantment(toolStack, enchBook)) {
                event.setCanceled(true);
                return;
            }
            if (newLvl > oldEnchLvl) {
                levelIncreased = true;
            }
            Iterator iterOldEnchantments = oldEnchantments.entrySet().iterator();
            while (iterOldEnchantments.hasNext()) {
                Enchantment enchOld = (Enchantment)iterOldEnchantments.next().getKey();
                if (enchOld.equals(enchBook) || enchOld.func_191560_c(enchBook)) continue;
                event.setCanceled(true);
                return;
            }
            oldEnchantments.put(enchBook, newLvl);
            cost += newLvl * 2;
        }
        if (!levelIncreased) {
            event.setCanceled(true);
            return;
        }
        EnchantmentHelper.func_82782_a((Map)oldEnchantments, (ItemStack)toolStack);
        event.setOutput(toolStack);
        event.setCost(cost);
        this.updateItemName(event, toolStack);
        event.setCost(Math.min(event.getCost(), 39));
    }

    private void updateItemName(AnvilUpdateEvent event, ItemStack outputStack) {
        String name = event.getName();
        if (!StringUtils.isBlank((CharSequence)name)) {
            outputStack.func_151001_c(name);
            event.setCost(event.getCost() + 1);
        } else if (outputStack.func_82837_s()) {
            outputStack.func_135074_t();
            event.setCost(event.getCost() + 1);
        }
    }
}

