/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import fi.dy.masa.enderutilities.item.ItemEnderBucket;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class ModelEnderBucket
implements IModel {
    public static final IModel MODEL = new ModelEnderBucket();
    private final ResourceLocation resourceMain;
    private final ResourceLocation resourceInsideTop;
    private final ResourceLocation resourceInsideBottom;
    private final ResourceLocation resourceModeIcon;
    private final Fluid fluid;
    private final boolean flipGas;
    private final int amount;
    private final int capacity;

    public ModelEnderBucket() {
        this(null, null, null, null, null, 0, 0, false);
    }

    public ModelEnderBucket(ResourceLocation main, ResourceLocation insideTop, ResourceLocation insideBottom, ResourceLocation mode, Fluid fluid, int amount, int capacity, boolean flipGas) {
        this.resourceMain = main;
        this.resourceInsideTop = insideTop;
        this.resourceInsideBottom = insideBottom;
        this.resourceModeIcon = mode;
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.amount = amount;
        this.capacity = capacity;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_normal_main"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_normal_insidetop"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_normal_insidebottom"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_linked_main"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_linked_insidetop"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_linked_insidebottom"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_mode_drain"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_mode_fill"));
        builder.add((Object)ReferenceTextures.getItemTexture("enderbucket_32_mode_bind"));
        return builder.build();
    }

    public IModel process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = fluidName != null ? FluidRegistry.getFluid((String)fluidName) : null;
        boolean flip = this.flipGas;
        String tmp = (String)customData.get((Object)"linked");
        boolean isLinked = tmp != null && tmp.equals("true");
        int amount = 0;
        int capacity = 1000;
        String mode = null;
        if (customData.containsKey((Object)"mode") && (tmp = (String)customData.get((Object)"mode")) != null && (tmp.equals("drain") || tmp.equals("fill") || tmp.equals("bind"))) {
            mode = tmp;
        }
        if (customData.containsKey((Object)"amount")) {
            try {
                amount = Integer.valueOf((String)customData.get((Object)"amount"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (customData.containsKey((Object)"capacity")) {
            try {
                capacity = Integer.valueOf((String)customData.get((Object)"capacity"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String rlBase = "enderutilities:items/enderbucket_32_";
        ResourceLocation main = new ResourceLocation(rlBase + (isLinked ? "linked_" : "normal_") + "main");
        ResourceLocation inTop = new ResourceLocation(rlBase + (isLinked ? "linked_" : "normal_") + "insidetop");
        ResourceLocation inBot = new ResourceLocation(rlBase + (isLinked ? "linked_" : "normal_") + "insidebottom");
        ResourceLocation rlMode = mode != null ? new ResourceLocation(rlBase + "mode_" + mode) : null;
        return new ModelEnderBucket(main, inTop, inBot, rlMode, fluid, amount, capacity, flip);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel model;
        IModelState stateTmp;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        TextureAtlasSprite mainSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.resourceMain != null) {
            mainSprite = bakedTextureGetter.apply(this.resourceMain);
            IBakedModel model2 = new ItemLayerModel(ImmutableList.of((Object)this.resourceMain)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model2.func_188616_a(null, null, 0L));
        }
        if (this.resourceInsideTop != null) {
            stateTmp = this.getTransformedModelState(state, 0.0f, 0.95f);
            model = new ItemLayerModel(ImmutableList.of((Object)this.resourceInsideTop)).bake(stateTmp, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.resourceInsideBottom != null) {
            stateTmp = this.getTransformedModelState(state, 0.0f, 0.95f);
            model = new ItemLayerModel(ImmutableList.of((Object)this.resourceInsideBottom)).bake(stateTmp, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.resourceModeIcon != null) {
            stateTmp = this.getTransformedModelState(state, 0.0125f, 1.0f);
            model = new ItemLayerModel(ImmutableList.of((Object)this.resourceModeIcon)).bake(stateTmp, format, bakedTextureGetter);
            builder.addAll((Iterable)model.func_188616_a(null, null, 0L));
        }
        if (this.fluid != null) {
            TextureAtlasSprite fluidTex = bakedTextureGetter.apply(this.fluid.getStill());
            int color = this.fluid.getColor();
            int tint = -1;
            float capacity = this.capacity > 0 ? (float)this.capacity : 1000.0f;
            float height = (float)this.amount / capacity;
            float yt = 7.0f - height * 4.0f;
            float yb = 13.0f - height * 4.0f;
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)4.0f, (float)yt, (float)12.0f, (float)7.0f, (float)0.469f, (TextureAtlasSprite)fluidTex, (EnumFacing)EnumFacing.NORTH, (int)color, (int)-1));
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)6.5f, (float)yb, (float)10.0f, (float)13.0f, (float)0.469f, (TextureAtlasSprite)fluidTex, (EnumFacing)EnumFacing.NORTH, (int)color, (int)-1));
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)4.0f, (float)yt, (float)12.0f, (float)7.0f, (float)0.531f, (TextureAtlasSprite)fluidTex, (EnumFacing)EnumFacing.SOUTH, (int)color, (int)-1));
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)6.5f, (float)yb, (float)10.0f, (float)13.0f, (float)0.531f, (TextureAtlasSprite)fluidTex, (EnumFacing)EnumFacing.SOUTH, (int)color, (int)-1));
        }
        return new BakedEnderBucket(this, (ImmutableList<BakedQuad>)builder.build(), mainSprite, format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)Maps.immutableEnumMap((Map)transformMap), Maps.newHashMap());
    }

    private IModelState getTransformedModelState(IModelState state, float offZ, float scaleZ) {
        TRSRTransformation tr = new TRSRTransformation(new Vector3f(0.0f, 0.0f, offZ), null, new Vector3f(1.0f, 1.0f, scaleZ), null);
        return new ModelStateComposition(state, (IModelState)TRSRTransformation.blockCenterToCorner((TRSRTransformation)tr));
    }

    public static enum LoaderEnderBucket implements ICustomModelLoader
    {
        instance;


        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("enderutilities") && modelLocation.func_110623_a().contains("generated_model_enderbucket");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws IOException {
            return MODEL;
        }

        public void func_110549_a(IResourceManager resourceManager) {
        }
    }

    protected static class BakedEnderBucket
    implements IBakedModel {
        private final ModelEnderBucket parent;
        private final Map<String, IBakedModel> cache;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;

        public BakedEnderBucket(ModelEnderBucket parent, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, Map<String, IBakedModel> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public ItemOverrideList func_188617_f() {
            return BakedEnderBucketOverrideHandler.INSTANCE;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }
    }

    private static final class BakedEnderBucketOverrideHandler
    extends ItemOverrideList {
        public static final BakedEnderBucketOverrideHandler INSTANCE = new BakedEnderBucketOverrideHandler();

        private BakedEnderBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModelIn, ItemStack stack, World world, EntityLivingBase entity) {
            if (!(stack.func_77973_b() instanceof ItemEnderBucket)) {
                return originalModelIn;
            }
            BakedEnderBucket originalModel = (BakedEnderBucket)originalModelIn;
            ItemEnderBucket item = (ItemEnderBucket)stack.func_77973_b();
            String linked = ItemEnderBucket.LinkMode.fromStack(stack) == ItemEnderBucket.LinkMode.ENABLED ? "true" : "false";
            int capacity = item.getCapacityCached(stack, null);
            ItemEnderBucket.BucketMode mode = ItemEnderBucket.BucketMode.fromStack(stack);
            String modeStr = "none";
            int amount = 0;
            FluidStack fluidStack = item.getFluidCached(stack);
            Fluid fluid = null;
            if (fluidStack != null) {
                amount = fluidStack.amount;
                fluid = fluidStack.getFluid();
            }
            if (mode == ItemEnderBucket.BucketMode.DRAIN) {
                modeStr = "drain";
            } else if (mode == ItemEnderBucket.BucketMode.FILL) {
                modeStr = "fill";
            } else if (mode == ItemEnderBucket.BucketMode.BIND) {
                modeStr = "bind";
            }
            String key = linked + "_" + modeStr + "_" + fluid + "_" + amount + "_" + capacity;
            if (!originalModel.cache.containsKey(key)) {
                ImmutableMap.Builder map = ImmutableMap.builder();
                if (fluid != null) {
                    map.put((Object)"fluid", (Object)fluid.getName());
                }
                map.put((Object)"linked", (Object)linked);
                map.put((Object)"mode", (Object)modeStr);
                map.put((Object)"amount", (Object)String.valueOf(amount));
                map.put((Object)"capacity", (Object)String.valueOf(capacity));
                IModel parent = originalModel.parent.process((ImmutableMap<String, String>)map.build());
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    @Override
                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                IBakedModel bakedModel = parent.bake((IModelState)new SimpleModelState(originalModel.transforms), originalModel.format, (Function)textureGetter);
                originalModel.cache.put(key, bakedModel);
                return bakedModel;
            }
            return (IBakedModel)originalModel.cache.get(key);
        }
    }
}

