/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityBeaconRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import requious.data.AssemblyProcessor;
import requious.tile.TileEntityAssembly;
import requious.util.MachineVisual;
import requious.util.Parameter;

public class MachineVisualBeacon
extends MachineVisual {
    Parameter variableFacing;
    Parameter variableLength;
    boolean cancelOnHit;
    boolean global;

    public MachineVisualBeacon(Parameter variableActive, Parameter variableFacing, Parameter variableLength, boolean cancelOnHit, boolean global) {
        super(variableActive);
        this.variableFacing = variableFacing;
        this.variableLength = variableLength;
        this.cancelOnHit = cancelOnHit;
        this.global = global;
    }

    @Override
    public void render(TileEntityAssembly tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.render(tile, x, y, z, partialTicks, destroyStage, alpha);
        if (!this.isActive(tile.getProcessor())) {
            return;
        }
        this.renderBeacon(tile, x, y, z, partialTicks);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideOnly(value=Side.CLIENT)
    private List<BeamSegment> getSegments(World world, BlockPos pos, EnumFacing facing, int length) {
        ArrayList<BeamSegment> segments = new ArrayList<BeamSegment>();
        BeamSegment segment = new BeamSegment(EnumDyeColor.WHITE.func_193349_f());
        segments.add(segment);
        boolean flag = true;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int i1 = 1;
        while (i1 < length) {
            block9: {
                float[] color;
                block6: {
                    IBlockState state;
                    block7: {
                        block8: {
                            block5: {
                                state = world.func_180495_p(pos.func_177967_a(facing, i1));
                                if (state.func_177230_c() != Blocks.field_150399_cn) break block5;
                                color = ((EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).func_193349_f();
                                break block6;
                            }
                            if (state.func_177230_c() == Blocks.field_150397_co) break block7;
                            if (state.getLightOpacity((IBlockAccess)world, (BlockPos)checkPos) >= 15 && state.func_177230_c() != Blocks.field_150357_h) {
                                if (!this.cancelOnHit) return segments;
                                segments.clear();
                                return segments;
                            }
                            float[] customColor = state.func_177230_c().getBeaconColorMultiplier(state, world, (BlockPos)checkPos, pos);
                            if (customColor == null) break block8;
                            color = customColor;
                            break block6;
                        }
                        segment.incrementHeight();
                        break block9;
                    }
                    color = ((EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a)).func_193349_f();
                }
                float[] segmentColor = segment.getColors();
                if (!flag) {
                    color = new float[]{(segmentColor[0] + color[0]) / 2.0f, (segmentColor[1] + color[1]) / 2.0f, (segmentColor[2] + color[2]) / 2.0f};
                }
                if (Arrays.equals(color, segmentColor)) {
                    segment.incrementHeight();
                } else {
                    segment = new BeamSegment(color);
                    segments.add(segment);
                }
                flag = false;
            }
            ++i1;
        }
        return segments;
    }

    public void renderBeacon(TileEntityAssembly tile, double x, double y, double z, float partialTicks) {
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        TextureManager manager = Minecraft.func_71410_x().field_71446_o;
        manager.func_110577_a(TileEntityBeaconRenderer.field_147523_b);
        AssemblyProcessor assembly = tile.getProcessor();
        EnumFacing facing = this.variableFacing.getFacing(assembly);
        double textureScale = 1.0;
        long totalWorldTime = tile.func_145831_w().func_82737_E();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        switch (facing) {
            case DOWN: {
                GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case UP: {
                break;
            }
            case NORTH: {
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
        }
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        if (textureScale > 0.0) {
            GlStateManager.func_179106_n();
            int i = 0;
            List<BeamSegment> segments = this.getSegments(tile.func_145831_w(), tile.func_174877_v(), facing, this.variableLength.getInteger(assembly, partialTicks));
            for (int j = 0; j < segments.size(); ++j) {
                BeamSegment segment = segments.get(j);
                TileEntityBeaconRenderer.func_188204_a((double)0.0, (double)0.0, (double)0.0, (double)partialTicks, (double)textureScale, (double)totalWorldTime, (int)i, (int)segment.getHeight(), (float[])segment.getColors());
                i += segment.getHeight();
            }
            GlStateManager.func_179127_m();
        }
        GlStateManager.func_179121_F();
    }

    public static class BeamSegment {
        private final float[] colors;
        private int height;

        public BeamSegment(float[] colorsIn) {
            this.colors = colorsIn;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        public float[] getColors() {
            return this.colors;
        }

        @SideOnly(value=Side.CLIENT)
        public int getHeight() {
            return this.height;
        }
    }
}

