/*
 * Decompiled with CFR 0.152.
 */
package requious.util;

import java.util.HashSet;
import net.minecraft.util.EnumFacing;
import requious.util.Facing;

public enum ComponentFace {
    None(new Facing[0]),
    Front(new Facing[]{Facing.UP_LOCAL}),
    Back(new Facing[]{Facing.DOWN_LOCAL}),
    Side(new Facing[]{Facing.NORTH_LOCAL, Facing.SOUTH_LOCAL, Facing.EAST_LOCAL, Facing.WEST_LOCAL}),
    FrontBack(new Facing[]{Facing.UP_LOCAL, Facing.DOWN_LOCAL}),
    FrontSide(new Facing[]{Facing.UP_LOCAL, Facing.NORTH_LOCAL, Facing.SOUTH_LOCAL, Facing.EAST_LOCAL, Facing.WEST_LOCAL}),
    BackSide(new Facing[]{Facing.DOWN_LOCAL, Facing.NORTH_LOCAL, Facing.SOUTH_LOCAL, Facing.EAST_LOCAL, Facing.WEST_LOCAL}),
    All(new Facing[]{Facing.UP_LOCAL, Facing.DOWN_LOCAL, Facing.NORTH_LOCAL, Facing.SOUTH_LOCAL, Facing.EAST_LOCAL, Facing.WEST_LOCAL}),
    Up(new Facing[]{Facing.UP_GLOBAL}),
    Down(new Facing[]{Facing.DOWN_GLOBAL}),
    North(new Facing[]{Facing.NORTH_GLOBAL}),
    South(new Facing[]{Facing.SOUTH_GLOBAL}),
    East(new Facing[]{Facing.EAST_GLOBAL}),
    West(new Facing[]{Facing.WEST_GLOBAL}),
    Horizontal(new Facing[]{Facing.NORTH_GLOBAL, Facing.SOUTH_GLOBAL, Facing.EAST_GLOBAL, Facing.WEST_GLOBAL}),
    Vertical(new Facing[]{Facing.UP_LOCAL, Facing.DOWN_GLOBAL});

    Facing[] sides;
    HashSet<EnumFacing> localFacings = new HashSet();
    HashSet<EnumFacing> globalFacings = new HashSet();

    private ComponentFace(Facing[] sides) {
        this.sides = sides;
        for (Facing side : sides) {
            if (side.isGlobal()) {
                this.globalFacings.add(side.getFacing());
                continue;
            }
            this.localFacings.add(side.getFacing());
        }
    }

    public Facing[] getSides() {
        return this.sides;
    }

    public boolean matches(EnumFacing sideLocal, EnumFacing sideGlobal) {
        if (this.localFacings.contains(sideLocal)) {
            return true;
        }
        return this.globalFacings.contains(sideGlobal);
    }

    public Facing getSide(int i) {
        return this.sides[i % this.sides.length];
    }
}

