/*
 * Decompiled with CFR 0.152.
 */
package requious.tile;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import requious.block.BlockRedEmitter;
import requious.data.RedEmitterData;
import requious.entity.EntitySpark;
import requious.entity.ISparkValue;
import requious.entity.spark.TargetTile;
import requious.entity.spark.ValueForgeEnergy;
import requious.tile.ISparkAcceptor;
import requious.tile.TileEntityEmitter;

public class TileEntityRedEmitter
extends TileEntityEmitter {
    int energy;
    IEnergyStorage capability = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int received = Math.min(TileEntityRedEmitter.this.getCapacity() - TileEntityRedEmitter.this.energy, maxReceive);
            if (!simulate) {
                TileEntityRedEmitter.this.energy += received;
                TileEntityRedEmitter.this.func_70296_d();
            }
            return received;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int extracted = Math.min(TileEntityRedEmitter.this.energy, maxExtract);
            if (!simulate) {
                TileEntityRedEmitter.this.energy -= extracted;
                TileEntityRedEmitter.this.func_70296_d();
            }
            return extracted;
        }

        public int getEnergyStored() {
            return TileEntityRedEmitter.this.energy;
        }

        public int getMaxEnergyStored() {
            return TileEntityRedEmitter.this.getCapacity();
        }

        public boolean canExtract() {
            return TileEntityRedEmitter.this.isReceiver();
        }

        public boolean canReceive() {
            return TileEntityRedEmitter.this.isEmitter();
        }
    };

    public RedEmitterData getData() {
        BlockRedEmitter emitter = (BlockRedEmitter)this.func_145838_q();
        return (RedEmitterData)emitter.getData();
    }

    public int getCapacity() {
        return this.getData().capacity;
    }

    @Override
    public void setTarget(World world, BlockPos pos, EnumFacing facing) {
        if (world != this.field_145850_b) {
            return;
        }
        if (pos.equals((Object)this.field_174879_c)) {
            return;
        }
        this.target = pos;
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.getFacing().func_176734_d() == facing;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.getFacing().func_176734_d() == facing) {
            return (T)capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    void ioEnergy(EnumFacing dir, TileEntity attachedTile) {
        if (attachedTile.hasCapability(CapabilityEnergy.ENERGY, dir)) {
            IEnergyStorage storage = (IEnergyStorage)attachedTile.getCapability(CapabilityEnergy.ENERGY, dir);
            if (this.isEmitter() && storage.canExtract()) {
                int extracted = storage.extractEnergy(this.getCapacity() - this.energy, true);
                extracted = this.capability.receiveEnergy(extracted, false);
                storage.extractEnergy(extracted, false);
                this.func_70296_d();
            }
            if (this.isReceiver() && storage.canReceive()) {
                int inserted = storage.receiveEnergy(this.energy, true);
                inserted = this.capability.extractEnergy(inserted, false);
                storage.receiveEnergy(inserted, false);
                this.func_70296_d();
            }
        }
    }

    @Override
    void sendPacket() {
        if (this.energy >= this.getCapacity()) {
            TileEntity targetTile = this.getTargetTile();
            ValueForgeEnergy value = new ValueForgeEnergy(this.energy);
            if (targetTile instanceof ISparkAcceptor && ((ISparkAcceptor)targetTile).canAccept(value)) {
                EntitySpark spark = new EntitySpark(this.field_145850_b);
                Vec3d velocity = this.getBurstVelocity(this.getFacing()).func_72441_c((this.random.nextDouble() - 0.5) * 0.3, (this.random.nextDouble() - 0.5) * 0.3, (this.random.nextDouble() - 0.5) * 0.3);
                spark.init((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c, new TargetTile(targetTile), value);
                spark.pushHistory((Comparable)this.field_174879_c);
                this.field_145850_b.func_72838_d((Entity)spark);
                this.energy = 0;
                this.func_70296_d();
            }
        }
    }

    @Override
    void receivePacket(EntitySpark spark) {
        ISparkValue value = spark.value;
        if (value instanceof ValueForgeEnergy) {
            this.capability.receiveEnergy(((ValueForgeEnergy)value).getEnergy(), false);
        }
    }

    @Override
    public boolean canAccept(ISparkValue value) {
        if (value instanceof ValueForgeEnergy) {
            return ((ValueForgeEnergy)value).getEnergy() <= this.getCapacity() - this.energy;
        }
        return false;
    }

    @Override
    int getInterval() {
        return this.getData().interval;
    }
}

