/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentItem;
import requious.util.ComponentFace;
import requious.util.IngredientAny;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.MechanicalSlot")
public class ComponentMechanical
extends ComponentBase {
    boolean attachGear;
    Ingredient gearFilter = new IngredientAny();

    public ComponentMechanical(ComponentFace face) {
        super(face);
    }

    @ZenMethod
    public ComponentMechanical setAttachGear(IIngredient filter) {
        this.attachGear = true;
        this.gearFilter = CraftTweakerMC.getIngredient((IIngredient)filter);
        return this;
    }

    @Override
    public Slot createSlot() {
        return new Slot(this);
    }

    public static class Collector
    extends ComponentBase.Collector {
        ComponentFace face;
        List<Slot> slots = new ArrayList<Slot>();

        public Collector(ComponentFace face) {
            this.face = face;
        }

        public ComponentFace getFace() {
            return this.face;
        }

        private void addSlot(Slot slot) {
            this.slots.add(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot.getFace() == this.face && slot instanceof Slot) {
                this.addSlot((Slot)slot);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCapability() {
            return true;
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            return super.hasCapability(capability, localSide, globalSide);
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            return super.getCapability(capability, localSide, globalSide);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ComponentItem.Collector) {
                return this.face.equals((Object)((ComponentItem.Collector)obj).face);
            }
            return false;
        }
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentMechanical> {
        public Slot(ComponentMechanical component) {
            super(component);
        }

        public boolean canAttachGear() {
            return false;
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
            Collector mechanical = new Collector(this.getFace());
            if (!collectors.contains(mechanical)) {
                collectors.add(mechanical);
            }
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return null;
        }

        @Override
        public void update() {
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
        }

        public NBTTagCompound serializeNBT() {
            return null;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
        }
    }
}

