/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.gui.slot.ItemSlot;
import requious.tile.TileEntityAssembly;
import requious.util.ComponentFace;
import requious.util.IOParameters;
import requious.util.IngredientAny;
import requious.util.ItemComponentHelper;
import requious.util.SlotVisual;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.ItemSlot")
public class ComponentItem
extends ComponentBase {
    public boolean inputAllowed = true;
    public boolean outputAllowed = true;
    public boolean shiftAllowed = true;
    public boolean putAllowed = true;
    public boolean takeAllowed = true;
    public boolean dropsOnBreak = true;
    public boolean canOverfill = false;
    public boolean splitAllowed = false;
    public Ingredient filter = new IngredientAny();
    public IOParameters pushItem = new IOParameters();
    public int capacity;
    public SlotVisual background = SlotVisual.ITEM_SLOT;
    public SlotVisual foreground = SlotVisual.EMPTY;

    public ComponentItem(ComponentFace face, int capacity) {
        super(face);
        this.capacity = capacity;
    }

    @Override
    public ComponentBase.Slot createSlot() {
        return new Slot(this);
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem setAccess(boolean input, boolean output) {
        this.inputAllowed = input;
        this.outputAllowed = output;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem setHandAccess(boolean input, boolean output, @Optional(valueBoolean=true) boolean shift) {
        this.putAllowed = input;
        this.takeAllowed = output;
        this.shiftAllowed = shift;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem setFilter(IIngredient ingredient) {
        this.filter = CraftTweakerMC.getIngredient((IIngredient)ingredient);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem allowOverfill() {
        this.canOverfill = true;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem allowSplit() {
        this.splitAllowed = true;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem noDrop() {
        this.dropsOnBreak = false;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem pushItem(int size, int slot) {
        this.pushItem = new IOParameters(size, slot);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem pushItem(int size) {
        this.pushItem = new IOParameters(size);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem setBackground(SlotVisualCT visual) {
        this.background = SlotVisualCT.unpack(visual);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentItem setForeground(SlotVisualCT visual) {
        this.foreground = SlotVisualCT.unpack(visual);
        return this;
    }

    public static class Collector
    extends ComponentBase.Collector
    implements IItemHandler {
        ComponentFace face;
        List<IItemSlot> slots = new ArrayList<IItemSlot>();
        int pushIndex;

        public Collector(ComponentFace face) {
            this.face = face;
        }

        private void addSlot(IItemSlot slot) {
            this.slots.add(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot.getFace() == this.face && slot instanceof IItemSlot) {
                this.addSlot((IItemSlot)((Object)slot));
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCapability() {
            return true;
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.face.matches(localSide, globalSide)) {
                return true;
            }
            return super.hasCapability(capability, localSide, globalSide);
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.face.matches(localSide, globalSide)) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this);
            }
            return super.getCapability(capability, localSide, globalSide);
        }

        private boolean canAutoOutput() {
            for (IItemSlot slot : this.slots) {
                if (!slot.getPushItem().active) continue;
                return true;
            }
            return false;
        }

        @Override
        public void update() {
            if (this.canAutoOutput() && this.tile instanceof TileEntityAssembly) {
                EnumFacing facing;
                BlockPos pos;
                World world = this.tile.func_145831_w();
                TileEntity checkTile = world.func_175625_s((pos = this.tile.func_174877_v()).func_177972_a(facing = TileEntityAssembly.toSide(((TileEntityAssembly)this.tile).getFacing(), this.face.getSide(this.pushIndex))));
                if (checkTile != null && checkTile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    IItemHandler inventory = (IItemHandler)checkTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    for (IItemSlot slot : this.slots) {
                        if (!slot.getPushItem().active) continue;
                        int maxSize = slot.getPushItem().size;
                        int targetSlot = slot.getPushItem().slot;
                        ItemStack insertStack = slot.getItem().extract(maxSize, true);
                        int startSize = insertStack.func_190916_E();
                        if (targetSlot < 0) {
                            for (int i = 0; i < inventory.getSlots() && !(insertStack = inventory.insertItem(i, insertStack, false)).func_190926_b(); ++i) {
                            }
                        } else {
                            insertStack = inventory.insertItem(targetSlot, insertStack, false);
                        }
                        if (insertStack.func_190916_E() >= startSize) continue;
                        slot.getItem().extract(startSize - insertStack.func_190916_E(), false);
                    }
                }
                ++this.pushIndex;
            }
        }

        public int getSlots() {
            return this.slots.size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int i) {
            IItemSlot slot = this.slots.get(i);
            return slot.getItem().getStack();
        }

        private boolean hasItemStored(ItemStack stack) {
            for (IItemSlot slot : this.slots) {
                if (slot.getItem().isEmpty() || !slot.getItem().canStack(stack)) continue;
                return true;
            }
            return false;
        }

        @Nonnull
        public ItemStack insertItem(int i, @Nonnull ItemStack stack, boolean simulate) {
            IItemSlot slot = this.slots.get(i);
            if (slot.canInputItem() && slot.acceptsItem(stack) && (slot.canSplit() || !slot.getItem().isEmpty() && slot.getItem().canStack(stack) || !this.hasItemStored(stack))) {
                return slot.getItem().insert(stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int i, int amount, boolean simulate) {
            IItemSlot slot = this.slots.get(i);
            if (slot.canOutputItem()) {
                return slot.getItem().extract(amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int i) {
            IItemSlot slot = this.slots.get(i);
            return slot.getItem().getCapacity();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Collector) {
                return this.face.equals((Object)((Collector)obj).face);
            }
            return false;
        }
    }

    public static interface IItemSlot {
        public ItemComponentHelper getItem();

        public boolean canInputItem();

        public boolean canOutputItem();

        public IOParameters getPushItem();

        public boolean canSplit();

        public boolean acceptsItem(ItemStack var1);
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentItem>
    implements IItemSlot {
        ItemComponentHelper item;

        public Slot(final ComponentItem component) {
            super(component);
            this.item = new ItemComponentHelper(){

                @Override
                public int getCapacity() {
                    if (this.canOverfill() && this.getAmount() == 0) {
                        return Integer.MAX_VALUE;
                    }
                    return component.capacity;
                }
            };
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
            Collector item = new Collector(this.getFace());
            if (!collectors.contains(item)) {
                collectors.add(item);
            }
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return new ItemSlot(assembly, this, x, y);
        }

        @Override
        public void update() {
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
            if (((ComponentItem)this.component).dropsOnBreak) {
                this.item.spawnInWorld(world, position);
                this.item.setStack(ItemStack.field_190927_a);
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("item", (NBTBase)this.item.writeToNBT(new NBTTagCompound()));
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.item.readFromNBT(compound.func_74775_l("item"));
        }

        @Override
        public ItemComponentHelper getItem() {
            return this.item;
        }

        @Override
        public boolean acceptsItem(ItemStack stack) {
            return ((ComponentItem)this.component).filter.apply(stack);
        }

        @Override
        public boolean canInputItem() {
            return ((ComponentItem)this.component).inputAllowed;
        }

        @Override
        public boolean canOutputItem() {
            return ((ComponentItem)this.component).outputAllowed;
        }

        public boolean canPut() {
            return !((ComponentItem)this.component).hidden && ((ComponentItem)this.component).putAllowed;
        }

        public boolean canTake() {
            return !((ComponentItem)this.component).hidden && ((ComponentItem)this.component).takeAllowed;
        }

        public boolean canOverfill() {
            return ((ComponentItem)this.component).canOverfill;
        }

        @Override
        public IOParameters getPushItem() {
            return ((ComponentItem)this.component).pushItem;
        }

        @Override
        public boolean canSplit() {
            return ((ComponentItem)this.component).splitAllowed;
        }

        @Override
        public boolean canShift() {
            return ((ComponentItem)this.component).shiftAllowed;
        }

        @Override
        public boolean isDirty() {
            return super.isDirty() || this.item.isDirty();
        }

        @Override
        public void markClean() {
            super.markClean();
            this.item.markClean();
        }

        public SlotVisual getBackground() {
            return ((ComponentItem)this.component).background;
        }

        public SlotVisual getForeground() {
            return ((ComponentItem)this.component).foreground;
        }
    }
}

