/*
 * Decompiled with CFR 0.152.
 */
package requious.data.component;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import requious.compat.crafttweaker.IFluidCondition;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.data.component.ComponentItem;
import requious.gui.slot.FluidSlot;
import requious.tile.TileEntityAssembly;
import requious.util.ComponentFace;
import requious.util.IOParameters;
import requious.util.ItemComponentHelper;
import requious.util.SlotVisual;
import stanhebben.zenscript.annotations.ReturnsSelf;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.FluidSlot")
public class ComponentFluid
extends ComponentBase {
    public boolean bucketAllowed;
    public boolean inputAllowed = true;
    public boolean outputAllowed = true;
    public boolean splitAllowed = true;
    public boolean putAllowed = true;
    public boolean takeAllowed = true;
    public boolean dropsOnBreak = true;
    public boolean canOverfill = false;
    public IOParameters pushFluid = new IOParameters();
    public IOParameters pushItem = new IOParameters();
    public IFluidCondition filter;
    public int capacity;
    public SlotVisual foreground = SlotVisual.EMPTY;
    public SlotVisual background = SlotVisual.FLUID_SLOT;

    public ComponentFluid(ComponentFace face, int capacity) {
        super(face);
        this.capacity = capacity;
    }

    @Override
    public ComponentBase.Slot createSlot() {
        return new Slot(this);
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid setAccess(boolean input, boolean output) {
        this.inputAllowed = input;
        this.outputAllowed = output;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid setFilter(IFluidCondition condition) {
        this.filter = condition;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid allowBucket(boolean input, boolean output) {
        this.bucketAllowed = true;
        this.putAllowed = input;
        this.takeAllowed = output;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid allowOverfill() {
        this.canOverfill = true;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid allowSplit() {
        this.splitAllowed = true;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid noDrop() {
        this.dropsOnBreak = false;
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid pushItem(int size, int slot) {
        this.pushItem = new IOParameters(size, slot);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid pushItem(int size) {
        this.pushItem = new IOParameters(size);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid pushFluid(int size) {
        this.pushFluid = new IOParameters(size);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid setForeground(SlotVisualCT visual) {
        this.foreground = SlotVisualCT.unpack(visual);
        return this;
    }

    @ReturnsSelf
    @ZenMethod
    public ComponentFluid setBackground(SlotVisualCT visual) {
        this.background = SlotVisualCT.unpack(visual);
        return this;
    }

    public static class Collector
    extends ComponentBase.Collector
    implements IFluidHandler {
        ComponentFace face;
        List<Slot> slots = new ArrayList<Slot>();
        int pushIndex;

        public Collector(ComponentFace face) {
            this.face = face;
        }

        private void addSlot(Slot slot) {
            this.slots.add(slot);
        }

        @Override
        public boolean accept(ComponentBase.Slot slot) {
            if (slot.getFace() == this.face && slot instanceof Slot) {
                this.addSlot((Slot)slot);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCapability() {
            return true;
        }

        @Override
        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.face.matches(localSide, globalSide)) {
                return true;
            }
            return super.hasCapability(capability, localSide, globalSide);
        }

        @Override
        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing localSide, @Nullable EnumFacing globalSide) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.face.matches(localSide, globalSide)) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
            }
            return super.getCapability(capability, localSide, globalSide);
        }

        private boolean canAutoOutput() {
            for (Slot slot : this.slots) {
                if (!slot.getPushFluid().active) continue;
                return true;
            }
            return false;
        }

        @Override
        public void update() {
            if (this.canAutoOutput() && this.tile instanceof TileEntityAssembly) {
                EnumFacing facing;
                BlockPos pos;
                World world = this.tile.func_145831_w();
                TileEntity checkTile = world.func_175625_s((pos = this.tile.func_174877_v()).func_177972_a(facing = TileEntityAssembly.toSide(((TileEntityAssembly)this.tile).getFacing(), this.face.getSide(this.pushIndex))));
                if (checkTile != null && checkTile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    IFluidHandler tank = (IFluidHandler)checkTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                    for (Slot slot : this.slots) {
                        int maxSize;
                        FluidStack fluid;
                        int filled;
                        if (!slot.getPushItem().active || (filled = tank.fill(fluid = slot.drain(maxSize = slot.getPushFluid().size, true), true)) <= 0) continue;
                        slot.drain(filled, false);
                    }
                }
                ++this.pushIndex;
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Collector) {
                return this.face.equals((Object)((Collector)obj).face);
            }
            return false;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.slots.toArray(new IFluidTankProperties[this.slots.size()]);
        }

        private boolean hasFluidStored(FluidStack stack) {
            for (Slot slot : this.slots) {
                if (slot.fluid == null || !slot.fluid.isFluidEqual(stack)) continue;
                return true;
            }
            return false;
        }

        public int fill(FluidStack resource, boolean doFill) {
            boolean hasFluidStored = this.hasFluidStored(resource);
            for (Slot slot : this.slots) {
                int filled;
                if (!slot.canInput() || !slot.acceptsFluid(resource) || !slot.canSplit() && hasFluidStored && (slot.fluid == null || !slot.fluid.isFluidEqual(resource)) || (filled = slot.fill(resource, !doFill)) <= 0) continue;
                return filled;
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            for (Slot slot : this.slots) {
                FluidStack extracted;
                if (!slot.canOutput() || (extracted = slot.drain(resource, !doDrain)) == null) continue;
                return extracted;
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            for (Slot slot : this.slots) {
                FluidStack extracted;
                if (!slot.canOutput() || (extracted = slot.drain(maxDrain, !doDrain)) == null) continue;
                return extracted;
            }
            return null;
        }
    }

    public static class Slot
    extends ComponentBase.Slot<ComponentFluid>
    implements IFluidTankProperties {
        FluidStack fluid;
        ItemComponentHelper bucket = new ItemComponentHelper(){

            @Override
            public int getCapacity() {
                return 1;
            }
        };

        public Slot(ComponentFluid component) {
            super(component);
        }

        @Override
        public void addCollectors(List<ComponentBase.Collector> collectors) {
            Collector fluid = new Collector(this.getFace());
            ComponentItem.Collector item = new ComponentItem.Collector(this.getFace());
            if (!collectors.contains(fluid)) {
                collectors.add(fluid);
            }
            if (this.isBucketAccepted() && !collectors.contains(item)) {
                collectors.add(item);
            }
        }

        @Override
        public net.minecraft.inventory.Slot createGui(AssemblyProcessor assembly, int x, int y) {
            return new FluidSlot(assembly, this, x, y);
        }

        @Override
        public void update() {
        }

        @Override
        public void machineBroken(World world, Vec3d position) {
            if (((ComponentFluid)this.component).dropsOnBreak) {
                this.bucket.spawnInWorld(world, position);
                this.bucket.setStack(ItemStack.field_190927_a);
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            if (this.fluid != null) {
                compound.func_74782_a("fluid", (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
            } else {
                compound.func_74778_a("fluid", "empty");
            }
            return compound;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid"));
        }

        public boolean canInput() {
            return ((ComponentFluid)this.component).inputAllowed;
        }

        public boolean canOutput() {
            return ((ComponentFluid)this.component).outputAllowed;
        }

        public IOParameters getPushFluid() {
            return ((ComponentFluid)this.component).pushFluid;
        }

        public IOParameters getPushItem() {
            return ((ComponentFluid)this.component).pushItem;
        }

        public boolean canSplit() {
            return ((ComponentFluid)this.component).splitAllowed;
        }

        public boolean canPut() {
            return !((ComponentFluid)this.component).hidden && ((ComponentFluid)this.component).bucketAllowed && ((ComponentFluid)this.component).putAllowed;
        }

        public boolean canTake() {
            return !((ComponentFluid)this.component).hidden && ((ComponentFluid)this.component).bucketAllowed && ((ComponentFluid)this.component).takeAllowed;
        }

        public boolean canOverfill() {
            return ((ComponentFluid)this.component).canOverfill;
        }

        public boolean isBucketAccepted() {
            return ((ComponentFluid)this.component).bucketAllowed;
        }

        @Nullable
        public FluidStack getContents() {
            return this.fluid;
        }

        public void setContents(FluidStack fluid) {
            this.fluid = fluid;
        }

        public int getAmount() {
            if (this.fluid == null) {
                return 0;
            }
            return this.fluid.amount;
        }

        public int getCapacity() {
            if (this.canOverfill() && this.getAmount() <= 0) {
                return Integer.MAX_VALUE;
            }
            return ((ComponentFluid)this.component).capacity;
        }

        public boolean canFill() {
            return this.canInput();
        }

        public boolean canDrain() {
            return this.canOutput();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return this.canInput();
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return this.canOutput();
        }

        public boolean acceptsFluid(FluidStack resource) {
            return ((ComponentFluid)this.component).filter == null || ((ComponentFluid)this.component).filter.matches(CraftTweakerMC.getILiquidStack((FluidStack)resource));
        }

        public int fill(FluidStack resource, boolean simulate) {
            if (resource == null || this.fluid != null && !this.fluid.isFluidEqual(resource)) {
                return 0;
            }
            int amount = this.getAmount();
            int toInsert = Math.min(resource.amount, this.getCapacity() - amount);
            if (!simulate) {
                if (this.fluid == null) {
                    this.fluid = resource.copy();
                }
                this.fluid.amount = amount + toInsert;
                this.markDirty();
            }
            return toInsert;
        }

        public FluidStack drain(FluidStack resource, boolean simulate) {
            if (resource == null || this.fluid != null && !this.fluid.isFluidEqual(resource)) {
                return null;
            }
            return this.drain(resource.amount, simulate);
        }

        public FluidStack drain(int amount, boolean simulate) {
            if (this.fluid == null) {
                return null;
            }
            FluidStack copy = this.fluid.copy();
            copy.amount = Math.min(amount, this.getAmount());
            if (!simulate) {
                this.fluid.amount -= copy.amount;
                if (this.fluid.amount <= 0) {
                    this.fluid = null;
                }
                this.markDirty();
            }
            return copy;
        }

        @Override
        public boolean isDirty() {
            return super.isDirty() || this.bucket.isDirty();
        }

        @Override
        public void markClean() {
            super.markClean();
            this.bucket.markClean();
        }

        public SlotVisual getForeground() {
            return ((ComponentFluid)this.component).foreground;
        }

        public SlotVisual getBackground() {
            return ((ComponentFluid)this.component).background;
        }
    }
}

