/*
 * Decompiled with CFR 0.152.
 */
package requious.compat.jei.slot;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import requious.compat.jei.IngredientCollector;
import requious.compat.jei.JEISlot;
import requious.util.Fill;
import requious.util.Misc;
import requious.util.SlotVisual;

public class ItemSlot
extends JEISlot {
    public List<ItemStack> items = new ArrayList<ItemStack>();
    public SlotVisual visual;

    public ItemSlot(int x, int y, String group, SlotVisual visual) {
        super(x, y, group);
        this.visual = visual;
    }

    @Override
    public boolean isFilled() {
        return !this.items.isEmpty();
    }

    @Override
    public void resetFill() {
        super.resetFill();
        this.items.clear();
    }

    @Override
    public JEISlot copy() {
        ItemSlot itemSlot = new ItemSlot(this.x, this.y, this.group, this.visual);
        return itemSlot;
    }

    @Override
    public void getIngredients(IngredientCollector collector) {
        for (ItemStack item : this.items) {
            if (this.isInput()) {
                collector.addInput(VanillaTypes.ITEM, item);
                continue;
            }
            collector.addOutput(VanillaTypes.ITEM, item);
        }
    }

    @Override
    public void render(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("requious", "textures/gui/assembly_slots.png"));
        Misc.drawTexturedModalRect(this.x * 18, this.y * 18, 0, 0, 18, 18);
        this.visual.render(minecraft, this.x * 18, this.y * 18, 100, new Fill(0.0f, 0.0f));
    }
}

