/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbbackups;

import com.feed_the_beast.mods.ftbbackups.Backup;
import com.feed_the_beast.mods.ftbbackups.BackupEvent;
import com.feed_the_beast.mods.ftbbackups.BackupUtils;
import com.feed_the_beast.mods.ftbbackups.FTBBackups;
import com.feed_the_beast.mods.ftbbackups.FTBBackupsConfig;
import com.feed_the_beast.mods.ftbbackups.net.FTBBackupsNetHandler;
import com.feed_the_beast.mods.ftbbackups.net.MessageBackupProgress;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public enum Backups {
    INSTANCE;

    public final List<Backup> backups = new ArrayList<Backup>();
    public long nextBackup = -1L;
    public int doingBackup = 0;
    public boolean printFiles = false;
    private int currentFile = 0;
    private int totalFiles = 0;
    private String currentFileName = "";
    public boolean hadPlayersOnline = false;

    public void init() {
        JsonElement element;
        File oldFile;
        FTBBackupsConfig.general.clearCachedFolder();
        this.doingBackup = 0;
        this.backups.clear();
        File file = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n(), "local/ftbutilities/backups.json");
        if (!file.exists() && (oldFile = new File(FTBBackupsConfig.general.getFolder(), "backups.json")).exists()) {
            oldFile.renameTo(file);
        }
        if ((element = BackupUtils.readJson(file)) != null && element.isJsonArray()) {
            try {
                for (JsonElement e : element.getAsJsonArray()) {
                    JsonObject json = e.getAsJsonObject();
                    if (!json.has("size")) {
                        json.addProperty("size", (Number)BackupUtils.getSize(new File(FTBBackupsConfig.general.getFolder(), json.get("file").getAsString())));
                    }
                    this.backups.add(new Backup(json));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        FTBBackups.LOGGER.info("Backups folder - " + FTBBackupsConfig.general.getFolder().getAbsolutePath());
        this.nextBackup = System.currentTimeMillis() + FTBBackupsConfig.general.time();
    }

    public void tick(MinecraftServer server, long now) {
        if (!(this.nextBackup <= 0L || this.nextBackup > now || FTBBackupsConfig.general.only_if_players_online && !this.hadPlayersOnline && server.func_184103_al().func_181057_v().isEmpty())) {
            this.hadPlayersOnline = false;
            this.run(server, (ICommandSender)server, "");
        }
        if (this.doingBackup > 1) {
            this.doingBackup = 0;
            if (FTBBackupsConfig.general.disable_level_saving) {
                for (WorldServer world : server.field_71305_c) {
                    if (world == null) continue;
                    world.field_73058_d = false;
                }
            }
            if (!FTBBackupsConfig.general.silent) {
                FTBBackupsNetHandler.NET.sendToAll((IMessage)new MessageBackupProgress(0, 0));
            }
        } else if (this.doingBackup > 0 && this.printFiles) {
            if (this.currentFile == 0 || this.currentFile == this.totalFiles - 1) {
                FTBBackups.LOGGER.info("[" + this.currentFile + " | " + (int)((double)this.currentFile / (double)this.totalFiles * 100.0) + "%]: " + this.currentFileName);
            }
            if (!FTBBackupsConfig.general.silent) {
                FTBBackupsNetHandler.NET.sendToAll((IMessage)new MessageBackupProgress(this.currentFile, this.totalFiles));
            }
        }
    }

    public void notifyAll(MinecraftServer server, Function<ICommandSender, ITextComponent> function, boolean error) {
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            ITextComponent component = function.apply((ICommandSender)player);
            component.func_150256_b().func_150238_a(error ? TextFormatting.DARK_RED : TextFormatting.LIGHT_PURPLE);
            player.func_145747_a(component);
        }
        ITextComponent component = function.apply(null);
        component.func_150256_b().func_150238_a(error ? TextFormatting.DARK_RED : TextFormatting.LIGHT_PURPLE);
        server.func_145747_a(component);
    }

    public boolean run(MinecraftServer server, ICommandSender sender, String customName) {
        boolean auto;
        if (this.doingBackup != 0) {
            return false;
        }
        boolean bl = auto = !(sender instanceof EntityPlayerMP);
        if (auto && !FTBBackupsConfig.general.enabled) {
            return false;
        }
        this.notifyAll(server, player -> FTBBackups.lang(player, "ftbbackups.lang.start", sender.func_70005_c_()), false);
        this.nextBackup = System.currentTimeMillis() + FTBBackupsConfig.general.time();
        if (FTBBackupsConfig.general.disable_level_saving) {
            for (WorldServer world : server.field_71305_c) {
                if (world == null) continue;
                world.field_73058_d = true;
            }
        }
        this.doingBackup = 1;
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try {
                this.doBackup(server, customName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.doingBackup = 2;
            return false;
        });
        return true;
    }

    private void doBackup(MinecraftServer server, String customName) {
        File src = server.func_71218_a(0).func_72860_G().func_75765_b();
        try {
            if (server.func_184103_al() != null) {
                server.func_184103_al().func_72389_g();
            }
            for (WorldServer world : server.field_71305_c) {
                if (world == null) continue;
                world.func_73044_a(true, null);
            }
        }
        catch (Exception ex) {
            this.notifyAll(server, player -> FTBBackups.lang(player, "ftbbackups.lang.saving_failed", new Object[0]), true);
            ex.printStackTrace();
            return;
        }
        Calendar time = Calendar.getInstance();
        boolean success = false;
        StringBuilder out = new StringBuilder();
        if (customName.isEmpty()) {
            this.appendNum(out, time.get(1), '-');
            this.appendNum(out, time.get(2) + 1, '-');
            this.appendNum(out, time.get(5), '-');
            this.appendNum(out, time.get(11), '-');
            this.appendNum(out, time.get(12), '-');
            this.appendNum(out, time.get(13), '\u0000');
        } else {
            out.append(customName);
        }
        Exception error = null;
        long fileSize = 0L;
        try {
            File dstFile;
            LinkedHashMap<File, String> fileMap = new LinkedHashMap<File, String>();
            String mcdir = server.func_71238_n().getCanonicalFile().getAbsolutePath();
            Consumer<File> consumer = file0 -> {
                for (File file : BackupUtils.listTree(file0)) {
                    String s1 = file.getAbsolutePath().replace(mcdir, "");
                    if (s1.startsWith(File.separator)) {
                        s1 = s1.substring(File.separator.length());
                    }
                    fileMap.put(file, "_extra_" + File.separator + s1);
                }
            };
            for (String s : FTBBackupsConfig.general.extra_files) {
                consumer.accept(new File(s));
            }
            MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.Pre(consumer));
            for (File file : BackupUtils.listTree(src)) {
                String filePath = file.getAbsolutePath();
                fileMap.put(file, src.getName() + File.separator + filePath.substring(src.getAbsolutePath().length() + 1));
            }
            for (Map.Entry entry : fileMap.entrySet()) {
                fileSize += BackupUtils.getSize((File)entry.getKey());
            }
            long totalSize = 0L;
            if (!this.backups.isEmpty()) {
                this.backups.sort(null);
                int backupsToKeep = FTBBackupsConfig.general.backups_to_keep - 1;
                if (backupsToKeep > 0 && this.backups.size() > backupsToKeep) {
                    while (this.backups.size() > backupsToKeep) {
                        Backup backup = this.backups.remove(0);
                        FTBBackups.LOGGER.info("Deleting old backup: " + backup.fileId);
                        BackupUtils.delete(backup.getFile());
                    }
                }
                for (Backup backup : this.backups) {
                    totalSize += backup.size;
                }
                if (fileSize > 0L) {
                    long freeSpace = Math.min(FTBBackupsConfig.general.getMaxTotalSize(), FTBBackupsConfig.general.getFolder().getFreeSpace());
                    while (totalSize + fileSize > freeSpace && !this.backups.isEmpty()) {
                        Backup backup = this.backups.remove(0);
                        totalSize -= backup.size;
                        FTBBackups.LOGGER.info("Deleting backup to free space: " + backup.fileId);
                        BackupUtils.delete(backup.getFile());
                    }
                }
            }
            this.totalFiles = fileMap.size();
            FTBBackups.LOGGER.info("Backing up " + this.totalFiles + " files...");
            this.printFiles = true;
            if (FTBBackupsConfig.general.compression_level > 0) {
                out.append(".zip");
                dstFile = BackupUtils.newFile(new File(FTBBackupsConfig.general.getFolder(), out.toString()));
                long start = System.currentTimeMillis();
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dstFile));
                zos.setLevel(FTBBackupsConfig.general.compression_level);
                byte[] buffer = new byte[FTBBackupsConfig.general.buffer_size];
                FTBBackups.LOGGER.info("Compressing " + this.totalFiles + " files...");
                this.currentFile = 0;
                for (Map.Entry entry : fileMap.entrySet()) {
                    try {
                        int len;
                        ZipEntry ze = new ZipEntry((String)entry.getValue());
                        this.currentFileName = (String)entry.getValue();
                        zos.putNextEntry(ze);
                        FileInputStream fis = new FileInputStream((File)entry.getKey());
                        while ((len = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, len);
                        }
                        zos.closeEntry();
                        fis.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++this.currentFile;
                }
                zos.close();
                fileSize = BackupUtils.getSize(dstFile);
                FTBBackups.LOGGER.info("Done compressing in " + BackupUtils.getTimeString(System.currentTimeMillis() - start) + " seconds (" + BackupUtils.getSizeString(fileSize) + ")!");
            } else {
                dstFile = new File(FTBBackupsConfig.general.getFolder(), out.toString());
                dstFile.mkdirs();
                this.currentFile = 0;
                for (Map.Entry entry : fileMap.entrySet()) {
                    try {
                        File file = (File)entry.getKey();
                        this.currentFileName = (String)entry.getValue();
                        File dst1 = new File(dstFile, (String)entry.getValue());
                        BackupUtils.copyFile(file, dst1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++this.currentFile;
                }
            }
            FTBBackups.LOGGER.info("Created " + dstFile.getAbsolutePath() + " from " + src.getAbsolutePath());
            success = true;
        }
        catch (Exception ex) {
            if (!FTBBackupsConfig.general.silent) {
                String errorName = ex.getClass().getName();
                this.notifyAll(server, player -> FTBBackups.lang(player, "ftbbackups.lang.fail", errorName), true);
            }
            ex.printStackTrace();
            error = ex;
        }
        this.printFiles = false;
        Backup backup = new Backup(time.getTimeInMillis(), out.toString().replace('\\', '/'), this.getLastIndex() + 1, success, fileSize);
        this.backups.add(backup);
        MinecraftForge.EVENT_BUS.post((Event)new BackupEvent.Post(backup, error));
        JsonArray array = new JsonArray();
        for (Backup backup1 : this.backups) {
            array.add((JsonElement)backup1.toJsonObject());
        }
        BackupUtils.toJson(new File(server.func_71238_n(), "local/ftbutilities/backups.json"), (JsonElement)array, true);
        if (error == null && !FTBBackupsConfig.general.silent) {
            String timeString = BackupUtils.getTimeString(System.currentTimeMillis() - time.getTimeInMillis());
            if (FTBBackupsConfig.general.display_file_size) {
                String sizeT;
                long totalSize = 0L;
                for (Backup backup1 : this.backups) {
                    totalSize += backup1.size;
                }
                String sizeB = BackupUtils.getSizeString(fileSize);
                String sizeString = sizeB.equals(sizeT = BackupUtils.getSizeString(totalSize)) ? sizeB : sizeB + " | " + sizeT;
                this.notifyAll(server, player -> FTBBackups.lang(player, "ftbbackups.lang.end_2", timeString, sizeString), false);
            } else {
                this.notifyAll(server, player -> FTBBackups.lang(player, "ftbbackups.lang.end_1", timeString), false);
            }
        }
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }

    private int getLastIndex() {
        int i = 0;
        for (Backup b : this.backups) {
            i = Math.max(i, b.index);
        }
        return i;
    }
}

