/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.extracpus.aehacks.client;

import appeng.block.crafting.BlockCraftingUnit;
import com.google.common.collect.ImmutableList;
import dev.rlnt.extracpus.aehacks.client.CraftingStorageModelLightBaked;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

class CraftingStorageModel
implements IModel {
    private static final ResourceLocation RING_CORNER = CraftingStorageModel.aeTexture("ring_corner");
    private static final ResourceLocation RING_SIDE_HOR = CraftingStorageModel.aeTexture("ring_side_hor");
    private static final ResourceLocation RING_SIDE_VER = CraftingStorageModel.aeTexture("ring_side_ver");
    private static final ResourceLocation UNIT_BASE = CraftingStorageModel.aeTexture("unit_base");
    private static final ResourceLocation LIGHT_BASE = CraftingStorageModel.aeTexture("light_base");
    private static final ResourceLocation ACCELERATOR_LIGHT = CraftingStorageModel.aeTexture("accelerator_light");
    private static final ResourceLocation STORAGE_1K_LIGHT = CraftingStorageModel.texture("256k_light");
    private static final ResourceLocation STORAGE_4K_LIGHT = CraftingStorageModel.texture("1024k_light");
    private static final ResourceLocation STORAGE_16K_LIGHT = CraftingStorageModel.texture("4096k_light");
    private static final ResourceLocation STORAGE_64K_LIGHT = CraftingStorageModel.texture("16384k_light");
    private static final ResourceLocation MONITOR_BASE = CraftingStorageModel.aeTexture("monitor_base");
    private static final ResourceLocation MONITOR_LIGHT_DARK = CraftingStorageModel.aeTexture("monitor_light_dark");
    private static final ResourceLocation MONITOR_LIGHT_MEDIUM = CraftingStorageModel.aeTexture("monitor_light_medium");
    private static final ResourceLocation MONITOR_LIGHT_BRIGHT = CraftingStorageModel.aeTexture("monitor_light_bright");
    private final BlockCraftingUnit.CraftingUnitType type;

    CraftingStorageModel(BlockCraftingUnit.CraftingUnitType type) {
        this.type = type;
    }

    private static TextureAtlasSprite getLightTexture(Function<ResourceLocation, TextureAtlasSprite> textureGetter, BlockCraftingUnit.CraftingUnitType type) {
        switch (type) {
            case ACCELERATOR: {
                return textureGetter.apply(ACCELERATOR_LIGHT);
            }
            case STORAGE_1K: {
                return textureGetter.apply(STORAGE_1K_LIGHT);
            }
            case STORAGE_4K: {
                return textureGetter.apply(STORAGE_4K_LIGHT);
            }
            case STORAGE_16K: {
                return textureGetter.apply(STORAGE_16K_LIGHT);
            }
            case STORAGE_64K: {
                return textureGetter.apply(STORAGE_64K_LIGHT);
            }
        }
        throw new IllegalArgumentException("Crafting unit type " + type + " does not use a light texture.");
    }

    private static ResourceLocation texture(String name) {
        return new ResourceLocation("extracpus", "block/" + name);
    }

    private static ResourceLocation aeTexture(String name) {
        return new ResourceLocation("appliedenergistics2", "blocks/crafting/" + name);
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)RING_CORNER, (Object)RING_SIDE_HOR, (Object)RING_SIDE_VER, (Object)UNIT_BASE, (Object)LIGHT_BASE, (Object)ACCELERATOR_LIGHT, (Object)STORAGE_1K_LIGHT, (Object)STORAGE_4K_LIGHT, (Object)STORAGE_16K_LIGHT, (Object)STORAGE_64K_LIGHT, (Object)MONITOR_BASE, (Object)MONITOR_LIGHT_DARK, (Object[])new ResourceLocation[]{MONITOR_LIGHT_MEDIUM, MONITOR_LIGHT_BRIGHT});
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite ringCorner = bakedTextureGetter.apply(RING_CORNER);
        TextureAtlasSprite ringSideHor = bakedTextureGetter.apply(RING_SIDE_HOR);
        TextureAtlasSprite ringSideVer = bakedTextureGetter.apply(RING_SIDE_VER);
        switch (this.type) {
            case ACCELERATOR: 
            case STORAGE_1K: 
            case STORAGE_4K: 
            case STORAGE_16K: 
            case STORAGE_64K: {
                return new CraftingStorageModelLightBaked(format, ringCorner, ringSideHor, ringSideVer, bakedTextureGetter.apply(LIGHT_BASE), CraftingStorageModel.getLightTexture(bakedTextureGetter, this.type));
            }
        }
        throw new IllegalArgumentException("Unsupported crafting unit type: " + this.type);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }
}

