/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import micdoodle8.mods.galacticraft.planets.venus.VenusBlocks;
import micdoodle8.mods.galacticraft.planets.venus.blocks.BlockTier3TreasureChest;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonConfigurationVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonStartVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.PieceVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomBossVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.SizedPieceVenus;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.storage.loot.LootTableList;

public class RoomTreasureVenus
extends SizedPieceVenus {
    public static ResourceLocation VENUSCHEST = new ResourceLocation("galacticraftcore", "dungeon_tier_3");
    public static final ResourceLocation TABLE_TIER_3_DUNGEON = LootTableList.func_186375_a((ResourceLocation)VENUSCHEST);

    public RoomTreasureVenus() {
    }

    public RoomTreasureVenus(DungeonConfigurationVenus configuration, Random rand, int blockPosX, int blockPosZ, EnumFacing entranceDir) {
        this(configuration, rand, blockPosX, blockPosZ, rand.nextInt(4) + 6, configuration.getRoomHeight(), rand.nextInt(4) + 6, entranceDir);
    }

    public RoomTreasureVenus(DungeonConfigurationVenus configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing entranceDir) {
        super(configuration, sizeX, sizeY, sizeZ, entranceDir.func_176734_d());
        this.func_186164_a(EnumFacing.SOUTH);
        int yPos = configuration.getYPosition();
        this.field_74887_e = new StructureBoundingBox(blockPosX, yPos, blockPosZ, blockPosX + this.sizeX, yPos + this.sizeY, blockPosZ + this.sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random random, StructureBoundingBox boundingBox) {
        for (int i = 0; i <= this.sizeX; ++i) {
            for (int j = 0; j <= this.sizeY; ++j) {
                for (int k = 0; k <= this.sizeZ; ++k) {
                    if (i == 0 || i == this.sizeX || j == 0 || j == this.sizeY || k == 0 || k == this.sizeZ) {
                        int end;
                        int start;
                        boolean placeBlock = true;
                        if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z) {
                            start = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 - 1;
                            end = (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2 + 1;
                            if (i > start && i <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.SOUTH && k == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.NORTH && k == this.sizeZ) {
                                    placeBlock = false;
                                }
                            }
                        } else {
                            start = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 - 1;
                            end = (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2 + 1;
                            if (k > start && k <= end && j < 3 && j > 0) {
                                if (this.getDirection() == EnumFacing.EAST && i == 0) {
                                    placeBlock = false;
                                } else if (this.getDirection() == EnumFacing.WEST && i == this.sizeX) {
                                    placeBlock = false;
                                }
                            }
                        }
                        if (placeBlock) {
                            DungeonConfigurationVenus venusConfig = this.configuration;
                            this.func_175811_a(worldIn, j == 0 || j == this.sizeY ? venusConfig.getBrickBlockFloor() : this.configuration.getBrickBlock(), i, j, k, boundingBox);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    if (i == 1 && k == 1 || i == 1 && k == this.sizeZ - 1 || i == this.sizeX - 1 && k == 1 || i == this.sizeX - 1 && k == this.sizeZ - 1) {
                        this.func_175811_a(worldIn, Blocks.field_150426_aN.func_176223_P(), i, j, k, boundingBox);
                        continue;
                    }
                    if (i == this.sizeX / 2 && j == 1 && k == this.sizeZ / 2) {
                        BlockPos blockpos = new BlockPos(this.func_74865_a(i, k), this.func_74862_a(j), this.func_74873_b(i, k));
                        if (!boundingBox.func_175898_b((Vec3i)blockpos)) continue;
                        worldIn.func_180501_a(blockpos, VenusBlocks.treasureChestTier3.func_176223_P().func_177226_a((IProperty)BlockTier3TreasureChest.FACING, (Comparable)this.getDirection().func_176734_d()), 2);
                        TileEntityTreasureChest treasureChest = (TileEntityTreasureChest)worldIn.func_175625_s(blockpos);
                        if (treasureChest == null) continue;
                        ResourceLocation chesttype = TABLE_TIER_3_DUNGEON;
                        if (worldIn.field_73011_w instanceof IGalacticraftWorldProvider) {
                            chesttype = ((IGalacticraftWorldProvider)worldIn.field_73011_w).getDungeonChestType();
                        }
                        treasureChest.setLootTable(chesttype, random.nextLong());
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, boundingBox);
                }
            }
        }
        return true;
    }

    @Override
    public PieceVenus getNextPiece(DungeonStartVenus startPiece, Random rand) {
        StructureComponent component;
        if (startPiece.attachedComponents.size() > 2 && (component = startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 3)) instanceof RoomBossVenus) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(this.sizeX / 2, this.sizeZ / 2), this.func_74862_a(1), this.func_74873_b(this.sizeX / 2, this.sizeZ / 2));
            ((RoomBossVenus)component).setChestPos(new BlockPos((Vec3i)blockpos));
        }
        return null;
    }
}

