/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.client.model.OBJLoaderGC;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.lwjgl.opengl.GL11;

public class RenderAstroMiner
extends Render<EntityAstroMiner> {
    private static final float LSIZE = 0.12f;
    private static final float RETRACTIONSPEED = 0.02f;
    private float lastPartTime;
    public static ResourceLocation scanTexture = new ResourceLocation("galacticraftplanets", "textures/misc/gradient.png");
    private OBJModel.OBJBakedModel mainModel;
    private OBJModel.OBJBakedModel hoverPadMain;
    private OBJModel.OBJBakedModel hoverPadGlow;
    private OBJModel.OBJBakedModel mainModelInactive;
    private OBJModel.OBJBakedModel modellaser1;
    private OBJModel.OBJBakedModel modellaser3;
    private OBJModel.OBJBakedModel modellasergl;
    private final NoiseModule wobbleX;
    private final NoiseModule wobbleY;
    private final NoiseModule wobbleZ;
    private final NoiseModule wobbleXX;
    private final NoiseModule wobbleYY;
    private final NoiseModule wobbleZZ;

    private void updateModels() {
        if (this.mainModel == null) {
            try {
                IModel model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galacticraftplanets", "astro_miner_full.obj"));
                Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                this.mainModel = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Hull", (Object)"Lasers"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.hoverPadMain = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"HoverPad"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.hoverPadGlow = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Glow"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.modellaser1 = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Main_Laser_Front"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.modellaser3 = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Main_Laser_Center"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                this.modellasergl = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Main_Laser_Left_Guard"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
                model = OBJLoaderGC.instance.loadModel(new ResourceLocation("galacticraftplanets", "astro_miner_full_off.obj"));
                this.mainModelInactive = (OBJModel.OBJBakedModel)model.bake((IModelState)new OBJModel.OBJState((List)ImmutableList.of((Object)"Hull", (Object)"Lasers", (Object)"HoverPad"), false), DefaultVertexFormats.field_176599_b, (java.util.function.Function)spriteFunction);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RenderAstroMiner(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 2.0f;
        Random rand = new Random();
        this.wobbleX = new Gradient(rand.nextLong(), 2, 1.0f);
        this.wobbleX.amplitude = 0.5f;
        this.wobbleX.frequencyX = 0.025f;
        this.wobbleY = new Gradient(rand.nextLong(), 2, 1.0f);
        this.wobbleY.amplitude = 0.6f;
        this.wobbleY.frequencyX = 0.025f;
        this.wobbleZ = new Gradient(rand.nextLong(), 2, 1.0f);
        this.wobbleZ.amplitude = 0.1f;
        this.wobbleZ.frequencyX = 0.025f;
        this.wobbleXX = new Gradient(rand.nextLong(), 2, 1.0f);
        this.wobbleXX.amplitude = 0.1f;
        this.wobbleXX.frequencyX = 0.8f;
        this.wobbleYY = new Gradient(rand.nextLong(), 2, 1.0f);
        this.wobbleYY.amplitude = 0.15f;
        this.wobbleYY.frequencyX = 0.8f;
        this.wobbleZZ = new Gradient(rand.nextLong(), 2, 1.0f);
        this.wobbleZZ.amplitude = 0.04f;
        this.wobbleZZ.frequencyX = 0.8f;
    }

    public void doRender(EntityAstroMiner astroMiner, double x, double y, double z, float f, float partialTickTime) {
        float partBlock;
        float partTime;
        int ais = astroMiner.AIstate;
        boolean active = ais > 1;
        float time = (float)astroMiner.field_70173_aa + partialTickTime;
        float sinOfTheTime = (MathHelper.func_76126_a((float)(time / 4.0f)) + 1.0f) / 4.0f + 0.5f;
        float wx = active ? this.wobbleX.getNoise(time) + this.wobbleXX.getNoise(time) : 0.0f;
        float wy = active ? this.wobbleY.getNoise(time) + this.wobbleYY.getNoise(time) : 0.0f;
        float wz = active ? this.wobbleZ.getNoise(time) + this.wobbleZZ.getNoise(time) : 0.0f;
        this.lastPartTime = partialTickTime;
        for (partTime = partialTickTime - this.lastPartTime; partTime < 0.0f; partTime += 1.0f) {
        }
        this.updateModels();
        this.func_180548_c(astroMiner);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        float rotPitch = astroMiner.field_70127_C + (astroMiner.field_70125_A - astroMiner.field_70127_C) * partialTickTime;
        float rotYaw = astroMiner.field_70126_B + (astroMiner.field_70177_z - astroMiner.field_70126_B) * partialTickTime;
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.4f), (float)((float)z));
        switch (astroMiner.facing) {
            case DOWN: {
                partBlock = (float)(astroMiner.field_70163_u % 2.0);
                break;
            }
            case UP: {
                partBlock = 1.0f - (float)(astroMiner.field_70163_u % 2.0);
                break;
            }
            case NORTH: {
                partBlock = (float)(astroMiner.field_70161_v % 2.0);
                break;
            }
            case SOUTH: {
                partBlock = 1.0f - (float)(astroMiner.field_70161_v % 2.0);
                break;
            }
            case WEST: {
                partBlock = (float)(astroMiner.field_70165_t % 2.0);
                break;
            }
            case EAST: {
                partBlock = 1.0f - (float)(astroMiner.field_70165_t % 2.0);
                break;
            }
            default: {
                partBlock = 0.0f;
            }
        }
        partBlock /= 0.06f;
        GlStateManager.func_179114_b((float)(rotYaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (rotPitch != 0.0f) {
            GlStateManager.func_179109_b((float)-0.65f, (float)-0.65f, (float)0.0f);
            GlStateManager.func_179114_b((float)(rotPitch / 4.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.65f, (float)0.65f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)-0.42f, (float)0.28f);
        GlStateManager.func_179152_a((float)0.0495f, (float)0.0495f, (float)0.0495f);
        GlStateManager.func_179109_b((float)wx, (float)wy, (float)wz);
        if (active) {
            ClientUtil.drawBakedModel((IBakedModel)this.mainModel);
            this.renderLaserModel(astroMiner.retraction);
            float lightMapSaveX = OpenGlHelper.lastBrightnessX;
            float lightMapSaveY = OpenGlHelper.lastBrightnessY;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)sinOfTheTime, (float)sinOfTheTime, (float)sinOfTheTime, (float)1.0f);
            ClientUtil.drawBakedModel((IBakedModel)this.hoverPadMain);
            GlStateManager.func_179129_p();
            GlStateManager.func_179118_c();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179112_b((int)770, (int)1);
            GlStateManager.func_179147_l();
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GlStateManager.func_179131_c((float)sinOfTheTime, (float)sinOfTheTime, (float)sinOfTheTime, (float)0.6f);
            ClientUtil.drawBakedModel((IBakedModel)this.hoverPadGlow);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            if (ais < 5) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(scanTexture);
                Tessellator tess = Tessellator.func_178181_a();
                GlStateManager.func_179131_c((float)0.0f, (float)0.6f, (float)1.0f, (float)0.2f);
                BufferBuilder worldRenderer = tess.func_178180_c();
                float scanProgress = MathHelper.func_76134_b((float)(partBlock * 0.012f * 6.283f)) * 0.747f;
                float scanAngle = 0.69866f - scanProgress * scanProgress;
                float scanEndX = 38.77f * MathHelper.func_76126_a((float)scanAngle);
                float scanEndY = 32.0f;
                float scanEndZ = 38.77f * MathHelper.func_76134_b((float)scanAngle);
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)15.6f, (double)-0.6f, -20.0).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)(15.6f + scanEndX), (double)(scanEndY - 0.6f), (double)(-(scanEndZ += 20.0f))).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)(15.6f + scanEndX), (double)(-0.6f - scanEndY), (double)(-scanEndZ)).func_187315_a(1.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)15.6f, (double)-0.7f, -20.0).func_187315_a(0.0, 1.0).func_181675_d();
                tess.func_78381_a();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)-15.6f, (double)-0.6f, -20.0).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)(-15.6f - scanEndX), (double)(scanEndY - 0.6f), (double)(-scanEndZ)).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)(-15.6f - scanEndX), (double)(-0.6f - scanEndY), (double)(-scanEndZ)).func_187315_a(1.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)-15.6f, (double)-0.7f, -20.0).func_187315_a(0.0, 1.0).func_181675_d();
                tess.func_78381_a();
                int removeCount = 0;
                int afterglowCount = 0;
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(x - astroMiner.field_70165_t)), (float)((float)(y - astroMiner.field_70163_u)), (float)((float)(z - astroMiner.field_70161_v)));
                for (Integer blockTime : new ArrayList<Integer>(astroMiner.laserTimes)) {
                    if (blockTime < astroMiner.field_70173_aa - 19) {
                        ++removeCount;
                        continue;
                    }
                    if (blockTime >= astroMiner.field_70173_aa - 3) continue;
                    ++afterglowCount;
                }
                if (removeCount > 0) {
                    astroMiner.removeLaserBlocks(removeCount);
                }
                int count = 0;
                for (BlockVec3 blockLaser : new ArrayList<BlockVec3>(astroMiner.laserBlocks)) {
                    if (count < afterglowCount) {
                        int fade = astroMiner.field_70173_aa - astroMiner.laserTimes.get(count) - 8;
                        if (fade < 0) {
                            fade = 0;
                        }
                        this.doAfterGlow(blockLaser, fade);
                    } else {
                        this.doLaser(astroMiner, blockLaser);
                    }
                    ++count;
                }
                if (astroMiner.retraction > 0.0f) {
                    astroMiner.retraction -= 0.02f * partTime;
                    if (astroMiner.retraction < 0.0f) {
                        astroMiner.retraction = 0.0f;
                    }
                }
                GlStateManager.func_179121_F();
            } else {
                if (astroMiner.retraction < 1.0f) {
                    astroMiner.retraction += 0.02f * partTime;
                    if (astroMiner.retraction > 1.0f) {
                        astroMiner.retraction = 1.0f;
                    }
                }
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        } else {
            this.func_180548_c(astroMiner);
            ClientUtil.drawBakedModel((IBakedModel)this.mainModelInactive);
            this.renderLaserModel(astroMiner.retraction);
            if (astroMiner.retraction < 1.0f) {
                astroMiner.retraction += 0.02f * partTime;
                if (astroMiner.retraction > 1.0f) {
                    astroMiner.retraction = 1.0f;
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    private void doAfterGlow(BlockVec3 blockLaser, int level) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)blockLaser.x, (float)blockLaser.y, (float)blockLaser.z);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)0.7f, (float)0.7f, (float)(0.016667f * (float)(12 - level)));
        float cA = -0.01f;
        float cB = 1.01f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cB).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cB).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cB).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cB).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cB).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cB).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cB).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cB).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(1.0, (double)cA, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(1.0, 1.0, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, 1.0, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(1.0, (double)cA, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cA, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, 1.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
    }

    private void doLaser(EntityAstroMiner entity, BlockVec3 blockLaser) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)blockLaser.x, (float)blockLaser.y, (float)blockLaser.z);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        GlStateManager.func_179131_c((float)1.0f, (float)0.7f, (float)0.7f, (float)0.2f);
        float cA = -0.01f;
        float cB = 1.01f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cB).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cB).func_187315_a(0.0, 0.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cB).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cB).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cB, (double)cB).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cB).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cA, (double)cB).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cB).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cB, (double)cB, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(1.0, (double)cA, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(1.0, 1.0, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, 1.0, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b(1.0, (double)cA, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, (double)cA, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)cA, 1.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)0.79f, (float)0.79f, (float)0.17f);
        float bb = 1.7f;
        float cc = 0.4f;
        float radiansYaw = entity.field_70177_z / 57.295776f;
        float radiansPitch = entity.field_70125_A / 57.295776f / 4.0f;
        float mainLaserX = bb * MathHelper.func_76126_a((float)radiansYaw) * MathHelper.func_76134_b((float)radiansPitch);
        float mainLaserY = cc + bb * MathHelper.func_76126_a((float)radiansPitch);
        float mainLaserZ = bb * MathHelper.func_76134_b((float)radiansYaw) * MathHelper.func_76134_b((float)radiansPitch);
        mainLaserX = (float)((double)mainLaserX + (entity.field_70165_t - (double)blockLaser.x));
        mainLaserY = (float)((double)mainLaserY + (entity.field_70163_u - (double)blockLaser.y));
        mainLaserZ = (float)((double)mainLaserZ + (entity.field_70161_v - (double)blockLaser.z));
        float xD = mainLaserX - 0.5f;
        float yD = mainLaserY - 0.5f;
        float zD = mainLaserZ - 0.5f;
        if (entity.facing.func_176745_a() > EnumFacing.SOUTH.func_176745_a()) {
            float xx = xD < 0.0f ? cA : cB;
            this.drawLaserX(mainLaserX, mainLaserY, mainLaserZ, xx, 0.5f, 0.5f);
        } else if (entity.facing.func_176745_a() <= EnumFacing.UP.func_176745_a()) {
            float yy = yD < 0.0f ? cA : cB;
            this.drawLaserY(mainLaserX, mainLaserY, mainLaserZ, 0.5f, yy, 0.5f);
        } else {
            float zz = zD < 0.0f ? cA : cB;
            this.drawLaserZ(mainLaserX, mainLaserY, mainLaserZ, 0.5f, 0.5f, zz);
        }
        GlStateManager.func_179121_F();
    }

    private void drawLaserX(float x1, float y1, float z1, float x2, float y2, float z2) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)x1, (double)(y1 - 0.01f), (double)(z1 - 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 - 0.12f), (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 + 0.12f), (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x1, (double)(y1 + 0.01f), (double)(z1 - 0.01f)).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)x1, (double)(y1 - 0.01f), (double)(z1 + 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 - 0.12f), (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 + 0.12f), (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x1, (double)(y1 + 0.01f), (double)(z1 + 0.01f)).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)x1, (double)(y1 - 0.01f), (double)(z1 - 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 - 0.12f), (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 - 0.12f), (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x1, (double)(y1 - 0.01f), (double)(z1 + 0.01f)).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)x1, (double)(y1 + 0.01f), (double)(z1 + 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 + 0.12f), (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 + 0.12f), (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x1, (double)(y1 + 0.01f), (double)(z1 - 0.01f)).func_181675_d();
        tess.func_78381_a();
    }

    private void drawLaserY(float x1, float y1, float z1, float x2, float y2, float z2) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)y1, (double)(z1 - 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)y2, (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)y2, (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)y1, (double)(z1 - 0.01f)).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)y1, (double)(z1 + 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)y2, (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)y2, (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)y1, (double)(z1 + 0.01f)).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)y1, (double)(z1 - 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)y2, (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)y2, (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)y1, (double)(z1 + 0.01f)).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)y1, (double)(z1 + 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)y2, (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)y2, (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)y1, (double)(z1 - 0.01f)).func_181675_d();
        tess.func_78381_a();
    }

    private void drawLaserZ(float x1, float y1, float z1, float x2, float y2, float z2) {
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tess.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)(y1 - 0.01f), (double)z1).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)(y2 - 0.12f), (double)z2).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)(y2 + 0.12f), (double)z2).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)(y1 + 0.01f), (double)z1).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)(y1 - 0.01f), (double)z1).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)(y2 - 0.12f), (double)z2).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)(y2 + 0.12f), (double)z2).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)(y1 + 0.01f), (double)z1).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(x1 - 0.01f), (double)(y1 - 0.01f), (double)z1).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 - 0.12f), (double)(y2 - 0.12f), (double)z2).func_181675_d();
        worldRenderer.func_181662_b((double)(x2 + 0.12f), (double)(y2 - 0.12f), (double)z2).func_181675_d();
        worldRenderer.func_181662_b((double)(x1 + 0.01f), (double)(y1 - 0.01f), (double)z1).func_181675_d();
        tess.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)x1, (double)(y1 + 0.01f), (double)(z1 + 0.01f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 + 0.12f), (double)(z2 + 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x2, (double)(y2 + 0.12f), (double)(z2 - 0.12f)).func_181675_d();
        worldRenderer.func_181662_b((double)x1, (double)(y1 + 0.01f), (double)(z1 - 0.01f)).func_181675_d();
        tess.func_78381_a();
    }

    private void renderLaserModel(float retraction) {
        float zadjust;
        float guardmovement;
        float laserretraction = retraction / 0.8f;
        if (laserretraction > 1.0f) {
            laserretraction = 1.0f;
        }
        if ((guardmovement = (retraction - 0.6f) / 0.4f * 1.875f) < 0.0f) {
            guardmovement = 0.0f;
        }
        GlStateManager.func_179094_E();
        float yadjust = zadjust = laserretraction * 5.0f;
        if (yadjust > 0.938f) {
            yadjust = 0.938f;
            zadjust = (zadjust - yadjust) * 2.5f + yadjust;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)yadjust, (float)zadjust);
        ClientUtil.drawBakedModel((IBakedModel)this.modellaser1);
        if (yadjust == 0.938f) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-zadjust + 0.938f));
        }
        ClientUtil.drawBakedModel((IBakedModel)this.modellaser3);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)guardmovement, (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.modellasergl);
        GlStateManager.func_179109_b((float)(-2.0f * guardmovement + 8.75f), (float)0.0f, (float)0.0f);
        ClientUtil.drawBakedModel((IBakedModel)this.modellasergl);
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntityAstroMiner entity) {
        return TextureMap.field_110575_b;
    }

    public boolean shouldRender(EntityAstroMiner miner, ICamera camera, double camX, double camY, double camZ) {
        return miner.func_145770_h(camX, camY, camZ);
    }
}

