/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util.list;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialObject;
import micdoodle8.mods.galacticraft.core.util.list.ImmutableCelestialList;

public class CelestialList<T extends CelestialObject>
extends ArrayList<T> {
    private static final long serialVersionUID = 1L;
    private Map<String, T> celestialListMap;

    public static <E extends CelestialObject> CelestialList<E> create() {
        return new CelestialList();
    }

    @SafeVarargs
    public static <E extends CelestialObject> CelestialList<E> of(CelestialList<E> ... lists) {
        ArrayList<E> temp = new ArrayList<E>();
        for (CelestialList<E> l : lists) {
            temp.addAll(l);
        }
        return new CelestialList(temp);
    }

    public CelestialList(Collection<? extends T> s) {
        super(s);
    }

    public CelestialList() {
        this.celestialListMap = new HashMap<String, T>();
    }

    private T mapPut(String name, T t) {
        if (this.celestialListMap.containsKey(name)) {
            return (T)((CelestialObject)this.celestialListMap.get(name));
        }
        return (T)((CelestialObject)this.celestialListMap.put(name, t));
    }

    @Override
    public boolean add(T e) {
        if (this.contains(e)) {
            return false;
        }
        this.mapPut(((CelestialObject)e).getName(), e);
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (CelestialObject t : c) {
            this.add((T)t);
        }
        return true;
    }

    public Map<String, T> getRegistered() {
        return ImmutableMap.copyOf(this.celestialListMap);
    }

    public ImmutableCelestialList<T> toUnmodifiableList() {
        return ImmutableCelestialList.unmodifiable(this);
    }
}

