/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
public final class I18nUtil {
    public static final I18nUtil instance = new I18nUtil();

    public String getKey(String prefix, ResourceLocation name) {
        return prefix + "." + name.func_110624_b() + "." + name.func_110623_a();
    }

    public String getKey(IForgeRegistryEntry<?> object, String key) {
        String prefix = this.getPrefixFor(object);
        ResourceLocation name = Objects.requireNonNull(object.getRegistryName());
        return prefix + "." + name.func_110624_b() + "." + name.func_110623_a() + "." + key;
    }

    public boolean hasKey(String key) {
        return net.minecraft.client.resources.I18n.func_188566_a((String)key);
    }

    public String translate(String key, Object ... params) {
        if (!FMLCommonHandler.instance().getSide().isClient()) {
            return I18n.func_74837_a((String)key, (Object[])params);
        }
        return net.minecraft.client.resources.I18n.func_135052_a((String)key, (Object[])params);
    }

    public String translatedName(Block block) {
        return this.translate(block.func_149739_a() + ".name", new Object[0]);
    }

    public String translatedName(Item item) {
        return this.translate(item.func_77658_a() + ".name", new Object[0]);
    }

    public String translatedName(ItemStack stack) {
        return this.translate(stack.func_77977_a() + ".name", new Object[0]);
    }

    public String subText(IForgeRegistryEntry<?> object, String key, Object ... params) {
        return this.translate(this.getKey(object, key), params);
    }

    public String miscText(String key, Object ... params) {
        return this.translate("misc", key, params);
    }

    private String getPrefixFor(IForgeRegistryEntry<?> object) {
        if (object instanceof Item) {
            return "item";
        }
        if (object instanceof Block) {
            return "tile";
        }
        return object.getClass().getName().toLowerCase(Locale.ROOT);
    }
}

