/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.util.Optional;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public enum Compatibility {
    ACTUALLYADDITIONS("actuallyadditions"),
    APPLIEDENERGISTICS2("appliedenergistics2"),
    BIOMESOPLENTY("biomesoplenty"),
    BUILDCRAFT("buildcraftcore"),
    BUILDCRAFT_TRANSPORT("buildcrafttransport"),
    BUILDCRAFT_ENERGY("buildcraftenergy"),
    CUBIC_CHUNKS("cubicchunks"),
    ENDERIO("enderio"),
    GRECHTECH("gregtech", "gregtech_addon"),
    INDUSTRIALCRAFT("ic2"),
    JEI("jei"),
    MATTEROVERDRIVE("matteroverdrive"),
    MEKANISM("mekanism"),
    PLAYER_API("PlayerAPI"),
    RENDER_PLAYER_API("RenderPlayerAPI"),
    PNEUMATICCRAFT("pneumaticcraft"),
    SPONGEFORGE("spongeforge"),
    TINKERS_CONSTRUCT("tconstruct"),
    WAILA("waila");

    private final String modid;
    private final String displayName;
    private final boolean isLoaded;
    private final Optional<ModContainer> modContainer;

    private Compatibility(String modid, String altModid) {
        boolean loaded = Loader.isModLoaded((String)modid) || Loader.isModLoaded((String)altModid);
        this.modid = modid;
        this.isLoaded = loaded;
        this.modContainer = Loader.instance().getModList().stream().filter(m -> m.getModId().equals(modid)).findFirst();
        this.displayName = loaded ? this.modContainer.get().getName() : "";
    }

    private Compatibility(String modid) {
        boolean loaded = Loader.isModLoaded((String)modid);
        this.modid = modid;
        this.isLoaded = loaded;
        this.modContainer = Loader.instance().getModList().stream().filter(m -> m.getModId().equals(modid)).findFirst();
        this.displayName = loaded ? this.modContainer.get().getName() : "";
    }

    public String modid() {
        return this.modid;
    }

    public String displayName() {
        return this.displayName;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public String getVersion() {
        if (this.modContainer.isPresent()) {
            return this.modContainer.get().getVersion();
        }
        return "unspecified";
    }
}

