/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.perlin.generator;

import java.util.Random;
import micdoodle8.mods.galacticraft.core.perlin.Evaluator;
import micdoodle8.mods.galacticraft.core.perlin.FishyNoise;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;

public class GradientNoise
extends NoiseModule
implements Evaluator {
    private final FishyNoise noiseGen;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final int numOctaves;
    private final double persistance;

    public GradientNoise(long seed, int nOctaves, double p) {
        this.numOctaves = nOctaves;
        this.persistance = p;
        Random rand = new Random(seed);
        this.offsetX = (double)(rand.nextFloat() / 2.0f) + 0.0;
        this.offsetY = (double)(rand.nextFloat() / 2.0f) + 0.0;
        this.offsetZ = (double)(rand.nextFloat() / 2.0f) + 0.0;
        this.noiseGen = new FishyNoise(seed);
    }

    @Override
    public double evalNoise(double i) {
        i *= this.freqX;
        double val = 0.0;
        double curAmplitude = this.ampl;
        for (int n = 0; n < this.numOctaves; ++n) {
            val += this.noiseGen.eval(i + this.offsetX, this.offsetY) * curAmplitude;
            i *= 2.0;
            curAmplitude *= this.persistance;
        }
        return val;
    }

    @Override
    public double evalNoise(double i, double j) {
        if (this.numOctaves == 1) {
            return this.noiseGen.eval(i * this.freqX + this.offsetX, j * this.freqY + this.offsetY) * this.ampl;
        }
        i *= this.freqX;
        j *= this.freqY;
        double val = 0.0;
        double curAmplitude = this.ampl;
        for (int n = 0; n < this.numOctaves; ++n) {
            val += this.noiseGen.eval(i + this.offsetX, j + this.offsetY) * curAmplitude;
            i *= 2.0;
            j *= 2.0;
            curAmplitude *= this.persistance;
        }
        return val;
    }

    @Override
    public double evalNoise(double i, double j, double k) {
        if (this.numOctaves == 1) {
            return this.noiseGen.eval(i * this.freqX + this.offsetX, j * this.freqY + this.offsetY, k * this.freqZ + this.offsetZ) * this.ampl;
        }
        i *= this.freqX;
        j *= this.freqY;
        k *= this.freqZ;
        double val = 0.0;
        double curAmplitude = this.ampl;
        for (int n = 0; n < this.numOctaves; ++n) {
            val += this.noiseGen.eval(i + this.offsetX, j + this.offsetY, k + this.offsetZ) * curAmplitude;
            i *= 2.0;
            j *= 2.0;
            k *= 2.0;
            curAmplitude *= this.persistance;
        }
        return val;
    }
}

