/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.fluid;

import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.core.fluid.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.BlockUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEnchantmentTable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OxygenPressureProtocol {
    public static final List<BlockUtil.MultiBlockStateHolder> newNonPermeableBlockStateList = new ArrayList<BlockUtil.MultiBlockStateHolder>();
    public static final List<Block> nonPermeableBlockList = new ArrayList<Block>();

    public static void updateSealerStatus(TileEntityOxygenSealer head) {
        try {
            head.threadSeal = new ThreadFindSeal(head);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public static void onEdgeBlockUpdated(World world, BlockPos vec) {
        if (ConfigManagerCore.enableSealerEdgeChecks) {
            TickHandlerServer.scheduleNewEdgeCheck(GCCoreUtil.getDimensionID(world), vec);
        }
    }

    @Deprecated
    public static boolean canBlockPassAir(World world, Block block, BlockPos pos, EnumFacing side) {
        return OxygenPressureProtocol.canBlockPassAir(world, world.func_180495_p(pos), pos, side);
    }

    public static boolean canBlockPassAir(World world, IBlockState state, BlockPos pos, EnumFacing side) {
        Block block = state.func_177230_c();
        if (block == null) {
            return true;
        }
        if (block instanceof IPartialSealableBlock) {
            return !((IPartialSealableBlock)block).isSealed(world, pos, side);
        }
        if (block instanceof BlockLeaves) {
            return true;
        }
        if (block.func_149662_c(state)) {
            return block instanceof BlockGravel || block.func_149688_o(state) == Material.field_151580_n || block instanceof BlockSponge;
        }
        if (block instanceof BlockGlass || block instanceof BlockStainedGlass) {
            return false;
        }
        for (BlockUtil.MultiBlockStateHolder mbsh : newNonPermeableBlockStateList) {
            if (!mbsh.getBlock().equals(block) || !mbsh.getBlockstateList().contains(state)) continue;
            return false;
        }
        if (block instanceof BlockSlab) {
            int meta = state.func_177230_c().func_176201_c(state);
            return !(side == EnumFacing.DOWN && (meta & 8) == 8 || side == EnumFacing.UP && (meta & 8) == 0);
        }
        if (block instanceof BlockFarmland || block instanceof BlockEnchantmentTable || block instanceof BlockLiquid) {
            return side != EnumFacing.UP;
        }
        if (block instanceof BlockPistonBase) {
            if (((Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue()) {
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockPistonBase.field_176387_N);
                return side != facing;
            }
            return false;
        }
        return !block.isSideSolid(state, (IBlockAccess)world, pos, side.func_176734_d());
    }

    static {
        BlockUtil.getBlockStateHolderList(BlockUtil.getListFromStringArray(ConfigManagerCore.sealableIDs)).forEach(mbsh -> newNonPermeableBlockStateList.add((BlockUtil.MultiBlockStateHolder)mbsh));
        newNonPermeableBlockStateList.forEach(mbsh -> nonPermeableBlockList.add(mbsh.getBlock()));
    }
}

