/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.command;

import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandSpaceStationChangeOwner
extends CommandBase {
    public String func_71518_a(ICommandSender var1) {
        return "/" + this.func_71517_b() + " <dim#> <player>";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "ssnewowner";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String oldOwner = null;
        String newOwner = "ERROR";
        int stationID = -1;
        EntityPlayerMP playerAdmin = PlayerUtil.getPlayerBaseServerFromPlayerUsername(sender.func_70005_c_(), true);
        if (args.length <= 1) throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssinvite.wrong_usage", this.func_71518_a(sender)), new Object[0]);
        newOwner = args[1];
        try {
            stationID = Integer.parseInt(args[0]);
        }
        catch (Exception var6) {
            throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssnewowner.wrong_usage", this.func_71518_a(sender)), new Object[0]);
        }
        if (stationID < 2) {
            throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssnewowner.wrong_usage", this.func_71518_a(sender)), new Object[0]);
        }
        try {
            GCPlayerStats stats;
            SpaceStationWorldData stationData = SpaceStationWorldData.getMPSpaceStationData(null, stationID, null);
            if (stationData == null) {
                throw new WrongUsageException(GCCoreUtil.translateWithFormat("commands.ssnewowner.wrong_usage", this.func_71518_a(sender)), new Object[0]);
            }
            oldOwner = stationData.getOwner();
            stationData.getAllowedPlayers().remove(oldOwner);
            if (stationData.getSpaceStationName().equals("Station: " + oldOwner)) {
                stationData.setSpaceStationName("Station: " + newOwner);
            }
            stationData.getAllowedPlayers().add(newOwner);
            stationData.setOwner(newOwner);
            EntityPlayerMP oldPlayer = PlayerUtil.getPlayerBaseServerFromPlayerUsername(oldOwner, true);
            EntityPlayerMP newPlayer = PlayerUtil.getPlayerBaseServerFromPlayerUsername(newOwner, true);
            if (oldPlayer != null) {
                stats = GCPlayerStats.get((Entity)oldPlayer);
                SpaceStationWorldData.updateSSOwnership(oldPlayer, oldOwner, stats, stationID, stationData);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, GCCoreUtil.getDimensionID(oldPlayer.field_70170_p), new Object[]{WorldUtil.spaceStationDataToString(stats.getSpaceStationDimensionData())}), oldPlayer);
            }
            if (newPlayer != null) {
                stats = GCPlayerStats.get((Entity)newPlayer);
                SpaceStationWorldData.updateSSOwnership(newPlayer, newOwner.replace(".", ""), stats, stationID, stationData);
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, GCCoreUtil.getDimensionID(oldPlayer.field_70170_p), new Object[]{WorldUtil.spaceStationDataToString(stats.getSpaceStationDimensionData())}), newPlayer);
            }
        }
        catch (Exception var6) {
            throw new CommandException(var6.getMessage(), new Object[0]);
        }
        if (playerAdmin != null) {
            playerAdmin.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translateWithFormat("gui.spacestation.changesuccess", oldOwner, newOwner)));
            return;
        } else {
            System.out.println(GCCoreUtil.translateWithFormat("gui.spacestation.changesuccess", oldOwner, newOwner));
        }
    }
}

