/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.blocks.BlockFluidGC;
import micdoodle8.mods.galacticraft.core.blocks.BlockGrating;
import micdoodle8.mods.galacticraft.core.util.JavaUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidClassic;

public class BlockGratingExtendedState
extends ExtendedBlockState {
    public BlockGratingExtendedState(Block blockIn, IProperty<?>[] properties, IUnlistedProperty<?>[] unlistedProperties) {
        super(blockIn, properties, unlistedProperties);
    }

    @Nonnull
    protected BlockStateContainer.StateImplementation createState(@Nonnull Block block, @Nonnull ImmutableMap<IProperty<?>, Comparable<?>> properties, @Nullable ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        if (unlistedProperties == null || unlistedProperties.isEmpty()) {
            return super.createState(block, properties, unlistedProperties);
        }
        return new ExtendedStateImplementation(block, properties, unlistedProperties, null, null);
    }

    protected static class ExtendedStateImplementation
    extends BlockStateContainer.StateImplementation
    implements IExtendedBlockState {
        private final ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties;
        private IBlockState cleanState;
        private final Block blockBase;

        protected ExtendedStateImplementation(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties, @Nullable ImmutableTable<IProperty<?>, Comparable<?>, IBlockState> table, IBlockState clean) {
            super(block, properties, table);
            this.unlistedProperties = unlistedProperties;
            this.cleanState = clean == null ? this : clean;
            this.blockBase = block;
        }

        @Nonnull
        public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(@Nonnull IProperty<T> property, @Nonnull V value) {
            IBlockState clean = super.func_177226_a(property, value);
            if (clean == this.cleanState) {
                return this;
            }
            if (Iterables.all((Iterable)this.unlistedProperties.values(), (Predicate)Predicates.equalTo(Optional.empty()))) {
                return clean;
            }
            return new ExtendedStateImplementation(this.func_177230_c(), clean.func_177228_b(), this.unlistedProperties, ((BlockStateContainer.StateImplementation)clean).getPropertyValueTable(), this.cleanState);
        }

        public <V> IExtendedBlockState withProperty(IUnlistedProperty<V> property, V value) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
            }
            if (!property.isValid(value)) {
                throw new IllegalArgumentException("Cannot set unlisted property " + property + " to " + value + " on block " + Block.field_149771_c.func_177774_c((Object)this.func_177230_c()) + ", it is not an allowed value");
            }
            HashMap newMap = new HashMap((Map<IUnlistedProperty<?>, Optional<?>>)this.unlistedProperties);
            newMap.put(property, Optional.ofNullable(value));
            if (Iterables.all(newMap.values(), (Predicate)Predicates.equalTo(Optional.empty()))) {
                return (IExtendedBlockState)this.cleanState;
            }
            return new ExtendedStateImplementation(this.func_177230_c(), this.func_177228_b(), ImmutableMap.copyOf(newMap), this.field_177238_c, this.cleanState);
        }

        public Collection<IUnlistedProperty<?>> getUnlistedNames() {
            return Collections.unmodifiableCollection(this.unlistedProperties.keySet());
        }

        public <V> V getValue(IUnlistedProperty<V> property) {
            if (!this.unlistedProperties.containsKey(property)) {
                throw new IllegalArgumentException("Cannot get unlisted property " + property + " as it does not exist in " + this.func_177230_c().func_176194_O());
            }
            return (V)property.getType().cast(((Optional)this.unlistedProperties.get(property)).orElse(null));
        }

        public ImmutableMap<IUnlistedProperty<?>, Optional<?>> getUnlistedProperties() {
            return this.unlistedProperties;
        }

        public IBlockState getClean() {
            return this.cleanState;
        }

        public Block func_177230_c() {
            IBlockState bs;
            if (JavaUtil.instance.isCalledBy(BlockFluidClassic.class, BlockFluidBase.class, BlockFluidGC.class) && (bs = ((BlockGrating)this.blockBase).getLiquidBlock((IBlockState)this)) != null) {
                return bs.func_177230_c();
            }
            return this.blockBase;
        }
    }
}

