#version 150

uniform sampler2D DiffuseSampler;
uniform float RedIntensity;
uniform float Alpha;
uniform vec2 OutSize;
uniform float Time;
uniform float RedReduceFactor; // 新增：红色减少因子 (0.0-1.0)

in vec2 texCoord;
out vec4 fragColor;

// 更狂暴的噪声函数
float hash(float n) { return fract(sin(n) * 43758.5453); }
float noise(vec2 p) {
    return hash(p.x * 12.9898 + p.y * 78.233);
}

// 更强烈的扭曲函数
float violentNoise(vec2 p) {
    return sin(p.x * 50.0 + Time * 15.0) * cos(p.y * 40.0 + Time * 12.0);
}

void main(){
    vec4 originalColor = texture(DiffuseSampler, texCoord);
    vec2 uv = texCoord;

    // 计算红色减少比例 (RedReduceFactor为0时完全不减少，1时减少最多)
    float redReduce = 1.0 - RedReduceFactor * 0.6; // 最多减少60%的红色

    // 狂暴节奏 - 多重频率脉冲
    float violentPulse = sin(Time * 15.0) * 0.7 + 0.3;
    float rageHeartbeat = sin(Time * 4.0 + sin(Time * 8.0) * 2.0) * 0.5 + 0.5;
    float chaosRhythm = sin(Time * 25.0) * 0.4 + 0.6;

    // 极度扭曲的屏幕效果
    vec2 violentUV = uv;
    float distortionPower = RedIntensity * 0.02;

    // 多重扭曲波
    violentUV.x += sin(uv.y * 30.0 + Time * 12.0) * distortionPower;
    violentUV.y += cos(uv.x * 25.0 + Time * 10.0) * distortionPower;
    violentUV.x += violentNoise(uv * 8.0) * distortionPower * 0.5;
    violentUV.y += violentNoise(uv * 6.0 + 0.5) * distortionPower * 0.5;

    // 红色通道色差偏移 - 狂暴的色差效果
    vec2 redOffsetDirection = normalize(uv - 0.5);
    float chromaticIntensity = RedIntensity * (0.01 + violentPulse * 0.02);

    // 红色通道强烈偏移
    vec2 redUV = violentUV + redOffsetDirection * chromaticIntensity;
    vec2 redUV2 = violentUV - redOffsetDirection * chromaticIntensity * 0.7;

    // 采样不同偏移的红色通道
    float redChannel1 = texture(DiffuseSampler, redUV).r;
    float redChannel2 = texture(DiffuseSampler, redUV2).r;

    // 混合多个红色通道创造色差效果
    float finalRed = (redChannel1 + redChannel2) * 0.5;

    vec3 distortedColor = texture(DiffuseSampler, violentUV).rgb;
    distortedColor.r = finalRed; // 应用红色色差

    // 沸腾的血色效果 - 应用红色减少
    float boilingBlood = noise(uv * 8.0 + Time * 5.0);
    float bloodVeins = sin(uv.x * 100.0 + Time * 8.0) * sin(uv.y * 80.0 + Time * 6.0) * 0.3;

    vec3 bloodTint = vec3((0.7 + boilingBlood * 0.3) * redReduce, // 减少基础红色
    0.1 + bloodVeins * 0.1, // 稍微恢复一些绿色
    0.1); // 稍微恢复一些蓝色

    // 原始野性红色
    vec3 savageRed = distortedColor;

    // 极度增强红色 - 应用红色减少因子
    float redRage = RedIntensity * Alpha * (0.4 + violentPulse * 0.3) * redReduce; // 减少红色增强
    savageRed.r += redRage;
    savageRed.r *= 1.2 + rageHeartbeat * 0.2; // 减少红色乘法增强

    // 减少对其他颜色的压制
    savageRed.g *= 0.5 - violentPulse * 0.1; // 恢复一些绿色
    savageRed.b *= 0.4 - chaosRhythm * 0.1; // 恢复一些蓝色

    // 血色覆盖 - 减少混合强度
    savageRed = mix(savageRed, bloodTint, RedIntensity * (0.3 + violentPulse * 0.2) * redReduce);

    // 添加血色扫描线和闪烁 - 减少强度
    float bloodScan = sin(uv.y * 800.0 + Time * 20.0) * 0.1 * RedIntensity * redReduce;
    savageRed.r += bloodScan;

    savageRed = clamp(savageRed, 0.0, 1.5); // 允许过曝

    // 狂暴的暗角效果 - 边缘完全血红
    vec2 centerVec = uv - 0.5;
    float rageVignette = 1.0 - dot(centerVec, centerVec) * 1.2;
    rageVignette = pow(rageVignette, 0.5);

    // 边缘增强红色色差效果 - 减少强度
    float edgeChromatic = (1.0 - rageVignette) * chromaticIntensity * 2.0 * redReduce;
    vec2 edgeRedUV = uv + redOffsetDirection * edgeChromatic;
    float edgeRed = texture(DiffuseSampler, edgeRedUV).r;

    // 边缘变成深红色并增强色差 - 减少红色增强
    vec3 edgeRage = savageRed;
    edgeRage.r = mix(edgeRage.r, edgeRed, (1.0 - rageVignette) * 0.6 * redReduce);
    edgeRage.r += (1.0 - rageVignette) * RedIntensity * 0.5 * redReduce; // 减少边缘红色增强
    edgeRage.g *= 0.4; // 恢复一些绿色
    edgeRage.b *= 0.3; // 恢复一些蓝色

    savageRed = mix(edgeRage, savageRed, rageVignette);

    // 最终过曝处理 - 制造狂暴的视觉冲击
    savageRed = clamp(savageRed, 0.0, 2.0);
    savageRed = pow(savageRed, vec3(0.9)); // 稍微压暗避免过度曝光

    fragColor = vec4(savageRed, originalColor.a);
}