/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.screen;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.saksolm.monsterexpansion.block.ModBlocks;
import net.saksolm.monsterexpansion.recipe.FoundryRecipe;
import net.saksolm.monsterexpansion.screen.FoundryResultSlot;

public class FoundryMenu
extends AbstractContainerMenu {
    private static final int CRAFTING_GRID_SIZE = 5;
    private static final int RESULT_SLOT_INDEX = 25;
    private final int containerSize = 25;
    private final ContainerLevelAccess access;
    private final Player player;
    private final ResultContainer resultContainer = new ResultContainer();
    private final FoundryCraftingContainer craftingContainer;

    public FoundryMenu(int pContainerId, Inventory pPlayerInventory, FriendlyByteBuf pBuffer) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.m_39289_((Level)pPlayerInventory.f_35978_.m_9236_(), (BlockPos)pBuffer.m_130135_()));
    }

    public FoundryMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)ModBlocks.FOUNDRY_MENU.get(), pContainerId);
        int col;
        int row;
        this.access = pAccess;
        this.player = pPlayerInventory.f_35978_;
        this.craftingContainer = new FoundryCraftingContainer(5, 5);
        for (row = 0; row < 5; ++row) {
            for (col = 0; col < 5; ++col) {
                this.m_38897_(new Slot((Container)this.craftingContainer, col + row * 5, 17 + col * 18, 19 + row * 18));
            }
        }
        this.m_38897_((Slot)new FoundryResultSlot(pPlayerInventory.f_35978_, this.craftingContainer, (Container)this.resultContainer, 25, 147, 56));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)pPlayerInventory, col + row * 9 + 9, 12 + col * 18, 127 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.m_38897_(new Slot((Container)pPlayerInventory, col2, 12 + col2 * 18, 185));
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int craftGridSlots = this.containerSize;
            int resultSlot = this.containerSize;
            int playerInvStart = craftGridSlots + 1;
            int playerInvEnd = this.f_38839_.size();
            if (pIndex == resultSlot) {
                this.access.m_39292_((level, pos) -> itemstack1.m_41720_().m_7836_(itemstack1, level, pPlayer));
                if (!this.m_38903_(itemstack1, playerInvStart, playerInvEnd, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex >= playerInvStart && pIndex < playerInvEnd ? !this.m_38903_(itemstack1, 0, craftGridSlots, false) : pIndex >= 0 && pIndex < craftGridSlots && !this.m_38903_(itemstack1, playerInvStart, playerInvEnd, true)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            this.m_38946_();
        }
        return itemstack;
    }

    public boolean m_6875_(Player pPlayer) {
        return FoundryMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)ModBlocks.FOUNDRY.get()));
    }

    public void m_6199_(Container pContainer) {
        this.access.m_39292_((level, pos) -> FoundryMenu.updateCraftingResult(this, level, this.player, this.craftingContainer, this.resultContainer));
    }

    protected static void updateCraftingResult(AbstractContainerMenu pMenu, Level pLevel, Player pPlayer, CraftingContainer pCraftingContainer, ResultContainer pResultContainer) {
        if (!pLevel.f_46443_) {
            RecipeManager recipeManager = pLevel.m_7465_();
            Optional optionalRecipe = recipeManager.m_44015_((RecipeType)ModBlocks.FOUNDRY_RECIPE_TYPE.get(), (Container)pCraftingContainer, pLevel);
            if (optionalRecipe.isPresent()) {
                FoundryRecipe foundryRecipe = (FoundryRecipe)optionalRecipe.get();
                pResultContainer.m_6029_((Recipe)foundryRecipe);
                pResultContainer.m_6836_(0, foundryRecipe.m_5874_((Container)pCraftingContainer, pLevel.m_9598_()));
            } else {
                pResultContainer.m_6836_(0, ItemStack.f_41583_);
            }
            pMenu.m_38946_();
        }
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((p_39785_, p_39786_) -> this.m_150411_(pPlayer, (Container)this.craftingContainer));
    }

    private class FoundryCraftingContainer
    implements CraftingContainer {
        private final NonNullList<ItemStack> internalInventory;
        private final int width;
        private final int height;

        public FoundryCraftingContainer(int width, int height) {
            this.width = width;
            this.height = height;
            this.internalInventory = NonNullList.m_122780_((int)(width * height), (Object)ItemStack.f_41583_);
        }

        public int m_6643_() {
            return this.internalInventory.size();
        }

        public boolean m_7983_() {
            for (ItemStack stack : this.internalInventory) {
                if (stack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        public ItemStack m_8020_(int i) {
            return (ItemStack)this.internalInventory.get(i);
        }

        public ItemStack m_7407_(int i, int i1) {
            ItemStack itemstack = ItemStack.f_41583_;
            if (i >= 0 && i < this.internalInventory.size()) {
                itemstack = (ItemStack)this.internalInventory.get(i);
                if (itemstack.m_41613_() > i1) {
                    itemstack = itemstack.m_41620_(i1);
                } else {
                    this.internalInventory.set(i, (Object)ItemStack.f_41583_);
                }
            }
            if (!itemstack.m_41619_()) {
                this.m_6596_();
            }
            return itemstack;
        }

        public ItemStack m_8016_(int i) {
            ItemStack itemstack = ItemStack.f_41583_;
            if (i >= 0 && i < this.internalInventory.size()) {
                itemstack = (ItemStack)this.internalInventory.get(i);
                this.internalInventory.set(i, (Object)ItemStack.f_41583_);
            }
            return itemstack;
        }

        public void m_6836_(int i, ItemStack itemStack) {
            this.internalInventory.set(i, (Object)itemStack);
            this.m_6596_();
        }

        public void m_6596_() {
            FoundryMenu.this.m_6199_((Container)this);
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public int m_39347_() {
            return this.width;
        }

        public int m_39346_() {
            return this.height;
        }

        public List<ItemStack> m_280657_() {
            return this.internalInventory;
        }

        public void m_6211_() {
            this.internalInventory.clear();
        }

        public void m_5809_(StackedContents stackedContents) {
            for (ItemStack stack : this.internalInventory) {
                stackedContents.m_36491_(stack);
            }
        }
    }
}

