/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.recipe.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.saksolm.monsterexpansion.block.ModBlocks;
import net.saksolm.monsterexpansion.recipe.FoundryRecipe;
import net.saksolm.monsterexpansion.screen.FoundryScreen;

@JeiPlugin
public class FoundryJeiPlugin
implements IModPlugin {
    public static final RecipeType<FoundryRecipe> FOUNDRY_TYPE = new RecipeType(new ResourceLocation("monsterexpansion", "foundry"), FoundryRecipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("monsterexpansion", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new FoundryRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.m_91087_().f_91073_.m_7465_();
        List recipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModBlocks.FOUNDRY_RECIPE_TYPE.get());
        registration.addRecipes(FOUNDRY_TYPE, recipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(FoundryScreen.class, 130, 60, 20, 20, new RecipeType[]{FOUNDRY_TYPE});
    }

    public static class FoundryRecipeCategory
    implements IRecipeCategory<FoundryRecipe> {
        public static final ResourceLocation TEXTURE = new ResourceLocation("monsterexpansion", "textures/gui/foundry_gui.png");
        private final IDrawable background;
        private final IDrawable icon;

        public FoundryRecipeCategory(IGuiHelper helper) {
            this.background = helper.createDrawable(TEXTURE, 0, 0, 184, 206);
            this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FOUNDRY.get()));
        }

        public RecipeType<FoundryRecipe> getRecipeType() {
            return FOUNDRY_TYPE;
        }

        public Component getTitle() {
            return Component.m_237115_((String)"block.monsterexpansion.foundry");
        }

        public IDrawable getBackground() {
            return this.background;
        }

        public IDrawable getIcon() {
            return this.icon;
        }

        public void setRecipe(IRecipeLayoutBuilder builder, FoundryRecipe recipe, IFocusGroup focuses) {
            int craftingGridSize = 5;
            for (int row = 0; row < craftingGridSize; ++row) {
                for (int col = 0; col < craftingGridSize; ++col) {
                    if (recipe.m_7527_().size() <= col + row * craftingGridSize) continue;
                    Ingredient ingredient = (Ingredient)recipe.m_7527_().get(col + row * craftingGridSize);
                    builder.addSlot(RecipeIngredientRole.INPUT, 17 + col * 18, 19 + row * 18).addIngredients(ingredient);
                }
            }
            builder.addSlot(RecipeIngredientRole.OUTPUT, 147, 56).addItemStack(recipe.m_8043_(null));
        }
    }
}

